/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
	"time"
)

// checks if the GalaxyCollectionResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &GalaxyCollectionResponse{}

// GalaxyCollectionResponse A serializer for a Collection.
type GalaxyCollectionResponse struct {
	Id string `json:"id"`
	Name string `json:"name"`
	// Create a namespace dict.
	Namespace map[string]interface{} `json:"namespace,omitempty"`
	// Get href.
	Href *string `json:"href,omitempty"`
	// Get versions_url.
	VersionsUrl *string `json:"versions_url,omitempty"`
	Created time.Time `json:"created"`
	Modified time.Time `json:"modified"`
	// Get latest version.
	LatestVersion map[string]interface{} `json:"latest_version,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _GalaxyCollectionResponse GalaxyCollectionResponse

// NewGalaxyCollectionResponse instantiates a new GalaxyCollectionResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGalaxyCollectionResponse(id string, name string, created time.Time, modified time.Time) *GalaxyCollectionResponse {
	this := GalaxyCollectionResponse{}
	this.Id = id
	this.Name = name
	this.Created = created
	this.Modified = modified
	return &this
}

// NewGalaxyCollectionResponseWithDefaults instantiates a new GalaxyCollectionResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGalaxyCollectionResponseWithDefaults() *GalaxyCollectionResponse {
	this := GalaxyCollectionResponse{}
	return &this
}

// GetId returns the Id field value
func (o *GalaxyCollectionResponse) GetId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionResponse) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *GalaxyCollectionResponse) SetId(v string) {
	o.Id = v
}

// GetName returns the Name field value
func (o *GalaxyCollectionResponse) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionResponse) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *GalaxyCollectionResponse) SetName(v string) {
	o.Name = v
}

// GetNamespace returns the Namespace field value if set, zero value otherwise.
func (o *GalaxyCollectionResponse) GetNamespace() map[string]interface{} {
	if o == nil || IsNil(o.Namespace) {
		var ret map[string]interface{}
		return ret
	}
	return o.Namespace
}

// GetNamespaceOk returns a tuple with the Namespace field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionResponse) GetNamespaceOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.Namespace) {
		return map[string]interface{}{}, false
	}
	return o.Namespace, true
}

// HasNamespace returns a boolean if a field has been set.
func (o *GalaxyCollectionResponse) HasNamespace() bool {
	if o != nil && !IsNil(o.Namespace) {
		return true
	}

	return false
}

// SetNamespace gets a reference to the given map[string]interface{} and assigns it to the Namespace field.
func (o *GalaxyCollectionResponse) SetNamespace(v map[string]interface{}) {
	o.Namespace = v
}

// GetHref returns the Href field value if set, zero value otherwise.
func (o *GalaxyCollectionResponse) GetHref() string {
	if o == nil || IsNil(o.Href) {
		var ret string
		return ret
	}
	return *o.Href
}

// GetHrefOk returns a tuple with the Href field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionResponse) GetHrefOk() (*string, bool) {
	if o == nil || IsNil(o.Href) {
		return nil, false
	}
	return o.Href, true
}

// HasHref returns a boolean if a field has been set.
func (o *GalaxyCollectionResponse) HasHref() bool {
	if o != nil && !IsNil(o.Href) {
		return true
	}

	return false
}

// SetHref gets a reference to the given string and assigns it to the Href field.
func (o *GalaxyCollectionResponse) SetHref(v string) {
	o.Href = &v
}

// GetVersionsUrl returns the VersionsUrl field value if set, zero value otherwise.
func (o *GalaxyCollectionResponse) GetVersionsUrl() string {
	if o == nil || IsNil(o.VersionsUrl) {
		var ret string
		return ret
	}
	return *o.VersionsUrl
}

// GetVersionsUrlOk returns a tuple with the VersionsUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionResponse) GetVersionsUrlOk() (*string, bool) {
	if o == nil || IsNil(o.VersionsUrl) {
		return nil, false
	}
	return o.VersionsUrl, true
}

// HasVersionsUrl returns a boolean if a field has been set.
func (o *GalaxyCollectionResponse) HasVersionsUrl() bool {
	if o != nil && !IsNil(o.VersionsUrl) {
		return true
	}

	return false
}

// SetVersionsUrl gets a reference to the given string and assigns it to the VersionsUrl field.
func (o *GalaxyCollectionResponse) SetVersionsUrl(v string) {
	o.VersionsUrl = &v
}

// GetCreated returns the Created field value
func (o *GalaxyCollectionResponse) GetCreated() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.Created
}

// GetCreatedOk returns a tuple with the Created field value
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionResponse) GetCreatedOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Created, true
}

// SetCreated sets field value
func (o *GalaxyCollectionResponse) SetCreated(v time.Time) {
	o.Created = v
}

// GetModified returns the Modified field value
func (o *GalaxyCollectionResponse) GetModified() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.Modified
}

// GetModifiedOk returns a tuple with the Modified field value
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionResponse) GetModifiedOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Modified, true
}

// SetModified sets field value
func (o *GalaxyCollectionResponse) SetModified(v time.Time) {
	o.Modified = v
}

// GetLatestVersion returns the LatestVersion field value if set, zero value otherwise.
func (o *GalaxyCollectionResponse) GetLatestVersion() map[string]interface{} {
	if o == nil || IsNil(o.LatestVersion) {
		var ret map[string]interface{}
		return ret
	}
	return o.LatestVersion
}

// GetLatestVersionOk returns a tuple with the LatestVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GalaxyCollectionResponse) GetLatestVersionOk() (map[string]interface{}, bool) {
	if o == nil || IsNil(o.LatestVersion) {
		return map[string]interface{}{}, false
	}
	return o.LatestVersion, true
}

// HasLatestVersion returns a boolean if a field has been set.
func (o *GalaxyCollectionResponse) HasLatestVersion() bool {
	if o != nil && !IsNil(o.LatestVersion) {
		return true
	}

	return false
}

// SetLatestVersion gets a reference to the given map[string]interface{} and assigns it to the LatestVersion field.
func (o *GalaxyCollectionResponse) SetLatestVersion(v map[string]interface{}) {
	o.LatestVersion = v
}

func (o GalaxyCollectionResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o GalaxyCollectionResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["name"] = o.Name
	if !IsNil(o.Namespace) {
		toSerialize["namespace"] = o.Namespace
	}
	if !IsNil(o.Href) {
		toSerialize["href"] = o.Href
	}
	if !IsNil(o.VersionsUrl) {
		toSerialize["versions_url"] = o.VersionsUrl
	}
	toSerialize["created"] = o.Created
	toSerialize["modified"] = o.Modified
	if !IsNil(o.LatestVersion) {
		toSerialize["latest_version"] = o.LatestVersion
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *GalaxyCollectionResponse) UnmarshalJSON(bytes []byte) (err error) {
	varGalaxyCollectionResponse := _GalaxyCollectionResponse{}

	if err = json.Unmarshal(bytes, &varGalaxyCollectionResponse); err == nil {
		*o = GalaxyCollectionResponse(varGalaxyCollectionResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "id")
		delete(additionalProperties, "name")
		delete(additionalProperties, "namespace")
		delete(additionalProperties, "href")
		delete(additionalProperties, "versions_url")
		delete(additionalProperties, "created")
		delete(additionalProperties, "modified")
		delete(additionalProperties, "latest_version")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableGalaxyCollectionResponse struct {
	value *GalaxyCollectionResponse
	isSet bool
}

func (v NullableGalaxyCollectionResponse) Get() *GalaxyCollectionResponse {
	return v.value
}

func (v *NullableGalaxyCollectionResponse) Set(val *GalaxyCollectionResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableGalaxyCollectionResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableGalaxyCollectionResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGalaxyCollectionResponse(val *GalaxyCollectionResponse) *NullableGalaxyCollectionResponse {
	return &NullableGalaxyCollectionResponse{value: val, isSet: true}
}

func (v NullableGalaxyCollectionResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGalaxyCollectionResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


