/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentCollectionMarksAPIService ContentCollectionMarksAPI service
type ContentCollectionMarksAPIService service

type ContentCollectionMarksAPIContentAnsibleCollectionMarksCreateRequest struct {
	ctx context.Context
	ApiService *ContentCollectionMarksAPIService
	ansibleCollectionVersionMark *AnsibleCollectionVersionMark
}

func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksCreateRequest) AnsibleCollectionVersionMark(ansibleCollectionVersionMark AnsibleCollectionVersionMark) ContentCollectionMarksAPIContentAnsibleCollectionMarksCreateRequest {
	r.ansibleCollectionVersionMark = &ansibleCollectionVersionMark
	return r
}

func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksCreateRequest) Execute() (*AnsibleCollectionVersionMarkResponse, *http.Response, error) {
	return r.ApiService.ContentAnsibleCollectionMarksCreateExecute(r)
}

/*
ContentAnsibleCollectionMarksCreate Create a collection version mark

ViewSet for looking at mark objects for CollectionVersion content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentCollectionMarksAPIContentAnsibleCollectionMarksCreateRequest
*/
func (a *ContentCollectionMarksAPIService) ContentAnsibleCollectionMarksCreate(ctx context.Context) ContentCollectionMarksAPIContentAnsibleCollectionMarksCreateRequest {
	return ContentCollectionMarksAPIContentAnsibleCollectionMarksCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AnsibleCollectionVersionMarkResponse
func (a *ContentCollectionMarksAPIService) ContentAnsibleCollectionMarksCreateExecute(r ContentCollectionMarksAPIContentAnsibleCollectionMarksCreateRequest) (*AnsibleCollectionVersionMarkResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleCollectionVersionMarkResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentCollectionMarksAPIService.ContentAnsibleCollectionMarksCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/ansible/collection_marks/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleCollectionVersionMark == nil {
		return localVarReturnValue, nil, reportError("ansibleCollectionVersionMark is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleCollectionVersionMark
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest struct {
	ctx context.Context
	ApiService *ContentCollectionMarksAPIService
	limit *int32
	markedCollection *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	value *string
	valueIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) Limit(limit int32) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.limit = &limit
	return r
}

// Filter marks for collection version
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) MarkedCollection(markedCollection string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.markedCollection = &markedCollection
	return r
}

// The initial index from which to return the results.
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) Offset(offset int32) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;value&#x60; - Value * &#x60;-value&#x60; - Value (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) Ordering(ordering []string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) PulpHrefIn(pulpHrefIn []string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) PulpIdIn(pulpIdIn []string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository Version referenced by HREF
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) RepositoryVersion(repositoryVersion string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// Filter marks by value
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) Value(value string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.value = &value
	return r
}

// Filter results where value is in a comma-separated list of values
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) ValueIn(valueIn []string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.valueIn = &valueIn
	return r
}

// A list of fields to include in the response.
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) Fields(fields []string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) ExcludeFields(excludeFields []string) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) Execute() (*PaginatedansibleCollectionVersionMarkResponseList, *http.Response, error) {
	return r.ApiService.ContentAnsibleCollectionMarksListExecute(r)
}

/*
ContentAnsibleCollectionMarksList List collection version marks

ViewSet for looking at mark objects for CollectionVersion content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest
*/
func (a *ContentCollectionMarksAPIService) ContentAnsibleCollectionMarksList(ctx context.Context) ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest {
	return ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedansibleCollectionVersionMarkResponseList
func (a *ContentCollectionMarksAPIService) ContentAnsibleCollectionMarksListExecute(r ContentCollectionMarksAPIContentAnsibleCollectionMarksListRequest) (*PaginatedansibleCollectionVersionMarkResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedansibleCollectionVersionMarkResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentCollectionMarksAPIService.ContentAnsibleCollectionMarksList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/ansible/collection_marks/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.markedCollection != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "marked_collection", r.markedCollection, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.value != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "value", r.value, "")
	}
	if r.valueIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "value__in", r.valueIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentCollectionMarksAPIContentAnsibleCollectionMarksReadRequest struct {
	ctx context.Context
	ApiService *ContentCollectionMarksAPIService
	ansibleCollectionVersionMarkHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksReadRequest) Fields(fields []string) ContentCollectionMarksAPIContentAnsibleCollectionMarksReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksReadRequest) ExcludeFields(excludeFields []string) ContentCollectionMarksAPIContentAnsibleCollectionMarksReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentCollectionMarksAPIContentAnsibleCollectionMarksReadRequest) Execute() (*AnsibleCollectionVersionMarkResponse, *http.Response, error) {
	return r.ApiService.ContentAnsibleCollectionMarksReadExecute(r)
}

/*
ContentAnsibleCollectionMarksRead Inspect a collection version mark

ViewSet for looking at mark objects for CollectionVersion content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleCollectionVersionMarkHref
 @return ContentCollectionMarksAPIContentAnsibleCollectionMarksReadRequest
*/
func (a *ContentCollectionMarksAPIService) ContentAnsibleCollectionMarksRead(ctx context.Context, ansibleCollectionVersionMarkHref string) ContentCollectionMarksAPIContentAnsibleCollectionMarksReadRequest {
	return ContentCollectionMarksAPIContentAnsibleCollectionMarksReadRequest{
		ApiService: a,
		ctx: ctx,
		ansibleCollectionVersionMarkHref: ansibleCollectionVersionMarkHref,
	}
}

// Execute executes the request
//  @return AnsibleCollectionVersionMarkResponse
func (a *ContentCollectionMarksAPIService) ContentAnsibleCollectionMarksReadExecute(r ContentCollectionMarksAPIContentAnsibleCollectionMarksReadRequest) (*AnsibleCollectionVersionMarkResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleCollectionVersionMarkResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentCollectionMarksAPIService.ContentAnsibleCollectionMarksRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_collection_version_mark_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_collection_version_mark_href"+"}", parameterValueToString(r.ansibleCollectionVersionMarkHref, "ansibleCollectionVersionMarkHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
