/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the AnsibleCollection type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AnsibleCollection{}

// AnsibleCollection A serializer for Ansible Collections.
type AnsibleCollection struct {
	// The name of the Collection.
	Name string `json:"name"`
	// The namespace of the Collection.
	Namespace string `json:"namespace"`
	AdditionalProperties map[string]interface{}
}

type _AnsibleCollection AnsibleCollection

// NewAnsibleCollection instantiates a new AnsibleCollection object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAnsibleCollection(name string, namespace string) *AnsibleCollection {
	this := AnsibleCollection{}
	this.Name = name
	this.Namespace = namespace
	return &this
}

// NewAnsibleCollectionWithDefaults instantiates a new AnsibleCollection object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAnsibleCollectionWithDefaults() *AnsibleCollection {
	this := AnsibleCollection{}
	return &this
}

// GetName returns the Name field value
func (o *AnsibleCollection) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *AnsibleCollection) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *AnsibleCollection) SetName(v string) {
	o.Name = v
}

// GetNamespace returns the Namespace field value
func (o *AnsibleCollection) GetNamespace() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Namespace
}

// GetNamespaceOk returns a tuple with the Namespace field value
// and a boolean to check if the value has been set.
func (o *AnsibleCollection) GetNamespaceOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Namespace, true
}

// SetNamespace sets field value
func (o *AnsibleCollection) SetNamespace(v string) {
	o.Namespace = v
}

func (o AnsibleCollection) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AnsibleCollection) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name
	toSerialize["namespace"] = o.Namespace

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AnsibleCollection) UnmarshalJSON(bytes []byte) (err error) {
	varAnsibleCollection := _AnsibleCollection{}

	if err = json.Unmarshal(bytes, &varAnsibleCollection); err == nil {
		*o = AnsibleCollection(varAnsibleCollection)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		delete(additionalProperties, "namespace")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAnsibleCollection struct {
	value *AnsibleCollection
	isSet bool
}

func (v NullableAnsibleCollection) Get() *AnsibleCollection {
	return v.value
}

func (v *NullableAnsibleCollection) Set(val *AnsibleCollection) {
	v.value = val
	v.isSet = true
}

func (v NullableAnsibleCollection) IsSet() bool {
	return v.isSet
}

func (v *NullableAnsibleCollection) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAnsibleCollection(val *AnsibleCollection) *NullableAnsibleCollection {
	return &NullableAnsibleCollection{value: val, isSet: true}
}

func (v NullableAnsibleCollection) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAnsibleCollection) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


