# *Percona XtraBackup* 2.4.3

Percona is glad to announce the release of *Percona XtraBackup* 2.4.3
on May 23rd 2016. Downloads are available from our [download site](http://www.percona.com/downloads/XtraBackup/) and from [apt](../../installation/apt_repo.md#apt-repo) and [yum](../../installation/yum_repo.md#yum-repo) repositories.

This release is the GA (Generally Available) stable release in the 2.4
series.

## New features

*Percona XtraBackup* has implemented new
`xtrabackup --reencrypt-for-server-id` option. Using this option
allows users to start the server instance with different `server_id`
from the one the encrypted backup was taken from, like a replication slave
or a galera node. When this option is used, *xtrabackup* will, as a prepare
step, generate a new master key with ID based on the new `server_id`,
store it into keyring file and re-encrypt the tablespace keys inside of
tablespace headers.

## Bugs Fixed

* Running DDL statements on *Percona Server for MySQL* 5.7 during the backup process
could in some cases lead to failure while preparing the backup. Bug fixed
[PXB-247](https://jira.percona.com/browse/PXB-247).

* *MySQL* 5.7 can sometimes skip redo logging when creating an index. If such
`ALTER TABLE` is being issued during the backup, the backup would be
inconsistent. *xtrabackup* will now abort with error message if such `ALTER
TABLE` has been done during the backup. Bug fixed [PXB-249](https://jira.percona.com/browse/PXB-249).

* `.ibd` files for remote tablespaces were not copied back to original
location pointed by the .isl files. Bug fixed [PXB-466](https://jira.percona.com/browse/PXB-466).

* When called with insufficient parameters, like specifying the empty
`xtrabackup --defaults-file` option, *Percona XtraBackup* could crash.
Bug fixed [PXB-471](https://jira.percona.com/browse/PXB-471).

* Documentation states that the default value for
`xtrabackup --ftwrl-wait-query-type` is `all`, however it was
`update`. Changed the default value to reflect the documentation. Bug fixed
[PXB-472](https://jira.percona.com/browse/PXB-472).

* When `xtrabackup --keyring-file-data` option was specified, but no
keyring file was found, *xtrabackup* would create an empty one instead of
reporting an error. Bug fixed [PXB-476](https://jira.percona.com/browse/PXB-476).

* If `ALTER INSTANCE ROTATE INNODB MASTER KEY` was run at same time when
`xtrabackup --backup` was bootstrapping it could catch a moment when
the key was not written into the keyring file yet and *xtrabackup* would
overwrite the keyring with the old copy of a keyring, so the new key would be
lost. Bug fixed [PXB-478](https://jira.percona.com/browse/PXB-478).

* Output of `xtrabackup --slave-info` option was missing an apostrophe.
Bug fixed [PXB-940](https://jira.percona.com/browse/PXB-940).
