/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.cli;

import com.netscape.ca.CASigningUnit;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.security.SigningUnitConfig;
import com.netscape.cms.servlet.csadmin.BootstrapProfile;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.DatabaseConfig;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.ConfigStorage;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.Repository;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.security.SecureRandomConfig;
import com.netscape.cmscore.security.SecureRandomFactory;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.codec.binary.Hex;
import org.apache.tomcat.util.net.jss.TomcatJSS;
import org.dogtag.util.cert.CertUtil;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CLIException;
import org.dogtagpki.cli.CommandCLI;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.dogtagpki.util.logging.PKILogger;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.netscape.security.pkcs.PKCS10;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateIssuerName;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertCreateCLI
extends CommandCLI {
    public static final Logger logger = LoggerFactory.getLogger(CACertCreateCLI.class);

    public CACertCreateCLI(CLI parent) {
        super("create", "Create certificate from certificate request in CA", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "request", true, "Request ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "profile", true, "Profile ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "type", true, "Certificate type: selfsign (default), local");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "key-id", true, "Key ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "key-token", true, "Key token");
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option(null, "key-algorithm", true, "Key algorithm (default: SHA256withRSA)");
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option(null, "signing-algorithm", true, "Signing algorithm (default: SHA256withRSA)");
        option.setArgName("name");
        this.options.addOption(option);
        option = new Option(null, "serial", true, "Certificate serial number");
        option.setArgName("serial");
        this.options.addOption(option);
        option = new Option(null, "format", true, "Certificate format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "cert", true, "Certificate path");
        option.setArgName("path");
        this.options.addOption(option);
        this.options.addOption("v", "verbose", false, "Run in verbose mode.");
        this.options.addOption(null, "debug", false, "Run in debug mode.");
        this.options.addOption(null, "help", false, "Show help message.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        block32: {
            if (cmd.hasOption("debug")) {
                PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.DEBUG);
            } else if (cmd.hasOption("verbose")) {
                PKILogger.setLevel((PKILogger.LogLevel)PKILogger.LogLevel.INFO);
            }
            String requestID = cmd.getOptionValue("request");
            if (requestID == null) {
                throw new CLIException("Missing request ID");
            }
            String profileID = cmd.getOptionValue("profile");
            if (profileID == null) {
                throw new CLIException("Missing profile ID");
            }
            String serial = cmd.getOptionValue("serial");
            String certType = cmd.getOptionValue("type", "selfsign");
            String tokenName = cmd.getOptionValue("key-token");
            String keyAlgorithm = cmd.getOptionValue("key-algorithm", "SHA256withRSA");
            String signingAlgorithm = cmd.getOptionValue("signing-algorithm", "SHA256withRSA");
            String certFormat = cmd.getOptionValue("format", "PEM");
            String certPath = cmd.getOptionValue("cert");
            TomcatJSS tomcatjss = TomcatJSS.getInstance();
            tomcatjss.loadConfig();
            tomcatjss.init();
            String instanceDir = CMS.getInstanceDir();
            String subsystem = this.parent.getParent().getName();
            String confDir = instanceDir + File.separator + subsystem + File.separator + "conf";
            String configFile = confDir + File.separator + "CS.cfg";
            logger.info("Loading " + configFile);
            FileConfigStorage storage = new FileConfigStorage(configFile);
            CAEngineConfig cs = new CAEngineConfig((ConfigStorage)storage);
            cs.load();
            String profilePath = confDir + File.separator + profileID;
            logger.info("Loading " + profilePath);
            FileConfigStorage profileStorage = new FileConfigStorage(profilePath);
            ConfigStore profileConfig = new ConfigStore((ConfigStorage)profileStorage);
            profileConfig.load();
            BootstrapProfile profile = new BootstrapProfile(cs, profileConfig);
            DatabaseConfig dbConfig = cs.getDatabaseConfig();
            LDAPConfig ldapConfig = dbConfig.getLDAPConfig();
            ldapConfig.putInteger("minConns", 1);
            PKISocketConfig socketConfig = cs.getSocketConfig();
            PasswordStoreConfig psc = cs.getPasswordStoreConfig();
            PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
            SecureRandomConfig secureRandomConfig = cs.getJssSubsystemConfig().getSecureRandomConfig();
            SecureRandom secureRandom = SecureRandomFactory.create((SecureRandomConfig)secureRandomConfig);
            DBSubsystem dbSubsystem = new DBSubsystem();
            dbSubsystem.setEngineConfig((EngineConfig)cs);
            dbSubsystem.init(dbConfig, ldapConfig, socketConfig, passwordStore);
            try {
                byte[] bytes;
                BigInteger serialNumber;
                org.mozilla.jss.crypto.PrivateKey signingPrivateKey;
                X500Name issuerName;
                X509Key x509key;
                X500Name subjectName;
                CertRequestRepository requestRepository = new CertRequestRepository(secureRandom, dbSubsystem);
                requestRepository.init();
                Request requestRecord = requestRepository.readRequest(new RequestId(requestID));
                if (requestRecord == null) {
                    throw new CLIException("Certificate request not found: " + requestID);
                }
                String certRequestType = requestRecord.getExtDataInString("cert_request_type");
                logger.info("Request type: " + certRequestType);
                String certRequest = requestRecord.getExtDataInString("cert_request");
                logger.info("Request:\n" + certRequest);
                byte[] binCertRequest = CertUtil.parseCSR((String)certRequest);
                if (certRequestType.equals("crmf")) {
                    SEQUENCE crmfMsgs = CryptoUtil.parseCRMFMsgs((byte[])binCertRequest);
                    subjectName = CryptoUtil.getSubjectName((SEQUENCE)crmfMsgs);
                    x509key = CryptoUtil.getX509KeyFromCRMFMsgs((SEQUENCE)crmfMsgs);
                } else if (certRequestType.equals("pkcs10")) {
                    PKCS10 pkcs10 = new PKCS10(binCertRequest);
                    subjectName = pkcs10.getSubjectName();
                    x509key = pkcs10.getSubjectPublicKeyInfo();
                } else {
                    throw new CLIException("Certificate request type not supported: " + certRequestType);
                }
                logger.info("Subject: " + subjectName);
                logger.info("Cert type: " + certType);
                X509CertImpl signingCert = null;
                if (certType.equals("selfsign")) {
                    CryptoToken token;
                    PK11PrivKey privateKey;
                    String hexKeyID = cmd.getOptionValue("key-id");
                    if (hexKeyID == null) {
                        throw new CLIException("Missing key ID");
                    }
                    logger.info("Key ID: " + hexKeyID);
                    logger.info("Key token: " + tokenName);
                    Object keyID = hexKeyID;
                    if (((String)keyID).startsWith("0x")) {
                        keyID = ((String)keyID).substring(2);
                    }
                    if (((String)keyID).length() % 2 == 1) {
                        keyID = "0" + (String)keyID;
                    }
                    if ((privateKey = (PK11PrivKey)CryptoUtil.findPrivateKey((CryptoToken)(token = CryptoUtil.getKeyStorageToken((String)tokenName)), (byte[])Hex.decodeHex((String)keyID))) == null) {
                        throw new CLIException("Private key not found: " + hexKeyID);
                    }
                    PK11PubKey publicKey = privateKey.getPublicKey();
                    KeyPair keyPair = new KeyPair((PublicKey)publicKey, (PrivateKey)privateKey);
                    issuerName = subjectName;
                    signingPrivateKey = (org.mozilla.jss.crypto.PrivateKey)keyPair.getPrivate();
                } else {
                    CAConfig caConfig = cs.getCAConfig();
                    SigningUnitConfig caSigningCfg = caConfig.getSigningUnitConfig();
                    CASigningUnit signingUnit = new CASigningUnit();
                    signingUnit.init(caSigningCfg, null);
                    signingCert = signingUnit.getCertImpl();
                    CertificateSubjectName certSubjectName = signingCert.getSubjectObj();
                    issuerName = (X500Name)certSubjectName.get("dname");
                    signingPrivateKey = signingUnit.getPrivateKey();
                }
                logger.info("Issuer: " + issuerName);
                CertificateRepository certificateRepository = new CertificateRepository(secureRandom, dbSubsystem);
                certificateRepository.init();
                if (serial == null) {
                    if (certificateRepository.getIDGenerator() != Repository.IDGenerator.RANDOM) {
                        throw new CLIException("Unable to generate random certificate ID");
                    }
                    serialNumber = certificateRepository.getNextSerialNumber();
                } else {
                    serialNumber = new CertId(serial).toBigInteger();
                }
                logger.info("Cert ID: 0x" + Utils.HexEncode((byte[])serialNumber.toByteArray()));
                CertificateIssuerName certIssuerName = new CertificateIssuerName(issuerName);
                CertificateExtensions extensions = new CertificateExtensions();
                Date date = new Date();
                X509CertInfo certInfo = CryptoUtil.createX509CertInfo((X509Key)x509key, (BigInteger)serialNumber, (CertificateIssuerName)certIssuerName, (X500Name)subjectName, (Date)date, (Date)date, (String)keyAlgorithm, (CertificateExtensions)extensions);
                logger.info("Cert info:\n" + certInfo);
                profile.populate(requestRecord, certInfo);
                requestRepository.updateRequest(requestRecord);
                X509CertImpl certImpl = CryptoUtil.signCert((PrivateKey)signingPrivateKey, (X509CertInfo)certInfo, (String)signingAlgorithm);
                if ("PEM".equalsIgnoreCase(certFormat)) {
                    bytes = CertUtil.toPEM((X509Certificate)certImpl).getBytes();
                } else if ("DER".equalsIgnoreCase(certFormat)) {
                    bytes = certImpl.getEncoded();
                } else {
                    throw new CLIException("Unsupported certificate format: " + certFormat);
                }
                if (certPath != null) {
                    try (PrintStream out = new PrintStream(new FileOutputStream(certPath));){
                        out.write(bytes);
                        break block32;
                    }
                }
                System.out.write(bytes);
            }
            finally {
                dbSubsystem.shutdown();
            }
        }
    }
}

