/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import com.netscape.cmsutil.ocsp.KeyHashID;
import com.netscape.cmsutil.ocsp.NameID;
import com.netscape.cmsutil.ocsp.ResponderID;
import com.netscape.cmsutil.ocsp.SingleResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Extension;

public class ResponseData
implements ASN1Value {
    private static final INTEGER v1 = new INTEGER(0L);
    private INTEGER mVer;
    private ResponderID mRID = null;
    private GeneralizedTime mProduced = null;
    private SingleResponse[] mSR = null;
    private Extension[] mExts = null;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public ResponseData(INTEGER ver, ResponderID rid, GeneralizedTime produced, SingleResponse[] sr, Extension[] exts) {
        this.mVer = ver != null ? ver : v1;
        this.mRID = rid;
        this.mProduced = produced;
        this.mSR = sr;
        this.mExts = exts;
    }

    public ResponseData(ResponderID rid, GeneralizedTime produced, SingleResponse[] sr) {
        this(v1, rid, produced, sr, null);
    }

    public ResponseData(ResponderID rid, GeneralizedTime produced, SingleResponse[] sr, Extension[] exts) {
        this(v1, rid, produced, sr, exts);
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream os) throws IOException {
        this.encode(null, os);
    }

    public void encode(Tag t, OutputStream os) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        if (this.mVer != v1) {
            seq.addElement((ASN1Value)new EXPLICIT(Tag.get((long)0L), (ASN1Value)new INTEGER((BigInteger)this.mVer)));
        }
        seq.addElement((ASN1Value)new EXPLICIT(this.mRID.getTag(), (ASN1Value)this.mRID));
        seq.addElement((ASN1Value)this.mProduced);
        SEQUENCE responses = new SEQUENCE();
        for (int i = 0; i < this.mSR.length; ++i) {
            responses.addElement((ASN1Value)this.mSR[i]);
        }
        seq.addElement((ASN1Value)responses);
        if (this.mExts != null) {
            SEQUENCE exts = new SEQUENCE();
            for (int i = 0; i < this.mExts.length; ++i) {
                exts.addElement((ASN1Value)this.mExts[i]);
            }
            seq.addElement((ASN1Value)new EXPLICIT(Tag.get((long)1L), (ASN1Value)exts));
        }
        if (t == null) {
            seq.encode(os);
        } else {
            seq.encode(t, os);
        }
    }

    public ResponderID getResponderID() {
        return this.mRID;
    }

    public GeneralizedTime getProducedAt() {
        return this.mProduced;
    }

    public int getResponseCount() {
        return this.mSR != null ? this.mSR.length : 0;
    }

    public SingleResponse getResponseAt(int pos) {
        return this.mSR != null ? this.mSR[pos] : null;
    }

    public int getResponseExtensionCount() {
        return this.mExts != null ? this.mExts.length : 0;
    }

    public Extension getResponseExtensionAt(int pos) {
        return this.mExts != null ? this.mExts[pos] : null;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new INTEGER.Template()));
            this.seqt.addElement((ASN1Template)new ANY.Template());
            this.seqt.addElement((ASN1Template)new GeneralizedTime.Template());
            this.seqt.addElement((ASN1Template)new SEQUENCE.OF_Template((ASN1Template)SingleResponse.getTemplate()));
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(1L), (ASN1Template)new SEQUENCE.OF_Template((ASN1Template)Extension.getTemplate())));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            INTEGER ver = v1;
            EXPLICIT e_ver = (EXPLICIT)seq.elementAt(0);
            if (e_ver != null && e_ver.getTag().getNum() == 0L) {
                ver = (INTEGER)e_ver.getContent();
            }
            ResponderID rid = null;
            ANY e_rid = (ANY)seq.elementAt(1);
            if (e_rid.getTag().getNum() == 1L) {
                rid = (NameID)NameID.getTemplate().decode(e_rid.getTag(), new ByteArrayInputStream(e_rid.getEncoded()));
            } else if (e_rid.getTag().getNum() == 2L) {
                rid = (KeyHashID)KeyHashID.getTemplate().decode(e_rid.getTag(), new ByteArrayInputStream(e_rid.getEncoded()));
            }
            GeneralizedTime producedAt = (GeneralizedTime)seq.elementAt(2);
            SEQUENCE responses = (SEQUENCE)seq.elementAt(3);
            SingleResponse[] sr = null;
            if (responses != null && responses.size() > 0) {
                sr = new SingleResponse[responses.size()];
                for (int i = 0; i < responses.size(); ++i) {
                    sr[i] = (SingleResponse)responses.elementAt(i);
                }
            }
            EXPLICIT extns_exp = (EXPLICIT)seq.elementAt(4);
            Extension[] extns_array = null;
            if (extns_exp != null) {
                SEQUENCE extns_seq = (SEQUENCE)extns_exp.getContent();
                extns_array = new Extension[extns_seq.size()];
                for (int x = 0; x < extns_array.length; ++x) {
                    extns_array[x] = (Extension)extns_seq.elementAt(x);
                }
            }
            return new ResponseData(ver, rid, producedAt, sr, extns_array);
        }
    }
}

