/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.password;

import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.util.Keyring;
import com.netscape.cmsutil.util.NuxwdogUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class NuxwdogPasswordStore
extends PasswordStore {
    private Hashtable<String, String> pwCache = null;
    private ArrayList<String> tags = null;

    @Override
    public void init(String confFile) throws IOException {
        if (!NuxwdogUtil.startedByNuxwdog()) {
            throw new IOException("process not started by nuxwdog");
        }
        this.tags = new ArrayList();
        if (confFile != null) {
            this.populateTokenTags(confFile);
        }
        this.pwCache = new Hashtable();
    }

    private void populateTokenTags(String confFile) throws IOException {
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(confFile);){
            props.load(in);
        }
        this.tags.add("internal");
        String tokenList = props.getProperty("cms.tokenList");
        if (StringUtils.isNotEmpty((CharSequence)tokenList)) {
            for (String token : StringUtils.split((String)tokenList, (char)',')) {
                this.tags.add("hardware-" + token);
            }
        }
        this.id = props.getProperty("instanceId");
    }

    private void addTag(String tag) {
        if (!this.tags.contains(tag)) {
            this.tags.add(tag);
        }
    }

    @Override
    public String getPassword(String tag, int iteration) {
        if (this.pwCache.containsKey(tag)) {
            return this.pwCache.get(tag);
        }
        String pwd = null;
        String keyringTag = this.id + "/" + tag;
        pwd = Keyring.getPassword(keyringTag, "raw");
        if (pwd != null & pwd.startsWith("keyctl_read_alloc:")) {
            pwd = null;
        }
        if (pwd != null) {
            this.addTag(tag);
        }
        return pwd;
    }

    @Override
    public Enumeration<String> getTags() {
        return Collections.enumeration(this.tags);
    }

    @Override
    public Object putPassword(String tag, String password) {
        this.addTag(tag);
        return this.pwCache.put(tag, password);
    }

    @Override
    public void commit() throws IOException, ClassCastException, NullPointerException {
    }
}

