/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.tps.apdu;

import org.dogtagpki.tps.apdu.APDU;
import org.dogtagpki.tps.main.TPSBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallLoadGP211APDU
extends APDU {
    public static Logger logger = LoggerFactory.getLogger(InstallLoadGP211APDU.class);

    public InstallLoadGP211APDU(TPSBuffer packageAID, TPSBuffer sdAID, int fileLen) {
        this.setCLA((byte)-124);
        this.setINS((byte)-26);
        this.setP1((byte)2);
        this.setP2((byte)0);
        logger.debug("InstlalLoadGP211APDU: packageAID: " + packageAID.toHexString() + " aid size: " + packageAID.size() + " fileLen: " + fileLen);
        TPSBuffer inputData = new TPSBuffer();
        inputData.add((byte)packageAID.size());
        inputData.add(packageAID);
        inputData.add((byte)sdAID.size());
        inputData.add(sdAID);
        inputData.add((byte)0);
        inputData.add((byte)6);
        inputData.add((byte)-17);
        inputData.add((byte)4);
        inputData.add((byte)-58);
        inputData.add((byte)2);
        int finalLen = fileLen + 24 + sdAID.size();
        inputData.addInt2Bytes(finalLen);
        inputData.add((byte)0);
        this.setData(inputData);
        this.trailer = new TPSBuffer();
        this.trailer.add((byte)0);
    }
}

