/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.tps.dbs;

import com.netscape.cmscore.dbs.DBAttribute;
import com.netscape.cmscore.dbs.DBObjectClasses;
import com.netscape.cmscore.dbs.DBRecord;
import java.math.BigInteger;
import java.util.Date;

@DBObjectClasses(value={"top", "tokenCert"})
public class TPSCertRecord
extends DBRecord {
    private static final long serialVersionUID = 1L;
    String id;
    String serialNumber;
    String subject;
    String tokenID;
    String keyType;
    String status;
    String userID;
    String certificate;
    String issuedBy;
    String origin;
    String type;
    Date validNotBefore;
    Date validNotAfter;
    String extensions;
    Date createTime;
    Date modifyTime;

    @DBAttribute(value="cn")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @DBAttribute(value="tokenSerial")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public BigInteger getSerialNumberInBigInteger() {
        if (this.serialNumber == null) {
            return null;
        }
        if (this.serialNumber.length() < 3 || !this.serialNumber.startsWith("0x")) {
            throw new NumberFormatException("Malformed hex serial number: " + this.serialNumber);
        }
        String value = this.serialNumber.substring(2);
        return new BigInteger(value, 16);
    }

    @DBAttribute(value="tokenSubject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @DBAttribute(value="tokenID")
    public String getTokenID() {
        return this.tokenID;
    }

    public void setTokenID(String tokenID) {
        this.tokenID = tokenID;
    }

    @DBAttribute(value="tokenKeyType")
    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    @DBAttribute(value="tokenStatus")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @DBAttribute(value="tokenUserID")
    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    @DBAttribute(value="userCertificate")
    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    @DBAttribute(value="tokenIssuer")
    public String getIssuedBy() {
        return this.issuedBy;
    }

    public void setIssuedBy(String issuedBy) {
        this.issuedBy = issuedBy;
    }

    @DBAttribute(value="tokenOrigin")
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @DBAttribute(value="tokenType")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @DBAttribute(value="tokenNotBefore")
    public Date getValidNotBefore() {
        return this.validNotBefore;
    }

    public void setValidNotBefore(Date validNotBefore) {
        this.validNotBefore = validNotBefore;
    }

    @DBAttribute(value="tokenNotAfter")
    public Date getValidNotAfter() {
        return this.validNotAfter;
    }

    public void setValidNotAfter(Date validNotAfter) {
        this.validNotAfter = validNotAfter;
    }

    @DBAttribute(value="extensions")
    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }

    @DBAttribute(value="dateOfCreate")
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @DBAttribute(value="dateOfModify")
    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
        result = 31 * result + (this.createTime == null ? 0 : this.createTime.hashCode());
        result = 31 * result + (this.extensions == null ? 0 : this.extensions.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.issuedBy == null ? 0 : this.issuedBy.hashCode());
        result = 31 * result + (this.keyType == null ? 0 : this.keyType.hashCode());
        result = 31 * result + (this.modifyTime == null ? 0 : this.modifyTime.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + (this.tokenID == null ? 0 : this.tokenID.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.userID == null ? 0 : this.userID.hashCode());
        result = 31 * result + (this.validNotAfter == null ? 0 : this.validNotAfter.hashCode());
        result = 31 * result + (this.validNotBefore == null ? 0 : this.validNotBefore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TPSCertRecord other = (TPSCertRecord)((Object)obj);
        if (this.certificate == null ? other.certificate != null : !this.certificate.equals(other.certificate)) {
            return false;
        }
        if (this.createTime == null ? other.createTime != null : !this.createTime.equals(other.createTime)) {
            return false;
        }
        if (this.extensions == null ? other.extensions != null : !this.extensions.equals(other.extensions)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.issuedBy == null ? other.issuedBy != null : !this.issuedBy.equals(other.issuedBy)) {
            return false;
        }
        if (this.keyType == null ? other.keyType != null : !this.keyType.equals(other.keyType)) {
            return false;
        }
        if (this.modifyTime == null ? other.modifyTime != null : !this.modifyTime.equals(other.modifyTime)) {
            return false;
        }
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        if (this.serialNumber == null ? other.serialNumber != null : !this.serialNumber.equals(other.serialNumber)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
            return false;
        }
        if (this.tokenID == null ? other.tokenID != null : !this.tokenID.equals(other.tokenID)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.userID == null ? other.userID != null : !this.userID.equals(other.userID)) {
            return false;
        }
        if (this.validNotAfter == null ? other.validNotAfter != null : !this.validNotAfter.equals(other.validNotAfter)) {
            return false;
        }
        return !(this.validNotBefore == null ? other.validNotBefore != null : !this.validNotBefore.equals(other.validNotBefore));
    }
}

