/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs7;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs7.PKCS7CertCLI;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7CertImportCLI
extends CommandCLI {
    private static Logger logger = LoggerFactory.getLogger(PKCS7CertImportCLI.class);
    public PKCS7CertCLI certCLI;

    public PKCS7CertImportCLI(PKCS7CertCLI certCLI) {
        super("import", "Import a certificate into a PKCS #7 file", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "pkcs7", true, "PKCS #7 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "input-file", true, "Path to certificate file to import");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "input-format", true, "Certificate format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
        this.options.addOption(null, "append", false, "Import into an existing PKCS #7 file");
    }

    public void execute(CommandLine cmd) throws Exception {
        String inputFilename;
        PKCS7 pkcs7;
        String filename = cmd.getOptionValue("pkcs7");
        if (filename == null) {
            throw new Exception("Missing PKCS #7 file");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CertificateChain certChain = new CertificateChain();
        Path path = Paths.get(filename, new String[0]);
        boolean append = cmd.hasOption("append");
        if (Files.exists(path, new LinkOption[0]) && append) {
            logger.info("Loading certificates from " + path);
            byte[] bytes = Files.readAllBytes(path);
            pkcs7 = new PKCS7(new String(bytes));
            for (X509Certificate cert : pkcs7.getCertificates()) {
                logger.info(" - " + cert.getSubjectDN());
            }
            certChain.addPKCS7(pkcs7);
        }
        if ((inputFilename = cmd.getOptionValue("input-file")) != null) {
            logger.info("Importing certificates from " + inputFilename);
            byte[] bytes = Files.readAllBytes(Paths.get(inputFilename, new String[0]));
            String string = cmd.getOptionValue("input-format", "PEM");
            if ("PEM".equalsIgnoreCase(string)) {
                CertificateChain inputChain = CertificateChain.fromPEMString((String)new String(bytes));
                for (X509Certificate cert : inputChain.getCertificates()) {
                    logger.info(" - " + cert.getSubjectDN());
                }
                certChain.addCertificateChain(inputChain);
            } else if ("DER".equalsIgnoreCase(string)) {
                X509CertImpl cert = new X509CertImpl(bytes);
                logger.info(" - " + cert.getSubjectDN());
                certChain.addCertificate((X509Certificate)cert);
            } else {
                throw new Exception("Unsupported format: " + string);
            }
        }
        logger.info("Storing certificates into " + path);
        pkcs7 = certChain.toPKCS7();
        for (X509Certificate cert : pkcs7.getCertificates()) {
            logger.info("- " + cert.getSubjectDN());
        }
        try (PrintWriter printWriter = new PrintWriter(path.toFile());){
            printWriter.print(pkcs7.toPEMString());
        }
    }
}

