/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.dbs;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.RevocationInfo;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertRecord
implements IDBObj {
    private static final String CMS_BASE_INVALID_ATTRIBUTE = "CMS_BASE_INVALID_ATTRIBUTE";
    public static final Logger logger = LoggerFactory.getLogger(CertRecord.class);
    private static final long serialVersionUID = -6231895305929417777L;
    public static final String ATTR_ID = "certRecordId";
    public static final String ATTR_META_INFO = "certMetaInfo";
    public static final String ATTR_REVO_INFO = "certRevoInfo";
    public static final String ATTR_CERT_STATUS = "certStatus";
    public static final String ATTR_CREATE_TIME = "certCreateTime";
    public static final String ATTR_MODIFY_TIME = "certModifyTime";
    public static final String ATTR_AUTO_RENEW = "certAutoRenew";
    public static final String ATTR_ISSUED_BY = "certIssuedBy";
    public static final String ATTR_REVOKED_BY = "certRevokedBy";
    public static final String ATTR_REVOKED_ON = "certRevokedOn";
    public static final String ATTR_X509CERT = "x509cert";
    public static final String META_LDAPPUBLISH = "inLdapPublishDir";
    public static final String META_REQUEST_ID = "requestId";
    public static final String META_RENEWED_CERT = "renewedCertSerialNo";
    public static final String META_OLD_CERT = "oldCertSerialNo";
    public static final String META_CERT_TYPE = "certType";
    public static final String META_CRMF_REQID = "crmfReqId";
    public static final String META_CHALLENGE_PHRASE = "challengePhrase";
    public static final String META_PROFILE_ID = "profileId";
    public static final String META_REV_SHRTOK = "revShrTok";
    public static final String STATUS_VALID = "VALID";
    public static final String STATUS_INVALID = "INVALID";
    public static final String STATUS_REVOKED = "REVOKED";
    public static final String STATUS_EXPIRED = "EXPIRED";
    public static final String STATUS_REVOKED_EXPIRED = "REVOKED_EXPIRED";
    public static final String AUTO_RENEWAL_DISABLED = "DISABLED";
    public static final String AUTO_RENEWAL_ENABLED = "ENABLED";
    public static final String AUTO_RENEWAL_DONE = "DONE";
    public static final String AUTO_RENEWAL_NOTIFIED = "NOTIFIED";
    public static final String X509CERT_NOT_BEFORE = "notBefore";
    public static final String X509CERT_NOT_AFTER = "notAfter";
    public static final String X509CERT_DURATION = "duration";
    public static final String X509CERT_EXTENSION = "extension";
    public static final String X509CERT_SUBJECT = "subject";
    public static final String X509CERT_ISSUER = "issuer";
    public static final String X509CERT_PUBLIC_KEY_DATA = "publicKeyData";
    public static final String X509CERT_VERSION = "version";
    public static final String X509CERT_ALGORITHM = "algorithm";
    public static final String X509CERT_SIGNING_ALGORITHM = "signingAlgorithm";
    public static final String X509CERT_SERIAL_NUMBER = "serialNumber";
    public static final String ATTR_X509CERT_NOT_BEFORE = "x509cert.notBefore";
    public static final String ATTR_X509CERT_NOT_AFTER = "x509cert.notAfter";
    public static final String ATTR_X509CERT_DURATION = "x509cert.duration";
    public static final String ATTR_X509CERT_EXTENSION = "x509cert.extension";
    public static final String ATTR_X509CERT_SUBJECT = "x509cert.subject";
    public static final String ATTR_X509CERT_ISSUER = "x509cert.issuer";
    public static final String ATTR_X509CERT_VERSION = "x509cert.version";
    public static final String ATTR_X509CERT_ALGORITHM = "x509cert.algorithm";
    public static final String ATTR_X509CERT_SIGNING_ALGORITHM = "x509cert.signingAlgorithm";
    public static final String ATTR_X509CERT_SERIAL_NUMBER = "x509cert.serialNumber";
    public static final String ATTR_X509CERT_PUBLIC_KEY_DATA = "x509cert.publicKeyData";
    private BigInteger mId = null;
    private X509CertImpl mX509Certificate = null;
    private String mStatus = null;
    private String mAutoRenew = null;
    private MetaInfo mMetaInfo = null;
    private transient RevocationInfo mRevocationInfo = null;
    private Date mCreateTime = null;
    private Date mModifyTime = null;
    private String mIssuedBy = null;
    private String mRevokedBy = null;
    private Date mRevokedOn = null;
    protected static List<String> mNames = Arrays.asList("certRecordId", "certMetaInfo", "certRevoInfo", "x509cert", "certCreateTime", "certModifyTime", "certStatus", "certAutoRenew", "certIssuedBy", "certRevokedBy", "certRevokedOn");

    public CertRecord() {
    }

    public CertRecord(BigInteger id, Certificate cert, MetaInfo meta) {
        this.mId = id;
        if (cert instanceof X509CertImpl) {
            X509CertImpl x509Cert;
            this.mX509Certificate = x509Cert = (X509CertImpl)cert;
        }
        this.mMetaInfo = meta;
        this.mStatus = STATUS_VALID;
        this.mAutoRenew = AUTO_RENEWAL_ENABLED;
        this.mCreateTime = new Date();
        this.mModifyTime = new Date();
    }

    public void set(String name, Object obj) throws EBaseException {
        if (name.equalsIgnoreCase(ATTR_REVO_INFO)) {
            this.mRevocationInfo = (RevocationInfo)obj;
        } else if (name.equalsIgnoreCase(ATTR_ID)) {
            this.mId = (BigInteger)obj;
        } else if (name.equalsIgnoreCase(ATTR_META_INFO)) {
            this.mMetaInfo = (MetaInfo)obj;
        } else if (name.equalsIgnoreCase(ATTR_X509CERT)) {
            this.mX509Certificate = (X509CertImpl)obj;
        } else if (name.equalsIgnoreCase(ATTR_CERT_STATUS)) {
            this.mStatus = (String)obj;
        } else if (name.equalsIgnoreCase(ATTR_AUTO_RENEW)) {
            this.mAutoRenew = (String)obj;
        } else if (name.equalsIgnoreCase(ATTR_CREATE_TIME)) {
            this.mCreateTime = (Date)obj;
        } else if (name.equalsIgnoreCase(ATTR_MODIFY_TIME)) {
            this.mModifyTime = (Date)obj;
        } else if (name.equalsIgnoreCase(ATTR_ISSUED_BY)) {
            this.mIssuedBy = (String)obj;
        } else if (name.equalsIgnoreCase(ATTR_REVOKED_BY)) {
            this.mRevokedBy = (String)obj;
        } else if (name.equalsIgnoreCase(ATTR_REVOKED_ON)) {
            this.mRevokedOn = (Date)obj;
        } else {
            throw new EBaseException(CMS.getUserMessage(CMS_BASE_INVALID_ATTRIBUTE, name));
        }
    }

    public Object get(String name) throws EBaseException {
        if (name.equalsIgnoreCase(ATTR_REVO_INFO)) {
            return this.mRevocationInfo;
        }
        if (name.equalsIgnoreCase(ATTR_ID)) {
            return this.mId;
        }
        if (name.equalsIgnoreCase(ATTR_META_INFO)) {
            return this.mMetaInfo;
        }
        if (name.equalsIgnoreCase(ATTR_X509CERT)) {
            return this.mX509Certificate;
        }
        if (name.equalsIgnoreCase(ATTR_CERT_STATUS)) {
            return this.mStatus;
        }
        if (name.equalsIgnoreCase(ATTR_AUTO_RENEW)) {
            return this.mAutoRenew;
        }
        if (name.equalsIgnoreCase(ATTR_CREATE_TIME)) {
            return this.mCreateTime;
        }
        if (name.equalsIgnoreCase(ATTR_MODIFY_TIME)) {
            return this.mModifyTime;
        }
        if (name.equalsIgnoreCase(ATTR_ISSUED_BY)) {
            return this.mIssuedBy;
        }
        if (name.equalsIgnoreCase(ATTR_REVOKED_BY)) {
            return this.mRevokedBy;
        }
        if (name.equalsIgnoreCase(ATTR_REVOKED_ON)) {
            return this.mRevokedOn;
        }
        throw new EBaseException(CMS.getUserMessage(CMS_BASE_INVALID_ATTRIBUTE, name));
    }

    public void delete(String name) throws EBaseException {
        throw new EBaseException(CMS.getUserMessage(CMS_BASE_INVALID_ATTRIBUTE, name));
    }

    public Enumeration<String> getElements() {
        return Collections.enumeration(mNames);
    }

    @Override
    public Enumeration<String> getSerializableAttrNames() {
        return Collections.enumeration(mNames);
    }

    public X509CertImpl getCertificate() {
        return this.mX509Certificate;
    }

    public MetaInfo getMetaInfo() {
        return this.mMetaInfo;
    }

    public String getStatus() {
        return this.mStatus;
    }

    public String getAutoRenew() {
        return this.mAutoRenew;
    }

    public RevocationInfo getRevocationInfo() {
        return this.mRevocationInfo;
    }

    public BigInteger getSerialNumber() {
        return this.mId;
    }

    public String getIssuedBy() {
        return this.mIssuedBy;
    }

    public String getRevokedBy() {
        return this.mRevokedBy;
    }

    public Date getRevokedOn() {
        return this.mRevokedOn;
    }

    public BigInteger getCertificateSerialNumber() {
        return this.mX509Certificate.getSerialNumber();
    }

    public Date getNotAfter() {
        return this.mX509Certificate.getNotAfter();
    }

    public Date getNotBefore() {
        return this.mX509Certificate.getNotBefore();
    }

    public Date getRevocationDate() {
        return this.mRevocationInfo.getRevocationDate();
    }

    public Date getCreateTime() {
        return this.mCreateTime;
    }

    public Date getModifyTime() {
        return this.mModifyTime;
    }

    public RevocationReason getRevReason() throws EBaseException, X509ExtensionException {
        RevocationInfo revInfo = this.getRevocationInfo();
        if (revInfo == null) {
            String msg = "revInfo null for" + this.getSerialNumber().toString();
            logger.debug("CertRecord.getRevReason: {}", (Object)msg);
            return null;
        }
        CRLExtensions crlExts = revInfo.getCRLEntryExtensions();
        if (crlExts == null) {
            throw new X509ExtensionException("crlExts null");
        }
        CRLReasonExtension reasonExt = null;
        reasonExt = (CRLReasonExtension)crlExts.get("CRLReason");
        if (reasonExt == null) {
            throw new EBaseException("reasonExt null");
        }
        return reasonExt.getReason();
    }

    public boolean isCertOnHold() {
        String method = "CertRecord.isCertOnHold: ";
        logger.debug("{} checking for cert serial: {}", (Object)method, (Object)this.getSerialNumber());
        try {
            RevocationReason revReason = this.getRevReason();
            if (revReason == RevocationReason.CERTIFICATE_HOLD) {
                logger.debug("{} for {} returning true", (Object)method, (Object)this.getSerialNumber());
                return true;
            }
        }
        catch (Exception e) {
            logger.warn("{} {}", new Object[]{method, e.getMessage(), e});
        }
        logger.debug("{} for {} returning false", (Object)method, (Object)this.getSerialNumber());
        return false;
    }

    public String toString() {
        String certRecordString = "CertRecord: ";
        if (this.getSerialNumber() != null) {
            certRecordString = certRecordString.concat("    " + this.getSerialNumber().toString());
        }
        return certRecordString;
    }
}

