/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.certsrv.base.UserNotFoundException;
import com.netscape.certsrv.user.UserData;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmscore.usrgrp.UGSubsystemConfig;
import com.netscape.cmscore.usrgrp.User;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.server.cli.SubsystemCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemUserShowCLI
extends SubsystemCLI {
    public static Logger logger = LoggerFactory.getLogger(SubsystemUserShowCLI.class);

    public SubsystemUserShowCLI(CLI parent) {
        super("show", "Display " + parent.getParent().getName().toUpperCase() + " user", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "output-format", true, "Output format: text (default), json.");
        option.setArgName("format");
        this.options.addOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing user ID");
        }
        String userID = cmdArgs[0];
        String outputFormat = cmd.getOptionValue("output-format", "text");
        this.initializeTomcatJSS();
        String subsystem = this.parent.getParent().getName();
        EngineConfig cs = this.getEngineConfig(subsystem);
        cs.load();
        UGSubsystemConfig ugConfig = cs.getUGSubsystemConfig();
        LDAPConfig ldapConfig = ugConfig.getLDAPConfig();
        ldapConfig.putInteger("minConns", 1);
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        UGSubsystem ugSubsystem = new UGSubsystem();
        UserData userData = new UserData();
        try {
            String state;
            String type;
            String phone;
            String email;
            ugSubsystem.init(ldapConfig, socketConfig, passwordStore);
            User user = ugSubsystem.getUser(userID);
            if (user == null) {
                throw new UserNotFoundException(userID);
            }
            userData.setID(userID);
            userData.setUserID(userID);
            String fullName = user.getFullName();
            if (!StringUtils.isEmpty((CharSequence)fullName)) {
                userData.setFullName(fullName);
            }
            if (!StringUtils.isEmpty((CharSequence)(email = user.getEmail()))) {
                userData.setEmail(email);
            }
            if (!StringUtils.isEmpty((CharSequence)(phone = user.getPhone()))) {
                userData.setPhone(phone);
            }
            if (!StringUtils.isEmpty((CharSequence)(type = user.getUserType()))) {
                userData.setType(type);
            }
            if (!StringUtils.isEmpty((CharSequence)(state = user.getState()))) {
                userData.setState(state);
            }
        }
        finally {
            ugSubsystem.shutdown();
        }
        if (outputFormat.equalsIgnoreCase("json")) {
            System.out.println(userData.toJSON());
        } else if (outputFormat.equalsIgnoreCase("text")) {
            String state;
            String type;
            String phone;
            String email;
            System.out.println("  User ID: " + userData.getUserID());
            String fullName = userData.getFullName();
            if (!StringUtils.isEmpty((CharSequence)fullName)) {
                System.out.println("  Full name: " + fullName);
            }
            if (!StringUtils.isEmpty((CharSequence)(email = userData.getEmail()))) {
                System.out.println("  Email: " + email);
            }
            if (!StringUtils.isEmpty((CharSequence)(phone = userData.getPhone()))) {
                System.out.println("  Phone: " + phone);
            }
            if (!StringUtils.isEmpty((CharSequence)(type = userData.getType()))) {
                System.out.println("  Type: " + type);
            }
            if (!StringUtils.isEmpty((CharSequence)(state = userData.getState()))) {
                System.out.println("  State: " + state);
            }
        } else {
            throw new Exception("Unsupported output format: " + outputFormat);
        }
    }
}

