/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netscape.certsrv.util.JSONSerializer;
import java.util.Map;
import java.util.Properties;
import org.dogtagpki.acme.server.ACMERetentionConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ACMEPolicyConfig
implements JSONSerializer {
    @JsonProperty(value="wildcard")
    private Boolean enableWildcardIssuance = true;
    @JsonProperty(value="retention")
    private ACMERetentionConfig retention = new ACMERetentionConfig();

    @JsonIgnore
    public boolean getEnableWildcards() {
        return this.enableWildcardIssuance;
    }

    public void setEnableWildcards(boolean on) {
        this.enableWildcardIssuance = on;
    }

    public ACMERetentionConfig getRetention() {
        return this.retention;
    }

    public void setRetention(ACMERetentionConfig retentionPolicy) {
        this.retention = retentionPolicy;
    }

    public void setProperty(String key, String value) throws Exception {
        if (key.equals("wildcard")) {
            this.enableWildcardIssuance = Boolean.valueOf(value);
            return;
        }
        if (key.startsWith("retention.")) {
            String retentionKey = key.substring(10);
            this.retention.setProperty(retentionKey, value);
        }
    }

    public static ACMEPolicyConfig fromProperties(Properties props) throws Exception {
        ACMEPolicyConfig config = new ACMEPolicyConfig();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            config.setProperty(key, value);
        }
        return config;
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        ACMEPolicyConfig config = new ACMEPolicyConfig();
        System.out.println(config);
    }
}

