/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ocsp;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.OCSPSigningInfoEvent;
import com.netscape.certsrv.ocsp.IDefStore;
import com.netscape.certsrv.ocsp.IOCSPService;
import com.netscape.certsrv.ocsp.IOCSPStore;
import com.netscape.certsrv.security.SigningUnit;
import com.netscape.certsrv.security.SigningUnitConfig;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.util.StatsSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.cmsutil.ocsp.BasicOCSPResponse;
import com.netscape.cmsutil.ocsp.KeyHashID;
import com.netscape.cmsutil.ocsp.NameID;
import com.netscape.cmsutil.ocsp.OCSPRequest;
import com.netscape.cmsutil.ocsp.OCSPResponse;
import com.netscape.cmsutil.ocsp.OCSPResponseStatus;
import com.netscape.cmsutil.ocsp.Request;
import com.netscape.cmsutil.ocsp.ResponderID;
import com.netscape.cmsutil.ocsp.ResponseBytes;
import com.netscape.cmsutil.ocsp.ResponseData;
import com.netscape.cmsutil.ocsp.SingleResponse;
import com.netscape.cmsutil.ocsp.TBSRequest;
import com.netscape.ocsp.EOCSPException;
import com.netscape.ocsp.OCSPSigningUnit;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.dogtagpki.server.ocsp.OCSPConfig;
import org.dogtagpki.server.ocsp.OCSPEngine;
import org.dogtagpki.server.ocsp.OCSPEngineConfig;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPAuthority
extends Subsystem
implements IAuthority,
IOCSPService {
    public static Logger logger = LoggerFactory.getLogger(OCSPAuthority.class);
    public static final String ID = "ocsp";
    private long mServedTime = 0L;
    public static final OBJECT_IDENTIFIER OCSP_NONCE = new OBJECT_IDENTIFIER("1.3.6.1.5.5.7.48.1.2");
    public static final String PROP_DEF_STORE_ID = "storeId";
    public static final String PROP_STORE = "store";
    public static final String PROP_NICKNAME = "certNickname";
    public static final String PROP_NEW_NICKNAME = "newNickname";
    private Hashtable<String, IOCSPStore> mStores = new Hashtable();
    private String mId = "ocsp";
    private OCSPConfig mConfig;
    private OCSPSigningUnit mSigningUnit;
    private String[] mOCSPSigningAlgorithms = null;
    private IOCSPStore mDefStore = null;
    public long mNumOCSPRequest = 0L;
    public long mTotalTime = 0L;
    public long mTotalData = 0L;
    public long mSignTime = 0L;
    public long mLookupTime = 0L;

    public String getId() {
        return this.mId;
    }

    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    public void init(ConfigStore config) throws Exception {
        OCSPEngine ocspEngine = (OCSPEngine)this.engine;
        OCSPEngineConfig engineConfig = ocspEngine.getConfig();
        DBSubsystem dbSubsystem = this.engine.getDBSubsystem();
        Auditor auditor = this.engine.getAuditor();
        try {
            this.mConfig = engineConfig.getOCSPConfig();
            this.initSigUnit();
            try {
                String defStoreId = this.mConfig.getString(PROP_DEF_STORE_ID, null);
                if (defStoreId == null) {
                    throw new EBaseException("default id not found");
                }
                ConfigStore storeConfig = this.mConfig.getSubStore(PROP_STORE, ConfigStore.class);
                Enumeration ids = storeConfig.getSubStoreNames().elements();
                while (ids.hasMoreElements()) {
                    String id = (String)ids.nextElement();
                    String className = this.mConfig.getString("store." + id + ".class", null);
                    IOCSPStore store = (IOCSPStore)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    ConfigStore cfg = this.mConfig.getSubStore("store." + id, ConfigStore.class);
                    store.init(cfg, dbSubsystem);
                    this.mStores.put(id, store);
                    if (!id.equals(defStoreId)) continue;
                    this.mDefStore = store;
                }
            }
            catch (Exception e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_OCSP_SIGNING_UNIT", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
        }
        catch (EBaseException e) {
            logger.error("OCSPAuthority: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            String ocspSigningSKI = CryptoUtil.getSKIString((X509CertImpl)this.mSigningUnit.getCertImpl());
            auditor.log((LogEvent)OCSPSigningInfoEvent.createSuccessEvent((String)"$System$", (String)ocspSigningSKI));
        }
        catch (IOException e) {
            throw new EBaseException((Exception)e);
        }
    }

    public IOCSPStore getOCSPStore(String id) {
        return this.mStores.get(id);
    }

    public ConfigStore getOCSPStoreConfig(String id) {
        return this.mConfig.getSubStore("store." + id, ConfigStore.class);
    }

    public String getOCSPStoreClassPath(String id) {
        try {
            return this.mConfig.getString("store." + id + ".class", null);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CMSCORE_OCSP_CLASSPATH", (Object[])new Object[]{id, e.toString()}), (Throwable)e);
            return null;
        }
    }

    public ResponderID getResponderIDByName() {
        try {
            X500Name name = this.getName();
            Name.Template nameTemplate = new Name.Template();
            return new NameID((Name)nameTemplate.decode((InputStream)new ByteArrayInputStream(name.getEncoded())));
        }
        catch (IOException e) {
            return null;
        }
        catch (InvalidBERException e) {
            return null;
        }
    }

    public ResponderID getResponderIDByHash() {
        PublicKey publicKey = this.getSigningUnit().getPublicKey();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        md.update(publicKey.getEncoded());
        byte[] digested = md.digest();
        return new KeyHashID(new OCTET_STRING(digested));
    }

    public String[] getOCSPSigningAlgorithms() {
        if (this.mOCSPSigningAlgorithms != null) {
            return this.mOCSPSigningAlgorithms;
        }
        X509CertImpl certImpl = this.mSigningUnit.getCertImpl();
        if (certImpl == null) {
            return null;
        }
        X509Key caPubKey = null;
        try {
            caPubKey = (X509Key)certImpl.get("x509.info.key.value");
        }
        catch (CertificateParsingException e) {
            logger.warn(CMS.getLogMessage((String)"CMSCORE_OCSP_RETRIEVE_KEY", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (caPubKey == null) {
            return null;
        }
        AlgorithmId alg = caPubKey.getAlgorithmId();
        if (alg == null) {
            return null;
        }
        this.mOCSPSigningAlgorithms = AlgorithmId.getSigningAlgorithms((AlgorithmId)alg);
        if (this.mOCSPSigningAlgorithms == null) {
            logger.debug("OCSP - no signing algorithms for " + alg.getName());
        } else {
            logger.debug("OCSP First signing algorithm ");
        }
        return this.mOCSPSigningAlgorithms;
    }

    public X500Name getName() {
        X509CertImpl certImpl = this.mSigningUnit.getCertImpl();
        return certImpl.getSubjectName();
    }

    public IDefStore getDefaultStore() {
        return (IDefStore)this.mDefStore;
    }

    private void initSigUnit() throws EBaseException {
        logger.info("OCSPAuthority: Initializing OCSP signing unit");
        SigningUnitConfig ocspSigningConfig = this.mConfig.getSigningUnitConfig();
        this.mSigningUnit = new OCSPSigningUnit();
        this.mSigningUnit.init(ocspSigningConfig);
        this.getOCSPSigningAlgorithms();
    }

    public void startup() throws EBaseException {
        OCSPEngine engine = OCSPEngine.getInstance();
        try {
            if (this.mDefStore != null) {
                this.mDefStore.startup();
            }
        }
        catch (EBaseException e) {
            logger.warn("OCSPAuthority: " + e.getMessage(), (Throwable)e);
            if (engine.isPreOpMode()) {
                logger.warn("OCSPAuthority.init(): Swallow exception in pre-op mode");
                return;
            }
            throw e;
        }
        catch (Exception e) {
            logger.warn("OCSPAuthority: " + e.getMessage(), (Throwable)e);
        }
    }

    public OCSPResponse validate(OCSPRequest request) throws EBaseException {
        OCSPResponse response;
        logger.info("OCSPAuthority: Validating OCSP request");
        TBSRequest tbsReq = request.getTBSRequest();
        if (tbsReq.getRequestCount() == 0) {
            logger.error("OCSPAuthority: No request found");
            logger.error(CMS.getLogMessage((String)"OCSP_REQUEST_FAILURE", (Object[])new Object[]{"No Request Found"}));
            throw new EBaseException("OCSP request is empty");
        }
        OCSPEngine engine = OCSPEngine.getInstance();
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        this.incNumOCSPRequest(1L);
        long startTime = new Date().getTime();
        try {
            Vector<SingleResponse> singleResponses = new Vector<SingleResponse>();
            if (statsSub != null) {
                statsSub.startTiming("lookup");
            }
            long lookupStartTime = new Date().getTime();
            for (int i = 0; i < tbsReq.getRequestCount(); ++i) {
                logger.info("OCSPAuthority: Processing request #" + i);
                Request req = tbsReq.getRequestAt(i);
                SingleResponse sr = this.mDefStore.processRequest(req);
                singleResponses.addElement(sr);
            }
            long lookupEndTime = new Date().getTime();
            this.incLookupTime(lookupEndTime - lookupStartTime);
            if (statsSub != null) {
                statsSub.endTiming("lookup");
            }
            if (statsSub != null) {
                statsSub.startTiming("build_response");
            }
            Object[] res = new SingleResponse[singleResponses.size()];
            singleResponses.copyInto(res);
            ResponderID rid = null;
            rid = this.mDefStore.isByName() ? this.getResponderIDByName() : this.getResponderIDByHash();
            Extension[] nonce = null;
            for (int j = 0; j < tbsReq.getExtensionsCount(); ++j) {
                Extension thisExt = tbsReq.getRequestExtensionAt(j);
                if (!thisExt.getExtnId().equals((Object)OCSP_NONCE)) continue;
                nonce = new Extension[]{thisExt};
            }
            ResponseData rd = new ResponseData(rid, new GeneralizedTime(new Date()), (SingleResponse[])res, nonce);
            if (statsSub != null) {
                statsSub.endTiming("build_response");
            }
            if (statsSub != null) {
                statsSub.startTiming("signing");
            }
            long signStartTime = new Date().getTime();
            BasicOCSPResponse basicRes = this.sign(rd);
            long signEndTime = new Date().getTime();
            this.incSignTime(signEndTime - signStartTime);
            if (statsSub != null) {
                statsSub.endTiming("signing");
            }
            response = new OCSPResponse(OCSPResponseStatus.SUCCESSFUL, new ResponseBytes(ResponseBytes.OCSP_BASIC, new OCTET_STRING(ASN1Util.encode((ASN1Value)basicRes))));
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"OCSP_REQUEST_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(CMS.getLogMessage((String)"OCSP_REQUEST_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new EBaseException(e);
        }
        logger.info("OCSPAuthority: Done validating OCSP request");
        long endTime = new Date().getTime();
        this.incTotalTime(endTime - startTime);
        this.mServedTime += endTime - startTime;
        return response;
    }

    public void shutdown() {
    }

    public OCSPConfig getConfigStore() {
        return this.mConfig;
    }

    public String getDefaultAlgorithm() {
        return this.mSigningUnit.getDefaultAlgorithm();
    }

    public void log(int level, String msg) {
    }

    public void setDefaultAlgorithm(String algorithm) throws EBaseException {
        this.mSigningUnit.setDefaultAlgorithm(algorithm);
    }

    public BasicOCSPResponse sign(ResponseData rd) throws EBaseException {
        BasicOCSPResponse basicOCSPResponse;
        OCSPEngine engine = OCSPEngine.getInstance();
        DerOutputStream out = new DerOutputStream();
        try {
            BasicOCSPResponse response;
            DerOutputStream tmp = new DerOutputStream();
            String algname = this.mSigningUnit.getDefaultAlgorithm();
            byte[] rd_data = ASN1Util.encode((ASN1Value)rd);
            if (rd_data != null) {
                this.mTotalData += (long)rd_data.length;
            }
            rd.encode((OutputStream)tmp);
            AlgorithmId.get((String)algname).encode(tmp);
            logger.debug("OCSPAuthority: adding signature");
            byte[] signature = this.mSigningUnit.sign(rd_data, algname);
            tmp.putBitString(signature);
            DerOutputStream tmpChain = new DerOutputStream();
            DerOutputStream tmp1 = new DerOutputStream();
            X509Certificate[] chains = this.mSigningUnit.getCertChain().getChain();
            for (int i = 0; i < chains.length; ++i) {
                tmpChain.putDerValue(new DerValue(chains[i].getEncoded()));
            }
            tmp1.write((byte)48, tmpChain);
            tmp.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), tmp1);
            out.write((byte)48, tmp);
            basicOCSPResponse = response = new BasicOCSPResponse(out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoSuchAlgorithmException e) {
                logger.error(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new EOCSPException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), e);
            }
            catch (TokenException e) {
                logger.error(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new EOCSPException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), (Exception)((Object)e));
            }
            catch (InvalidKeyException e) {
                logger.error(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new EOCSPException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), e);
            }
            catch (SignatureException e) {
                logger.error(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
                engine.checkForAndAutoShutdown();
                throw new EOCSPException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}), e);
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_OCSP_SIGN_RESPONSE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw new EBaseException(e);
            }
        }
        out.close();
        return basicOCSPResponse;
    }

    public SigningUnit getSigningUnit() {
        return this.mSigningUnit;
    }

    public String getNickname() {
        return this.mSigningUnit.getNickname();
    }

    public String getNewNickName() throws EBaseException {
        return this.mConfig.getString(PROP_NEW_NICKNAME, "");
    }

    public void setNewNickName(String name) {
        this.mConfig.putString(PROP_NEW_NICKNAME, name);
    }

    public void setNickname(String str) {
        this.mConfig.putString(PROP_NICKNAME, str);
    }

    public String getOfficialName() {
        return ID;
    }

    public long getNumOCSPRequest() {
        return this.mNumOCSPRequest;
    }

    public long getOCSPRequestTotalTime() {
        return this.mTotalTime;
    }

    public long getOCSPTotalSignTime() {
        return this.mSignTime;
    }

    public long getOCSPTotalLookupTime() {
        return this.mLookupTime;
    }

    public long getOCSPTotalData() {
        return this.mTotalData;
    }

    public void incTotalTime(long inc) {
        this.mTotalTime += inc;
    }

    public void incSignTime(long inc) {
        this.mSignTime += inc;
    }

    public void incLookupTime(long inc) {
        this.mLookupTime += inc;
    }

    public void incNumOCSPRequest(long inc) {
        this.mNumOCSPRequest += inc;
    }
}

