---
layout: default
title: ICU
nav_order: 2
has_children: true
---
<!--
© 2020 and later: Unicode, Inc. and others.
License & terms of use: http://www.unicode.org/copyright.html
-->

# Introduction to ICU

As companies integrate e-commerce on a global scale into their fundamental
business processes, their prospective customers, established customers, and
active partners can take advantage of increased revenue and decreased expenses
through software internationalization. They also can improve customer
communications and increase savings.

## Meeting the Challenge of Globalization

In today's business climate of globalization, companies must compete in a new
Internet-enabled business climate of constant change and compressed time frames.
Their customers expect reliable service and support.

## Taking Advantage of Internationalized Software

Companies need to establish a better linkage between their global business
processes and the underlying supportive IT processes. If they want to deliver
this new flexibility and agility, they must depend on the software
internationalization process.

The software internationalization development process uses libraries (such as
the International Components for Unicode (ICU) libraries), to enable one single
program to work with text in any language for any place in the world. For
example, instead of having separate software versions for ten different
countries, the ICU services can create one version that works seamlessly and
transparently in all of them.

The ICU components are an integral part of software development because they
hide the cultural nuances and technical complexities of locale-specific software
requirements. These complexities provide critical functionality for
applications, but the application developer does not need to exert a huge effort
or incur high costs to build them.

## Justifying the Investment

The business case needed to justify the investment in software
internationalization is compelling when the investment is amortized over a
number of projects. In the fast-paced and rapidly-evolving world of traditional
and evolving e-businesses, these international components provide a firm ground
on which companies, partners and suppliers can build their business
transactions. They can share competitive information to help gain a significant
economic advantage.

The ICU services deliver proven value by lowering the cost required to integrate
with disparate applications, systems and data sources on a regional and global
scale. It provides value to a company's IT investment by lowering IT complexity,
risk, maintenance costs and training costs. It also enhances organizational
flexibility, leverages
existing assets, and improves planning and decision-making. It enables
organizational learning, process-driven synchronization, event-driven evaluation
and decision-making.

## Background and History of ICU

ICU was originally developed by the Taligent company. The Taligent team later
became the Unicode group at the IBM® Globalization Center of Competency in
Cupertino. The team has received significant input from the open source
community worldwide.

Java™ classes developed at Taligent were incorporated into the Java Development
Kit (JDK) 1.1 developed by Sun® Microsystems. The classes were then ported to
C++ and later some classes were also ported to C. The classes provide
internationalization utilities for writing global applications in C, C++, or
Java programming languages.

ICU for Java (ICU4J) includes enhanced versions of some of these classes, plus
additional classes that complement the classes in the JDK. C and C++ versions of
the same international functionality are available in ICU for C (ICU4C). The
APIs differ slightly due to language differences and new functionality. For
example, ICU4C includes a character converter API.

ICU4J and ICU4C keep the same development goals. They both track additions to
the Java internationalization APIs and implement the latest released Unicode
standard. They also maintain a single, portable source code base.

All of us in the ICU and open source group appreciate the time you are taking to
understand our technology. We have put our best collective effort into these
open components, and look forward to your questions, comments and suggestions.

## Downloading ICU

Download ICU in one of the following ways:

1.  From the download page, <http://www.icu-project.org/download/>, for
    packaged stable releases of ICU.

2.  From the source code repository, <https://github.com/unicode-org/icu/releases/>,
    for the latest development versions.

After downloading, see the included README file for information on what is
included, building, installing, etc.

## ICU License

Current license: <https://github.com/unicode-org/icu/blob/master/icu4c/LICENSE>

See also FAQ section ["How is the ICU licensed"](icufaq/index#how-is-icu-licensed)
