/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.Options;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.dcmd.AbstractDCmd;
import jdk.jfr.internal.dcmd.DCmdException;

final class DCmdConfigure
extends AbstractDCmd {
    DCmdConfigure() {
    }

    public String execute(Boolean bl, String string, String string2, Integer n, Long l, Long l2, Long l3, Long l4, Long l5, Boolean bl2, Boolean bl3, Long l6) throws DCmdException {
        if (Logger.shouldLog(LogTag.JFR_DCMD, LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdConfigure: repositorypath=" + string + ", dumppath=" + string2 + ", stackdepth=" + n + ", globalbuffercount=" + l + ", globalbuffersize=" + l2 + ", thread_buffer_size" + l3 + ", memorysize" + l4 + ", maxchunksize=" + l5 + ", samplethreads" + bl2);
        }
        if (!(bl.booleanValue() || bl3 == null && l6 == null)) {
            Logger.log(LogTag.JFR, LogLevel.ERROR, "Could not change sampleObjectAllocations and objectAllocationsSamplingInterval during application's running");
            return this.getResult();
        }
        boolean bl4 = false;
        if (string != null) {
            try {
                SecuritySupport.SafePath safePath = new SecuritySupport.SafePath(string);
                Repository.getRepository().setBasePath(safePath);
                Logger.log(LogTag.JFR, LogLevel.INFO, "Base repository path set to " + string);
            }
            catch (Exception exception) {
                throw new DCmdException("Could not use " + string + " as repository. " + exception.getMessage(), new Object[]{exception});
            }
            this.printRepositoryPath();
            bl4 = true;
        }
        if (string2 != null) {
            Options.setDumpPath(new SecuritySupport.SafePath(string2));
            Logger.log(LogTag.JFR, LogLevel.INFO, "Emergency dump path set to " + string2);
            this.printDumpPath();
            bl4 = true;
        }
        if (n != null) {
            Options.setStackDepth(n);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Stack depth set to " + n);
            this.printStackDepth();
            bl4 = true;
        }
        if (l != null) {
            Options.setGlobalBufferCount(l);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Global buffer count set to " + l);
            this.printGlobalBufferCount();
            bl4 = true;
        }
        if (l2 != null) {
            Options.setGlobalBufferSize(l2);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Global buffer size set to " + l2);
            this.printGlobalBufferSize();
            bl4 = true;
        }
        if (l3 != null) {
            Options.setThreadBufferSize(l3);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Thread buffer size set to " + l3);
            this.printThreadBufferSize();
            bl4 = true;
        }
        if (l4 != null) {
            Options.setMemorySize(l4);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Memory size set to " + l4);
            this.printMemorySize();
            bl4 = true;
        }
        if (l5 != null) {
            Options.setMaxChunkSize(l5);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Max chunk size set to " + l5);
            this.printMaxChunkSize();
            bl4 = true;
        }
        if (bl2 != null) {
            Options.setSampleThreads(bl2);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Sample threads set to " + bl2);
            this.printSampleThreads();
            bl4 = true;
        }
        if (l6 != null) {
            Options.setObjectAllocationsSamplingInterval(l6);
            Logger.log(LogTag.JFR, LogLevel.INFO, "object allocations sampling interval set to " + l6);
            this.printObjectAllocationsSamplingInterval();
            bl4 = true;
        }
        if (bl3 != null) {
            Options.setSampleObjectAllocations(bl3);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Sample object allocations set to " + bl3);
            this.printSampleObjectAllocations();
            bl4 = true;
        }
        if (!bl4) {
            this.println("Current configuration:", new Object[0]);
            this.println();
            this.printRepositoryPath();
            this.printStackDepth();
            this.printGlobalBufferCount();
            this.printGlobalBufferSize();
            this.printThreadBufferSize();
            this.printMemorySize();
            this.printMaxChunkSize();
            this.printSampleThreads();
            this.printSampleObjectAllocations();
            this.printObjectAllocationsSamplingInterval();
        }
        return this.getResult();
    }

    private void printRepositoryPath() {
        this.print("Repository path: ");
        this.printPath(Repository.getRepository().getRepositoryPath());
        this.println();
    }

    private void printDumpPath() {
        this.print("Dump path: ");
        this.printPath(Options.getDumpPath());
        this.println();
    }

    private void printSampleThreads() {
        this.println("Sample threads: " + Options.getSampleThreads(), new Object[0]);
    }

    private void printStackDepth() {
        this.println("Stack depth: " + Options.getStackDepth(), new Object[0]);
    }

    private void printGlobalBufferCount() {
        this.println("Global buffer count: " + Options.getGlobalBufferCount(), new Object[0]);
    }

    private void printGlobalBufferSize() {
        this.print("Global buffer size: ");
        this.printBytes(Options.getGlobalBufferSize());
        this.println();
    }

    private void printThreadBufferSize() {
        this.print("Thread buffer size: ");
        this.printBytes(Options.getThreadBufferSize());
        this.println();
    }

    private void printMemorySize() {
        this.print("Memory size: ");
        this.printBytes(Options.getMemorySize());
        this.println();
    }

    private void printMaxChunkSize() {
        this.print("Max chunk size: ");
        this.printBytes(Options.getMaxChunkSize());
        this.println();
    }

    private void printSampleObjectAllocations() {
        this.println("Sample object allocations: " + Options.getSampleObjectAllocations(), new Object[0]);
    }

    private void printObjectAllocationsSamplingInterval() {
        this.println("objects allocations sampling interval: " + Options.getObjectAllocationsSamplingInterval(), new Object[0]);
    }
}

