/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.wisp.engine;

import com.alibaba.wisp.engine.WispCarrier;
import java.beans.ConstructorProperties;

public final class WispCounter {
    private long switchCount = 0L;
    private long waitTimeTotal = 0L;
    private long runningTimeTotal = 0L;
    private long completedTaskCount = 0L;
    private long createTaskCount = 0L;
    private long parkCount = 0L;
    private long unparkCount = 0L;
    private long unparkInterruptSelectorCount = 0L;
    private long selectableIOCount = 0L;
    private long timeOutCount = 0L;
    private long eventLoopCount = 0L;
    private long totalEnqueueTime = 0L;
    private long maxEnqueueTime = 0L;
    private long enqueueCount = 0L;
    private long totalExecutionTime = 0L;
    private long maxExecutionTime = 0L;
    private long executionCount = 0L;
    private long totalWaitSocketIOTime = 0L;
    private long maxWaitSocketIOTime = 0L;
    private long waitSocketIOCount = 0L;
    private long totalBlockingTime = 0L;
    private long maxBlockingTime = 0L;
    private long unparkFromJvmCount = 0L;
    private long runningTaskCount = 0L;
    private long taskQueueLength = 0L;
    WispCarrier carrier;

    private WispCounter(WispCarrier wispCarrier) {
        this.carrier = wispCarrier;
    }

    boolean getRunningState() {
        WispCarrier wispCarrier = this.carrier;
        return wispCarrier != null && wispCarrier.isRunning();
    }

    void incrementSwitchCount() {
        ++this.switchCount;
    }

    long getSwitchCount() {
        return this.switchCount;
    }

    void incrementCompleteTaskCount() {
        ++this.completedTaskCount;
    }

    void incrementRunningTimeTotal(long l) {
        this.runningTimeTotal += l;
    }

    long getRunningTimeTotal() {
        return this.runningTimeTotal;
    }

    void incrementWaitTime(long l) {
        this.waitTimeTotal += l;
    }

    long getWaitTimeTotal() {
        return this.waitTimeTotal;
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    void incrementCreateTaskCount() {
        ++this.createTaskCount;
    }

    long getCreateTaskCount() {
        return this.createTaskCount;
    }

    void incrementParkCount() {
        ++this.parkCount;
    }

    long getParkCount() {
        return this.parkCount;
    }

    void incrementUnparkInterruptSelectorCount() {
        ++this.unparkInterruptSelectorCount;
    }

    long getUnparkInterruptSelectorCount() {
        return this.unparkInterruptSelectorCount;
    }

    void incrementSelectableIOCount() {
        ++this.selectableIOCount;
    }

    long getSelectableIOCount() {
        return this.selectableIOCount;
    }

    void incrementTimeOutCount() {
        ++this.timeOutCount;
    }

    long getTimeOutCount() {
        return this.timeOutCount;
    }

    void incrementEventLoopCount() {
        ++this.eventLoopCount;
    }

    long getEventLoopCount() {
        return this.eventLoopCount;
    }

    void incrementTotalEnqueueTime(long l) {
        this.totalEnqueueTime += l;
        ++this.enqueueCount;
        if (l > this.maxEnqueueTime) {
            this.maxEnqueueTime = l;
        }
    }

    public long getTotalEnqueueTime() {
        return this.totalEnqueueTime;
    }

    public long getEnqueueCount() {
        return this.enqueueCount;
    }

    void incrementTotalExecutionTime(long l) {
        this.totalExecutionTime += l;
        ++this.executionCount;
        if (l > this.maxExecutionTime) {
            this.maxExecutionTime = l;
        }
    }

    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    void incrementTotalWaitSocketIOTime(long l) {
        this.totalWaitSocketIOTime += l;
        ++this.waitSocketIOCount;
        if (l > this.maxWaitSocketIOTime) {
            this.maxWaitSocketIOTime = l;
        }
    }

    public long getTotalWaitSocketIOTime() {
        return this.totalWaitSocketIOTime;
    }

    public long getWaitSocketIOCount() {
        return this.waitSocketIOCount;
    }

    void incrementTotalBlockingTime(long l) {
        this.totalBlockingTime += l;
        ++this.unparkCount;
        if (l > this.maxBlockingTime) {
            this.maxBlockingTime = l;
        }
    }

    public long getTotalBlockingTime() {
        return this.totalBlockingTime;
    }

    public long getUnparkCount() {
        return this.unparkCount;
    }

    long getCurrentTaskQueueLength() {
        WispCarrier wispCarrier = this.carrier;
        return wispCarrier != null ? (long)wispCarrier.getTaskQueueLength() : 0L;
    }

    long getCurrentRunningTaskCount() {
        WispCarrier wispCarrier = this.carrier;
        return wispCarrier != null ? (long)wispCarrier.getRunningTaskCount() : 0L;
    }

    void incrementUnparkFromJvmCount() {
        ++this.unparkFromJvmCount;
    }

    long getUnparkFromJvmCount() {
        return this.unparkFromJvmCount;
    }

    public long getMaxEnqueueTime() {
        return this.maxEnqueueTime;
    }

    public long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public long getMaxWaitSocketIOTime() {
        return this.maxWaitSocketIOTime;
    }

    public long getMaxBlockingTime() {
        return this.maxBlockingTime;
    }

    public long getTaskQueueLength() {
        return this.taskQueueLength;
    }

    public long getRunningTaskCount() {
        return this.runningTaskCount;
    }

    WispCounter() {
    }

    @ConstructorProperties(value={"completedTaskCount", "totalEnqueueTime", "maxEnqueueTime", "enqueueCount", "totalExecutionTime", "maxExecutionTime", "executionCount", "totalWaitSocketIOTime", "maxWaitSocketIOTime", "waitSocketIOCount", "totalBlockingTime", "maxBlockingTime", "unparkCount", "runningTaskCount", "taskQueueLength"})
    public WispCounter(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15) {
        this.completedTaskCount = l;
        this.totalEnqueueTime = l2;
        this.maxEnqueueTime = l3;
        this.enqueueCount = l4;
        this.totalExecutionTime = l5;
        this.maxExecutionTime = l6;
        this.executionCount = l7;
        this.totalWaitSocketIOTime = l8;
        this.maxWaitSocketIOTime = l9;
        this.waitSocketIOCount = l10;
        this.totalBlockingTime = l11;
        this.maxBlockingTime = l12;
        this.unparkCount = l13;
        this.runningTaskCount = l14;
        this.taskQueueLength = l15;
    }

    void assign(WispCounter wispCounter) {
        this.createTaskCount = wispCounter.createTaskCount;
        this.completedTaskCount = wispCounter.completedTaskCount;
        this.totalEnqueueTime = wispCounter.totalEnqueueTime;
        this.enqueueCount = wispCounter.enqueueCount;
        this.maxEnqueueTime = wispCounter.maxEnqueueTime;
        this.totalExecutionTime = wispCounter.totalExecutionTime;
        this.executionCount = wispCounter.executionCount;
        this.maxExecutionTime = wispCounter.maxExecutionTime;
        this.totalBlockingTime = wispCounter.totalBlockingTime;
        this.unparkCount = wispCounter.unparkCount;
        this.maxBlockingTime = wispCounter.maxBlockingTime;
        this.totalWaitSocketIOTime = wispCounter.totalWaitSocketIOTime;
        this.waitSocketIOCount = wispCounter.waitSocketIOCount;
        this.maxWaitSocketIOTime = wispCounter.maxWaitSocketIOTime;
        this.switchCount = wispCounter.switchCount;
        this.unparkFromJvmCount = wispCounter.unparkFromJvmCount;
        this.runningTaskCount = wispCounter.getCurrentRunningTaskCount();
        this.taskQueueLength = wispCounter.getCurrentTaskQueueLength();
    }

    void resetMaxValue() {
        this.maxEnqueueTime = 0L;
        this.maxExecutionTime = 0L;
        this.maxWaitSocketIOTime = 0L;
        this.maxBlockingTime = 0L;
    }

    void cleanup() {
        this.carrier = null;
    }

    static WispCounter create(WispCarrier wispCarrier) {
        return new WispCounter(wispCarrier);
    }
}

