//===-- StdSpecialSymbolMap.inc ---------------------------------*- C++ -*-===//
//
// This is a hand-curated list for C++ symbols that cannot be parsed/extracted
// via the include-mapping tool (gen_std.py).
//
//===----------------------------------------------------------------------===//

// Symbols that can be provided by any of the headers, ordered by the header
// preference.
// cppreference mentions the <locale> header is an alternative for these symbols,
// but they are not per the standard.
SYMBOL(consume_header, std::, <codecvt>)
SYMBOL(generate_header, std::, <codecvt>)
SYMBOL(little_endian, std::, <codecvt>)

SYMBOL(mbstate_t, std::, <cwchar>)
SYMBOL(mbstate_t, std::, <cuchar>)
SYMBOL(size_t, std::, <cstddef>)
SYMBOL(size_t, std::, <cstdlib>)
SYMBOL(size_t, std::, <cstring>)
SYMBOL(size_t, std::, <cwchar>)
SYMBOL(size_t, std::, <cuchar>)
SYMBOL(size_t, std::, <ctime>)
SYMBOL(size_t, std::, <cstdio>)
SYMBOL(size_t, None, <cstddef>)
SYMBOL(size_t, None, <cstdlib>)
SYMBOL(size_t, None, <cstring>)
SYMBOL(size_t, None, <cwchar>)
SYMBOL(size_t, None, <cuchar>)
SYMBOL(size_t, None, <ctime>)
SYMBOL(size_t, None, <cstdio>)
SYMBOL(size_t, None, <stddef.h>)
SYMBOL(size_t, None, <stdlib.h>)
SYMBOL(size_t, None, <string.h>)
SYMBOL(size_t, None, <wchar.h>)
SYMBOL(size_t, None, <uchar.h>)
SYMBOL(size_t, None, <time.h>)
SYMBOL(size_t, None, <stdio.h>)
SYMBOL(unwrap_ref_decay, std::, <type_traits>)
SYMBOL(unwrap_ref_decay, std::, <functional>)
SYMBOL(unwrap_reference, std::, <type_traits>)
SYMBOL(unwrap_reference, std::, <functional>)
SYMBOL(unwrap_ref_decay_t, std::, <type_traits>)
SYMBOL(unwrap_ref_decay_t, std::, <functional>)
SYMBOL(wint_t, std::, <cwctype>)
SYMBOL(wint_t, std::, <cwchar>)
SYMBOL(swap, std::, <utility>)
SYMBOL(swap, std::, <algorithm>) // until C++11
// C++ [string.view.synop 23.3.2]: The function templates defined in
// [utility.swap] ... are available when <string_­view> is included.
SYMBOL(swap, std::, <string_view>) // since C++17
// C++ [tuple.helper 22.4.7]: In addition to being available via inclusion of
// the <tuple> header, ... any of the headers <array>, <ranges>, or <utility>
// are included.
SYMBOL(tuple_size, std::, <tuple>)
SYMBOL(tuple_size, std::, <array>)
SYMBOL(tuple_size, std::, <ranges>)
SYMBOL(tuple_size, std::, <utility>)
SYMBOL(tuple_element, std::, <tuple>)
SYMBOL(tuple_element, std::, <array>)
SYMBOL(tuple_element, std::, <ranges>)
SYMBOL(tuple_element, std::, <utility>)
// C++ [iterator.range 25.7]: In addition to being available via inclusion of
// the <iterator> header, the function templates in [iterator.range] are
// available when any of the following headers are included: <array>, <deque>,
// <forward_­list>, ... and <vector>.
SYMBOL(begin, std::, <iterator>)
SYMBOL(begin, std::, <array>)
SYMBOL(begin, std::, <deque>)
SYMBOL(begin, std::, <forward_list>)
SYMBOL(begin, std::, <list>)
SYMBOL(begin, std::, <map>)
SYMBOL(begin, std::, <regex>)
SYMBOL(begin, std::, <set>)
SYMBOL(begin, std::, <span>)
SYMBOL(begin, std::, <string>)
SYMBOL(begin, std::, <string_view>)
SYMBOL(begin, std::, <unordered_map>)
SYMBOL(begin, std::, <unordered_set>)
SYMBOL(begin, std::, <vector>)
SYMBOL(cbegin, std::, <iterator>)
SYMBOL(cbegin, std::, <array>)
SYMBOL(cbegin, std::, <deque>)
SYMBOL(cbegin, std::, <forward_list>)
SYMBOL(cbegin, std::, <list>)
SYMBOL(cbegin, std::, <map>)
SYMBOL(cbegin, std::, <regex>)
SYMBOL(cbegin, std::, <set>)
SYMBOL(cbegin, std::, <span>)
SYMBOL(cbegin, std::, <string>)
SYMBOL(cbegin, std::, <string_view>)
SYMBOL(cbegin, std::, <unordered_map>)
SYMBOL(cbegin, std::, <unordered_set>)
SYMBOL(cbegin, std::, <vector>)
SYMBOL(cend, std::, <iterator>)
SYMBOL(cend, std::, <array>)
SYMBOL(cend, std::, <deque>)
SYMBOL(cend, std::, <forward_list>)
SYMBOL(cend, std::, <list>)
SYMBOL(cend, std::, <map>)
SYMBOL(cend, std::, <regex>)
SYMBOL(cend, std::, <set>)
SYMBOL(cend, std::, <span>)
SYMBOL(cend, std::, <string>)
SYMBOL(cend, std::, <string_view>)
SYMBOL(cend, std::, <unordered_map>)
SYMBOL(cend, std::, <unordered_set>)
SYMBOL(cend, std::, <vector>)
SYMBOL(crbegin, std::, <iterator>)
SYMBOL(crbegin, std::, <array>)
SYMBOL(crbegin, std::, <deque>)
SYMBOL(crbegin, std::, <forward_list>)
SYMBOL(crbegin, std::, <list>)
SYMBOL(crbegin, std::, <map>)
SYMBOL(crbegin, std::, <regex>)
SYMBOL(crbegin, std::, <set>)
SYMBOL(crbegin, std::, <span>)
SYMBOL(crbegin, std::, <string>)
SYMBOL(crbegin, std::, <string_view>)
SYMBOL(crbegin, std::, <unordered_map>)
SYMBOL(crbegin, std::, <unordered_set>)
SYMBOL(crbegin, std::, <vector>)
SYMBOL(crend, std::, <iterator>)
SYMBOL(crend, std::, <array>)
SYMBOL(crend, std::, <deque>)
SYMBOL(crend, std::, <forward_list>)
SYMBOL(crend, std::, <list>)
SYMBOL(crend, std::, <map>)
SYMBOL(crend, std::, <regex>)
SYMBOL(crend, std::, <set>)
SYMBOL(crend, std::, <span>)
SYMBOL(crend, std::, <string>)
SYMBOL(crend, std::, <string_view>)
SYMBOL(crend, std::, <unordered_map>)
SYMBOL(crend, std::, <unordered_set>)
SYMBOL(crend, std::, <vector>)
SYMBOL(data, std::, <iterator>)
SYMBOL(data, std::, <array>)
SYMBOL(data, std::, <deque>)
SYMBOL(data, std::, <forward_list>)
SYMBOL(data, std::, <list>)
SYMBOL(data, std::, <map>)
SYMBOL(data, std::, <regex>)
SYMBOL(data, std::, <set>)
SYMBOL(data, std::, <span>)
SYMBOL(data, std::, <string>)
SYMBOL(data, std::, <string_view>)
SYMBOL(data, std::, <unordered_map>)
SYMBOL(data, std::, <unordered_set>)
SYMBOL(data, std::, <vector>)
SYMBOL(empty, std::, <iterator>)
SYMBOL(empty, std::, <array>)
SYMBOL(empty, std::, <deque>)
SYMBOL(empty, std::, <forward_list>)
SYMBOL(empty, std::, <list>)
SYMBOL(empty, std::, <map>)
SYMBOL(empty, std::, <regex>)
SYMBOL(empty, std::, <set>)
SYMBOL(empty, std::, <span>)
SYMBOL(empty, std::, <string>)
SYMBOL(empty, std::, <string_view>)
SYMBOL(empty, std::, <unordered_map>)
SYMBOL(empty, std::, <unordered_set>)
SYMBOL(empty, std::, <vector>)
SYMBOL(end, std::, <iterator>)
SYMBOL(end, std::, <array>)
SYMBOL(end, std::, <deque>)
SYMBOL(end, std::, <forward_list>)
SYMBOL(end, std::, <list>)
SYMBOL(end, std::, <map>)
SYMBOL(end, std::, <regex>)
SYMBOL(end, std::, <set>)
SYMBOL(end, std::, <span>)
SYMBOL(end, std::, <string>)
SYMBOL(end, std::, <string_view>)
SYMBOL(end, std::, <unordered_map>)
SYMBOL(end, std::, <unordered_set>)
SYMBOL(end, std::, <vector>)
SYMBOL(rbegin, std::, <iterator>)
SYMBOL(rbegin, std::, <array>)
SYMBOL(rbegin, std::, <deque>)
SYMBOL(rbegin, std::, <forward_list>)
SYMBOL(rbegin, std::, <list>)
SYMBOL(rbegin, std::, <map>)
SYMBOL(rbegin, std::, <regex>)
SYMBOL(rbegin, std::, <set>)
SYMBOL(rbegin, std::, <span>)
SYMBOL(rbegin, std::, <string>)
SYMBOL(rbegin, std::, <string_view>)
SYMBOL(rbegin, std::, <unordered_map>)
SYMBOL(rbegin, std::, <unordered_set>)
SYMBOL(rbegin, std::, <vector>)
SYMBOL(rend, std::, <iterator>)
SYMBOL(rend, std::, <array>)
SYMBOL(rend, std::, <deque>)
SYMBOL(rend, std::, <forward_list>)
SYMBOL(rend, std::, <list>)
SYMBOL(rend, std::, <map>)
SYMBOL(rend, std::, <regex>)
SYMBOL(rend, std::, <set>)
SYMBOL(rend, std::, <span>)
SYMBOL(rend, std::, <string>)
SYMBOL(rend, std::, <string_view>)
SYMBOL(rend, std::, <unordered_map>)
SYMBOL(rend, std::, <unordered_set>)
SYMBOL(rend, std::, <vector>)
SYMBOL(size, std::, <iterator>)
SYMBOL(size, std::, <array>)
SYMBOL(size, std::, <deque>)
SYMBOL(size, std::, <forward_list>)
SYMBOL(size, std::, <list>)
SYMBOL(size, std::, <map>)
SYMBOL(size, std::, <regex>)
SYMBOL(size, std::, <set>)
SYMBOL(size, std::, <span>)
SYMBOL(size, std::, <string>)
SYMBOL(size, std::, <string_view>)
SYMBOL(size, std::, <unordered_map>)
SYMBOL(size, std::, <unordered_set>)
SYMBOL(size, std::, <vector>)
SYMBOL(ssize, std::, <iterator>)
SYMBOL(ssize, std::, <array>)
SYMBOL(ssize, std::, <deque>)
SYMBOL(ssize, std::, <forward_list>)
SYMBOL(ssize, std::, <list>)
SYMBOL(ssize, std::, <map>)
SYMBOL(ssize, std::, <regex>)
SYMBOL(ssize, std::, <set>)
SYMBOL(ssize, std::, <span>)
SYMBOL(ssize, std::, <string>)
SYMBOL(ssize, std::, <string_view>)
SYMBOL(ssize, std::, <unordered_map>)
SYMBOL(ssize, std::, <unordered_set>)
SYMBOL(ssize, std::, <vector>)

// Add headers for generic integer-type abs.
// Ignore other variants (std::complex, std::valarray, std::intmax_t)
SYMBOL(abs, std::, <cstdlib>)
SYMBOL(abs, std::, <cmath>)
SYMBOL(abs, None, <cstdlib>)
SYMBOL(abs, None, <stdlib.h>)
SYMBOL(abs, None, <cmath>)
SYMBOL(abs, None, <math.h>)

// Only add headers for the generic atomic template.
// Ignore variants (std::weak_ptr, std::shared_ptr).
SYMBOL(atomic, std::, <atomic>)
// atomic_* family symbols. <stdatomic.h> is for C compatibility.
SYMBOL(atomic_bool, std::, <atomic>)
SYMBOL(atomic_bool, None, <stdatomic.h>)
SYMBOL(atomic_char, std::, <atomic>)
SYMBOL(atomic_char, None, <stdatomic.h>)
SYMBOL(atomic_char16_t, std::, <atomic>)
SYMBOL(atomic_char16_t, None, <stdatomic.h>)
SYMBOL(atomic_char32_t, std::, <atomic>)
SYMBOL(atomic_char32_t, None, <stdatomic.h>)
SYMBOL(atomic_char8_t, std::, <atomic>)
SYMBOL(atomic_char8_t, None, <stdatomic.h>)
SYMBOL(atomic_int, std::, <atomic>)
SYMBOL(atomic_int, None, <stdatomic.h>)
SYMBOL(atomic_int16_t, std::, <atomic>)
SYMBOL(atomic_int16_t, None, <stdatomic.h>)
SYMBOL(atomic_int32_t, std::, <atomic>)
SYMBOL(atomic_int32_t, None, <stdatomic.h>)
SYMBOL(atomic_int64_t, std::, <atomic>)
SYMBOL(atomic_int64_t, None, <stdatomic.h>)
SYMBOL(atomic_int8_t, std::, <atomic>)
SYMBOL(atomic_int8_t, None, <stdatomic.h>)
SYMBOL(atomic_int_fast16_t, std::, <atomic>)
SYMBOL(atomic_int_fast16_t, None, <stdatomic.h>)
SYMBOL(atomic_int_fast32_t, std::, <atomic>)
SYMBOL(atomic_int_fast32_t, None, <stdatomic.h>)
SYMBOL(atomic_int_fast64_t, std::, <atomic>)
SYMBOL(atomic_int_fast64_t, None, <stdatomic.h>)
SYMBOL(atomic_int_fast8_t, std::, <atomic>)
SYMBOL(atomic_int_fast8_t, None, <stdatomic.h>)
SYMBOL(atomic_int_least16_t, std::, <atomic>)
SYMBOL(atomic_int_least16_t, None, <stdatomic.h>)
SYMBOL(atomic_int_least32_t, std::, <atomic>)
SYMBOL(atomic_int_least32_t, None, <stdatomic.h>)
SYMBOL(atomic_int_least64_t, std::, <atomic>)
SYMBOL(atomic_int_least64_t, None, <stdatomic.h>)
SYMBOL(atomic_int_least8_t, std::, <atomic>)
SYMBOL(atomic_int_least8_t, None, <stdatomic.h>)
SYMBOL(atomic_intmax_t, std::, <atomic>)
SYMBOL(atomic_intmax_t, None, <stdatomic.h>)
SYMBOL(atomic_intptr_t, std::, <atomic>)
SYMBOL(atomic_intptr_t, None, <stdatomic.h>)
SYMBOL(atomic_llong, std::, <atomic>)
SYMBOL(atomic_llong, None, <stdatomic.h>)
SYMBOL(atomic_long, std::, <atomic>)
SYMBOL(atomic_long, None, <stdatomic.h>)
SYMBOL(atomic_ptrdiff_t, std::, <atomic>)
SYMBOL(atomic_ptrdiff_t, None, <stdatomic.h>)
SYMBOL(atomic_schar, std::, <atomic>)
SYMBOL(atomic_schar, None, <stdatomic.h>)
SYMBOL(atomic_short, std::, <atomic>)
SYMBOL(atomic_short, None, <stdatomic.h>)
SYMBOL(atomic_signed_lock_free, std::, <atomic>)
SYMBOL(atomic_signed_lock_free, None, <stdatomic.h>)
SYMBOL(atomic_size_t, std::, <atomic>)
SYMBOL(atomic_size_t, None, <stdatomic.h>)
SYMBOL(atomic_uchar, std::, <atomic>)
SYMBOL(atomic_uchar, None, <stdatomic.h>)
SYMBOL(atomic_uint, std::, <atomic>)
SYMBOL(atomic_uint, None, <stdatomic.h>)
SYMBOL(atomic_uint16_t, std::, <atomic>)
SYMBOL(atomic_uint16_t, None, <stdatomic.h>)
SYMBOL(atomic_uint32_t, std::, <atomic>)
SYMBOL(atomic_uint32_t, None, <stdatomic.h>)
SYMBOL(atomic_uint64_t, std::, <atomic>)
SYMBOL(atomic_uint64_t, None, <stdatomic.h>)
SYMBOL(atomic_uint8_t, std::, <atomic>)
SYMBOL(atomic_uint8_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_fast16_t, std::, <atomic>)
SYMBOL(atomic_uint_fast16_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_fast32_t, std::, <atomic>)
SYMBOL(atomic_uint_fast32_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_fast64_t, std::, <atomic>)
SYMBOL(atomic_uint_fast64_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_fast8_t, std::, <atomic>)
SYMBOL(atomic_uint_fast8_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_least16_t, std::, <atomic>)
SYMBOL(atomic_uint_least16_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_least32_t, std::, <atomic>)
SYMBOL(atomic_uint_least32_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_least64_t, std::, <atomic>)
SYMBOL(atomic_uint_least64_t, None, <stdatomic.h>)
SYMBOL(atomic_uint_least8_t, std::, <atomic>)
SYMBOL(atomic_uint_least8_t, None, <stdatomic.h>)
SYMBOL(atomic_uintmax_t, std::, <atomic>)
SYMBOL(atomic_uintmax_t, None, <stdatomic.h>)
SYMBOL(atomic_uintptr_t, std::, <atomic>)
SYMBOL(atomic_uintptr_t, None, <stdatomic.h>)
SYMBOL(atomic_ullong, std::, <atomic>)
SYMBOL(atomic_ullong, None, <stdatomic.h>)
SYMBOL(atomic_ulong, std::, <atomic>)
SYMBOL(atomic_ulong, None, <stdatomic.h>)
SYMBOL(atomic_unsigned_lock_free, std::, <atomic>)
SYMBOL(atomic_unsigned_lock_free, None, <stdatomic.h>)
SYMBOL(atomic_ushort, std::, <atomic>)
SYMBOL(atomic_ushort, None, <stdatomic.h>)
SYMBOL(atomic_wchar_t, std::, <atomic>)
SYMBOL(atomic_wchar_t, None, <stdatomic.h>)

// std::get has a few variants for different types (tuple, array, pair etc)
// which is tricky to disambiguate without type information.
// Don't set any header for it, as it comes with the type header.
SYMBOL(get, std::, /*no headers*/)

// cppreference symbol index page was missing these symbols.
// Remove them when the cppreference offline archive catches up.
SYMBOL(index_sequence, std::, <utility>)
SYMBOL(index_sequence_for, std::, <utility>)
SYMBOL(make_index_sequence, std::, <utility>)
SYMBOL(make_integer_sequence, std::, <utility>)

// The std::placeholder symbols (_1, ..., _N) are listed in the cppreference
// placeholder.html, but the index only contains a single entry with "_1, _2, ..., _N"
// text, which are not handled by the script.
// N is an implementation-defined number (10 for libc++; 29 for libstdc++).
SYMBOL(_1, std::placeholders::, <functional>)
SYMBOL(_2, std::placeholders::, <functional>)
SYMBOL(_3, std::placeholders::, <functional>)
SYMBOL(_4, std::placeholders::, <functional>)
SYMBOL(_5, std::placeholders::, <functional>)
SYMBOL(_6, std::placeholders::, <functional>)
SYMBOL(_7, std::placeholders::, <functional>)
SYMBOL(_8, std::placeholders::, <functional>)
SYMBOL(_9, std::placeholders::, <functional>)
SYMBOL(_10, std::placeholders::, <functional>)
SYMBOL(_11, std::placeholders::, <functional>)
SYMBOL(_12, std::placeholders::, <functional>)
SYMBOL(_13, std::placeholders::, <functional>)
SYMBOL(_14, std::placeholders::, <functional>)
SYMBOL(_15, std::placeholders::, <functional>)
SYMBOL(_16, std::placeholders::, <functional>)
SYMBOL(_17, std::placeholders::, <functional>)
SYMBOL(_18, std::placeholders::, <functional>)
SYMBOL(_19, std::placeholders::, <functional>)
SYMBOL(_20, std::placeholders::, <functional>)
SYMBOL(_21, std::placeholders::, <functional>)
SYMBOL(_22, std::placeholders::, <functional>)
SYMBOL(_23, std::placeholders::, <functional>)
SYMBOL(_24, std::placeholders::, <functional>)
SYMBOL(_25, std::placeholders::, <functional>)
SYMBOL(_26, std::placeholders::, <functional>)
SYMBOL(_27, std::placeholders::, <functional>)
SYMBOL(_28, std::placeholders::, <functional>)
SYMBOL(_29, std::placeholders::, <functional>)

// Macros
SYMBOL(NULL, None, <cstddef>)
SYMBOL(NULL, None, <stddef.h>)
SYMBOL(NULL, None, <cstdlib>)
SYMBOL(NULL, None, <stdlib.h>)
SYMBOL(NULL, None, <cstring>)
SYMBOL(NULL, None, <string.h>)
SYMBOL(NULL, None, <cwchar>)
SYMBOL(NULL, None, <wchar.h>)
SYMBOL(NULL, None, <ctime>)
SYMBOL(NULL, None, <time.h>)
SYMBOL(NULL, None, <clocale>)
SYMBOL(NULL, None, <locale.h>)
SYMBOL(NULL, None, <cstdio>)
SYMBOL(NULL, None, <stdio.h>)
