// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv64 -target-feature +v -target-feature +zfh \
// RUN:   -target-feature +experimental-zvfh -disable-O0-optnone  \
// RUN:   -emit-llvm %s -o - | opt -S -passes=mem2reg | \
// RUN:   FileCheck --check-prefix=CHECK-RV64 %s

#include <riscv_vector.h>

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x half> @test_vslideup_vx_f16mf4_tu
// CHECK-RV64-SAME: (<vscale x 1 x half> [[DEST:%.*]], <vscale x 1 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.vslideup.nxv1f16.i64(<vscale x 1 x half> [[DEST]], <vscale x 1 x half> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_vslideup_vx_f16mf4_tu(vfloat16mf4_t dest, vfloat16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x half> @test_vslideup_vx_f16mf2_tu
// CHECK-RV64-SAME: (<vscale x 2 x half> [[DEST:%.*]], <vscale x 2 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.vslideup.nxv2f16.i64(<vscale x 2 x half> [[DEST]], <vscale x 2 x half> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_vslideup_vx_f16mf2_tu(vfloat16mf2_t dest, vfloat16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x half> @test_vslideup_vx_f16m1_tu
// CHECK-RV64-SAME: (<vscale x 4 x half> [[DEST:%.*]], <vscale x 4 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vslideup.nxv4f16.i64(<vscale x 4 x half> [[DEST]], <vscale x 4 x half> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vslideup_vx_f16m1_tu(vfloat16m1_t dest, vfloat16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x half> @test_vslideup_vx_f16m2_tu
// CHECK-RV64-SAME: (<vscale x 8 x half> [[DEST:%.*]], <vscale x 8 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.vslideup.nxv8f16.i64(<vscale x 8 x half> [[DEST]], <vscale x 8 x half> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_vslideup_vx_f16m2_tu(vfloat16m2_t dest, vfloat16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x half> @test_vslideup_vx_f16m4_tu
// CHECK-RV64-SAME: (<vscale x 16 x half> [[DEST:%.*]], <vscale x 16 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.vslideup.nxv16f16.i64(<vscale x 16 x half> [[DEST]], <vscale x 16 x half> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_vslideup_vx_f16m4_tu(vfloat16m4_t dest, vfloat16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x half> @test_vslideup_vx_f16m8_tu
// CHECK-RV64-SAME: (<vscale x 32 x half> [[DEST:%.*]], <vscale x 32 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.vslideup.nxv32f16.i64(<vscale x 32 x half> [[DEST]], <vscale x 32 x half> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_vslideup_vx_f16m8_tu(vfloat16m8_t dest, vfloat16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x float> @test_vslideup_vx_f32mf2_tu
// CHECK-RV64-SAME: (<vscale x 1 x float> [[DEST:%.*]], <vscale x 1 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x float> @llvm.riscv.vslideup.nxv1f32.i64(<vscale x 1 x float> [[DEST]], <vscale x 1 x float> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x float> [[TMP0]]
//
vfloat32mf2_t test_vslideup_vx_f32mf2_tu(vfloat32mf2_t dest, vfloat32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x float> @test_vslideup_vx_f32m1_tu
// CHECK-RV64-SAME: (<vscale x 2 x float> [[DEST:%.*]], <vscale x 2 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x float> @llvm.riscv.vslideup.nxv2f32.i64(<vscale x 2 x float> [[DEST]], <vscale x 2 x float> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x float> [[TMP0]]
//
vfloat32m1_t test_vslideup_vx_f32m1_tu(vfloat32m1_t dest, vfloat32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x float> @test_vslideup_vx_f32m2_tu
// CHECK-RV64-SAME: (<vscale x 4 x float> [[DEST:%.*]], <vscale x 4 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x float> @llvm.riscv.vslideup.nxv4f32.i64(<vscale x 4 x float> [[DEST]], <vscale x 4 x float> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
vfloat32m2_t test_vslideup_vx_f32m2_tu(vfloat32m2_t dest, vfloat32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x float> @test_vslideup_vx_f32m4_tu
// CHECK-RV64-SAME: (<vscale x 8 x float> [[DEST:%.*]], <vscale x 8 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x float> @llvm.riscv.vslideup.nxv8f32.i64(<vscale x 8 x float> [[DEST]], <vscale x 8 x float> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
vfloat32m4_t test_vslideup_vx_f32m4_tu(vfloat32m4_t dest, vfloat32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x float> @test_vslideup_vx_f32m8_tu
// CHECK-RV64-SAME: (<vscale x 16 x float> [[DEST:%.*]], <vscale x 16 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x float> @llvm.riscv.vslideup.nxv16f32.i64(<vscale x 16 x float> [[DEST]], <vscale x 16 x float> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
vfloat32m8_t test_vslideup_vx_f32m8_tu(vfloat32m8_t dest, vfloat32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x double> @test_vslideup_vx_f64m1_tu
// CHECK-RV64-SAME: (<vscale x 1 x double> [[DEST:%.*]], <vscale x 1 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x double> @llvm.riscv.vslideup.nxv1f64.i64(<vscale x 1 x double> [[DEST]], <vscale x 1 x double> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x double> [[TMP0]]
//
vfloat64m1_t test_vslideup_vx_f64m1_tu(vfloat64m1_t dest, vfloat64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x double> @test_vslideup_vx_f64m2_tu
// CHECK-RV64-SAME: (<vscale x 2 x double> [[DEST:%.*]], <vscale x 2 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x double> @llvm.riscv.vslideup.nxv2f64.i64(<vscale x 2 x double> [[DEST]], <vscale x 2 x double> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
vfloat64m2_t test_vslideup_vx_f64m2_tu(vfloat64m2_t dest, vfloat64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x double> @test_vslideup_vx_f64m4_tu
// CHECK-RV64-SAME: (<vscale x 4 x double> [[DEST:%.*]], <vscale x 4 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x double> @llvm.riscv.vslideup.nxv4f64.i64(<vscale x 4 x double> [[DEST]], <vscale x 4 x double> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
vfloat64m4_t test_vslideup_vx_f64m4_tu(vfloat64m4_t dest, vfloat64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x double> @test_vslideup_vx_f64m8_tu
// CHECK-RV64-SAME: (<vscale x 8 x double> [[DEST:%.*]], <vscale x 8 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x double> @llvm.riscv.vslideup.nxv8f64.i64(<vscale x 8 x double> [[DEST]], <vscale x 8 x double> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
vfloat64m8_t test_vslideup_vx_f64m8_tu(vfloat64m8_t dest, vfloat64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vslideup_vx_i8mf8_tu
// CHECK-RV64-SAME: (<vscale x 1 x i8> [[DEST:%.*]], <vscale x 1 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vslideup.nxv1i8.i64(<vscale x 1 x i8> [[DEST]], <vscale x 1 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vint8mf8_t test_vslideup_vx_i8mf8_tu(vint8mf8_t dest, vint8mf8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vslideup_vx_i8mf4_tu
// CHECK-RV64-SAME: (<vscale x 2 x i8> [[DEST:%.*]], <vscale x 2 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vslideup.nxv2i8.i64(<vscale x 2 x i8> [[DEST]], <vscale x 2 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vint8mf4_t test_vslideup_vx_i8mf4_tu(vint8mf4_t dest, vint8mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vslideup_vx_i8mf2_tu
// CHECK-RV64-SAME: (<vscale x 4 x i8> [[DEST:%.*]], <vscale x 4 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vslideup.nxv4i8.i64(<vscale x 4 x i8> [[DEST]], <vscale x 4 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vint8mf2_t test_vslideup_vx_i8mf2_tu(vint8mf2_t dest, vint8mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vslideup_vx_i8m1_tu
// CHECK-RV64-SAME: (<vscale x 8 x i8> [[DEST:%.*]], <vscale x 8 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vslideup.nxv8i8.i64(<vscale x 8 x i8> [[DEST]], <vscale x 8 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vint8m1_t test_vslideup_vx_i8m1_tu(vint8m1_t dest, vint8m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vslideup_vx_i8m2_tu
// CHECK-RV64-SAME: (<vscale x 16 x i8> [[DEST:%.*]], <vscale x 16 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vslideup.nxv16i8.i64(<vscale x 16 x i8> [[DEST]], <vscale x 16 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vint8m2_t test_vslideup_vx_i8m2_tu(vint8m2_t dest, vint8m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vslideup_vx_i8m4_tu
// CHECK-RV64-SAME: (<vscale x 32 x i8> [[DEST:%.*]], <vscale x 32 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vslideup.nxv32i8.i64(<vscale x 32 x i8> [[DEST]], <vscale x 32 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vint8m4_t test_vslideup_vx_i8m4_tu(vint8m4_t dest, vint8m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vslideup_vx_i8m8_tu
// CHECK-RV64-SAME: (<vscale x 64 x i8> [[DEST:%.*]], <vscale x 64 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vslideup.nxv64i8.i64(<vscale x 64 x i8> [[DEST]], <vscale x 64 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vint8m8_t test_vslideup_vx_i8m8_tu(vint8m8_t dest, vint8m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vslideup_vx_i16mf4_tu
// CHECK-RV64-SAME: (<vscale x 1 x i16> [[DEST:%.*]], <vscale x 1 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vslideup.nxv1i16.i64(<vscale x 1 x i16> [[DEST]], <vscale x 1 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vint16mf4_t test_vslideup_vx_i16mf4_tu(vint16mf4_t dest, vint16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vslideup_vx_i16mf2_tu
// CHECK-RV64-SAME: (<vscale x 2 x i16> [[DEST:%.*]], <vscale x 2 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vslideup.nxv2i16.i64(<vscale x 2 x i16> [[DEST]], <vscale x 2 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vint16mf2_t test_vslideup_vx_i16mf2_tu(vint16mf2_t dest, vint16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vslideup_vx_i16m1_tu
// CHECK-RV64-SAME: (<vscale x 4 x i16> [[DEST:%.*]], <vscale x 4 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vslideup.nxv4i16.i64(<vscale x 4 x i16> [[DEST]], <vscale x 4 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vint16m1_t test_vslideup_vx_i16m1_tu(vint16m1_t dest, vint16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vslideup_vx_i16m2_tu
// CHECK-RV64-SAME: (<vscale x 8 x i16> [[DEST:%.*]], <vscale x 8 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vslideup.nxv8i16.i64(<vscale x 8 x i16> [[DEST]], <vscale x 8 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vint16m2_t test_vslideup_vx_i16m2_tu(vint16m2_t dest, vint16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vslideup_vx_i16m4_tu
// CHECK-RV64-SAME: (<vscale x 16 x i16> [[DEST:%.*]], <vscale x 16 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vslideup.nxv16i16.i64(<vscale x 16 x i16> [[DEST]], <vscale x 16 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vint16m4_t test_vslideup_vx_i16m4_tu(vint16m4_t dest, vint16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vslideup_vx_i16m8_tu
// CHECK-RV64-SAME: (<vscale x 32 x i16> [[DEST:%.*]], <vscale x 32 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vslideup.nxv32i16.i64(<vscale x 32 x i16> [[DEST]], <vscale x 32 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vint16m8_t test_vslideup_vx_i16m8_tu(vint16m8_t dest, vint16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i32> @test_vslideup_vx_i32mf2_tu
// CHECK-RV64-SAME: (<vscale x 1 x i32> [[DEST:%.*]], <vscale x 1 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.vslideup.nxv1i32.i64(<vscale x 1 x i32> [[DEST]], <vscale x 1 x i32> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vint32mf2_t test_vslideup_vx_i32mf2_tu(vint32mf2_t dest, vint32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i32> @test_vslideup_vx_i32m1_tu
// CHECK-RV64-SAME: (<vscale x 2 x i32> [[DEST:%.*]], <vscale x 2 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.vslideup.nxv2i32.i64(<vscale x 2 x i32> [[DEST]], <vscale x 2 x i32> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vint32m1_t test_vslideup_vx_i32m1_tu(vint32m1_t dest, vint32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i32> @test_vslideup_vx_i32m2_tu
// CHECK-RV64-SAME: (<vscale x 4 x i32> [[DEST:%.*]], <vscale x 4 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.vslideup.nxv4i32.i64(<vscale x 4 x i32> [[DEST]], <vscale x 4 x i32> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vint32m2_t test_vslideup_vx_i32m2_tu(vint32m2_t dest, vint32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vslideup_vx_i32m4_tu
// CHECK-RV64-SAME: (<vscale x 8 x i32> [[DEST:%.*]], <vscale x 8 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.vslideup.nxv8i32.i64(<vscale x 8 x i32> [[DEST]], <vscale x 8 x i32> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vint32m4_t test_vslideup_vx_i32m4_tu(vint32m4_t dest, vint32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vslideup_vx_i32m8_tu
// CHECK-RV64-SAME: (<vscale x 16 x i32> [[DEST:%.*]], <vscale x 16 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.vslideup.nxv16i32.i64(<vscale x 16 x i32> [[DEST]], <vscale x 16 x i32> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vint32m8_t test_vslideup_vx_i32m8_tu(vint32m8_t dest, vint32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i64> @test_vslideup_vx_i64m1_tu
// CHECK-RV64-SAME: (<vscale x 1 x i64> [[DEST:%.*]], <vscale x 1 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.vslideup.nxv1i64.i64(<vscale x 1 x i64> [[DEST]], <vscale x 1 x i64> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vint64m1_t test_vslideup_vx_i64m1_tu(vint64m1_t dest, vint64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i64> @test_vslideup_vx_i64m2_tu
// CHECK-RV64-SAME: (<vscale x 2 x i64> [[DEST:%.*]], <vscale x 2 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.vslideup.nxv2i64.i64(<vscale x 2 x i64> [[DEST]], <vscale x 2 x i64> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vint64m2_t test_vslideup_vx_i64m2_tu(vint64m2_t dest, vint64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vslideup_vx_i64m4_tu
// CHECK-RV64-SAME: (<vscale x 4 x i64> [[DEST:%.*]], <vscale x 4 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.vslideup.nxv4i64.i64(<vscale x 4 x i64> [[DEST]], <vscale x 4 x i64> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vint64m4_t test_vslideup_vx_i64m4_tu(vint64m4_t dest, vint64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vslideup_vx_i64m8_tu
// CHECK-RV64-SAME: (<vscale x 8 x i64> [[DEST:%.*]], <vscale x 8 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.vslideup.nxv8i64.i64(<vscale x 8 x i64> [[DEST]], <vscale x 8 x i64> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vint64m8_t test_vslideup_vx_i64m8_tu(vint64m8_t dest, vint64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vslideup_vx_u8mf8_tu
// CHECK-RV64-SAME: (<vscale x 1 x i8> [[DEST:%.*]], <vscale x 1 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vslideup.nxv1i8.i64(<vscale x 1 x i8> [[DEST]], <vscale x 1 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_vslideup_vx_u8mf8_tu(vuint8mf8_t dest, vuint8mf8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vslideup_vx_u8mf4_tu
// CHECK-RV64-SAME: (<vscale x 2 x i8> [[DEST:%.*]], <vscale x 2 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vslideup.nxv2i8.i64(<vscale x 2 x i8> [[DEST]], <vscale x 2 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_vslideup_vx_u8mf4_tu(vuint8mf4_t dest, vuint8mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vslideup_vx_u8mf2_tu
// CHECK-RV64-SAME: (<vscale x 4 x i8> [[DEST:%.*]], <vscale x 4 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vslideup.nxv4i8.i64(<vscale x 4 x i8> [[DEST]], <vscale x 4 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_vslideup_vx_u8mf2_tu(vuint8mf2_t dest, vuint8mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vslideup_vx_u8m1_tu
// CHECK-RV64-SAME: (<vscale x 8 x i8> [[DEST:%.*]], <vscale x 8 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vslideup.nxv8i8.i64(<vscale x 8 x i8> [[DEST]], <vscale x 8 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_vslideup_vx_u8m1_tu(vuint8m1_t dest, vuint8m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vslideup_vx_u8m2_tu
// CHECK-RV64-SAME: (<vscale x 16 x i8> [[DEST:%.*]], <vscale x 16 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vslideup.nxv16i8.i64(<vscale x 16 x i8> [[DEST]], <vscale x 16 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_vslideup_vx_u8m2_tu(vuint8m2_t dest, vuint8m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vslideup_vx_u8m4_tu
// CHECK-RV64-SAME: (<vscale x 32 x i8> [[DEST:%.*]], <vscale x 32 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vslideup.nxv32i8.i64(<vscale x 32 x i8> [[DEST]], <vscale x 32 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_vslideup_vx_u8m4_tu(vuint8m4_t dest, vuint8m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vslideup_vx_u8m8_tu
// CHECK-RV64-SAME: (<vscale x 64 x i8> [[DEST:%.*]], <vscale x 64 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vslideup.nxv64i8.i64(<vscale x 64 x i8> [[DEST]], <vscale x 64 x i8> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vslideup_vx_u8m8_tu(vuint8m8_t dest, vuint8m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vslideup_vx_u16mf4_tu
// CHECK-RV64-SAME: (<vscale x 1 x i16> [[DEST:%.*]], <vscale x 1 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vslideup.nxv1i16.i64(<vscale x 1 x i16> [[DEST]], <vscale x 1 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_vslideup_vx_u16mf4_tu(vuint16mf4_t dest, vuint16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vslideup_vx_u16mf2_tu
// CHECK-RV64-SAME: (<vscale x 2 x i16> [[DEST:%.*]], <vscale x 2 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vslideup.nxv2i16.i64(<vscale x 2 x i16> [[DEST]], <vscale x 2 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_vslideup_vx_u16mf2_tu(vuint16mf2_t dest, vuint16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vslideup_vx_u16m1_tu
// CHECK-RV64-SAME: (<vscale x 4 x i16> [[DEST:%.*]], <vscale x 4 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vslideup.nxv4i16.i64(<vscale x 4 x i16> [[DEST]], <vscale x 4 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_vslideup_vx_u16m1_tu(vuint16m1_t dest, vuint16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vslideup_vx_u16m2_tu
// CHECK-RV64-SAME: (<vscale x 8 x i16> [[DEST:%.*]], <vscale x 8 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vslideup.nxv8i16.i64(<vscale x 8 x i16> [[DEST]], <vscale x 8 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_vslideup_vx_u16m2_tu(vuint16m2_t dest, vuint16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vslideup_vx_u16m4_tu
// CHECK-RV64-SAME: (<vscale x 16 x i16> [[DEST:%.*]], <vscale x 16 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vslideup.nxv16i16.i64(<vscale x 16 x i16> [[DEST]], <vscale x 16 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_vslideup_vx_u16m4_tu(vuint16m4_t dest, vuint16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vslideup_vx_u16m8_tu
// CHECK-RV64-SAME: (<vscale x 32 x i16> [[DEST:%.*]], <vscale x 32 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vslideup.nxv32i16.i64(<vscale x 32 x i16> [[DEST]], <vscale x 32 x i16> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vslideup_vx_u16m8_tu(vuint16m8_t dest, vuint16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i32> @test_vslideup_vx_u32mf2_tu
// CHECK-RV64-SAME: (<vscale x 1 x i32> [[DEST:%.*]], <vscale x 1 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.vslideup.nxv1i32.i64(<vscale x 1 x i32> [[DEST]], <vscale x 1 x i32> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_vslideup_vx_u32mf2_tu(vuint32mf2_t dest, vuint32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i32> @test_vslideup_vx_u32m1_tu
// CHECK-RV64-SAME: (<vscale x 2 x i32> [[DEST:%.*]], <vscale x 2 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.vslideup.nxv2i32.i64(<vscale x 2 x i32> [[DEST]], <vscale x 2 x i32> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_vslideup_vx_u32m1_tu(vuint32m1_t dest, vuint32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i32> @test_vslideup_vx_u32m2_tu
// CHECK-RV64-SAME: (<vscale x 4 x i32> [[DEST:%.*]], <vscale x 4 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.vslideup.nxv4i32.i64(<vscale x 4 x i32> [[DEST]], <vscale x 4 x i32> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_vslideup_vx_u32m2_tu(vuint32m2_t dest, vuint32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vslideup_vx_u32m4_tu
// CHECK-RV64-SAME: (<vscale x 8 x i32> [[DEST:%.*]], <vscale x 8 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.vslideup.nxv8i32.i64(<vscale x 8 x i32> [[DEST]], <vscale x 8 x i32> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_vslideup_vx_u32m4_tu(vuint32m4_t dest, vuint32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vslideup_vx_u32m8_tu
// CHECK-RV64-SAME: (<vscale x 16 x i32> [[DEST:%.*]], <vscale x 16 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.vslideup.nxv16i32.i64(<vscale x 16 x i32> [[DEST]], <vscale x 16 x i32> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_vslideup_vx_u32m8_tu(vuint32m8_t dest, vuint32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i64> @test_vslideup_vx_u64m1_tu
// CHECK-RV64-SAME: (<vscale x 1 x i64> [[DEST:%.*]], <vscale x 1 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.vslideup.nxv1i64.i64(<vscale x 1 x i64> [[DEST]], <vscale x 1 x i64> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_vslideup_vx_u64m1_tu(vuint64m1_t dest, vuint64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i64> @test_vslideup_vx_u64m2_tu
// CHECK-RV64-SAME: (<vscale x 2 x i64> [[DEST:%.*]], <vscale x 2 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.vslideup.nxv2i64.i64(<vscale x 2 x i64> [[DEST]], <vscale x 2 x i64> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_vslideup_vx_u64m2_tu(vuint64m2_t dest, vuint64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vslideup_vx_u64m4_tu
// CHECK-RV64-SAME: (<vscale x 4 x i64> [[DEST:%.*]], <vscale x 4 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.vslideup.nxv4i64.i64(<vscale x 4 x i64> [[DEST]], <vscale x 4 x i64> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_vslideup_vx_u64m4_tu(vuint64m4_t dest, vuint64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vslideup_vx_u64m8_tu
// CHECK-RV64-SAME: (<vscale x 8 x i64> [[DEST:%.*]], <vscale x 8 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.vslideup.nxv8i64.i64(<vscale x 8 x i64> [[DEST]], <vscale x 8 x i64> [[SRC]], i64 [[OFFSET]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_vslideup_vx_u64m8_tu(vuint64m8_t dest, vuint64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tu(dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x half> @test_vslideup_vx_f16mf4_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x half> [[DEST:%.*]], <vscale x 1 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.vslideup.mask.nxv1f16.i64(<vscale x 1 x half> [[DEST]], <vscale x 1 x half> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_vslideup_vx_f16mf4_tum(vbool64_t mask, vfloat16mf4_t dest, vfloat16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x half> @test_vslideup_vx_f16mf2_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x half> [[DEST:%.*]], <vscale x 2 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.vslideup.mask.nxv2f16.i64(<vscale x 2 x half> [[DEST]], <vscale x 2 x half> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_vslideup_vx_f16mf2_tum(vbool32_t mask, vfloat16mf2_t dest, vfloat16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x half> @test_vslideup_vx_f16m1_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x half> [[DEST:%.*]], <vscale x 4 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vslideup.mask.nxv4f16.i64(<vscale x 4 x half> [[DEST]], <vscale x 4 x half> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vslideup_vx_f16m1_tum(vbool16_t mask, vfloat16m1_t dest, vfloat16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x half> @test_vslideup_vx_f16m2_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x half> [[DEST:%.*]], <vscale x 8 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.vslideup.mask.nxv8f16.i64(<vscale x 8 x half> [[DEST]], <vscale x 8 x half> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_vslideup_vx_f16m2_tum(vbool8_t mask, vfloat16m2_t dest, vfloat16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x half> @test_vslideup_vx_f16m4_tum
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x half> [[DEST:%.*]], <vscale x 16 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.vslideup.mask.nxv16f16.i64(<vscale x 16 x half> [[DEST]], <vscale x 16 x half> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_vslideup_vx_f16m4_tum(vbool4_t mask, vfloat16m4_t dest, vfloat16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x half> @test_vslideup_vx_f16m8_tum
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x half> [[DEST:%.*]], <vscale x 32 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.vslideup.mask.nxv32f16.i64(<vscale x 32 x half> [[DEST]], <vscale x 32 x half> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_vslideup_vx_f16m8_tum(vbool2_t mask, vfloat16m8_t dest, vfloat16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x float> @test_vslideup_vx_f32mf2_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x float> [[DEST:%.*]], <vscale x 1 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x float> @llvm.riscv.vslideup.mask.nxv1f32.i64(<vscale x 1 x float> [[DEST]], <vscale x 1 x float> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x float> [[TMP0]]
//
vfloat32mf2_t test_vslideup_vx_f32mf2_tum(vbool64_t mask, vfloat32mf2_t dest, vfloat32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x float> @test_vslideup_vx_f32m1_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x float> [[DEST:%.*]], <vscale x 2 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x float> @llvm.riscv.vslideup.mask.nxv2f32.i64(<vscale x 2 x float> [[DEST]], <vscale x 2 x float> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x float> [[TMP0]]
//
vfloat32m1_t test_vslideup_vx_f32m1_tum(vbool32_t mask, vfloat32m1_t dest, vfloat32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x float> @test_vslideup_vx_f32m2_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x float> [[DEST:%.*]], <vscale x 4 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x float> @llvm.riscv.vslideup.mask.nxv4f32.i64(<vscale x 4 x float> [[DEST]], <vscale x 4 x float> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
vfloat32m2_t test_vslideup_vx_f32m2_tum(vbool16_t mask, vfloat32m2_t dest, vfloat32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x float> @test_vslideup_vx_f32m4_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x float> [[DEST:%.*]], <vscale x 8 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x float> @llvm.riscv.vslideup.mask.nxv8f32.i64(<vscale x 8 x float> [[DEST]], <vscale x 8 x float> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
vfloat32m4_t test_vslideup_vx_f32m4_tum(vbool8_t mask, vfloat32m4_t dest, vfloat32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x float> @test_vslideup_vx_f32m8_tum
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x float> [[DEST:%.*]], <vscale x 16 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x float> @llvm.riscv.vslideup.mask.nxv16f32.i64(<vscale x 16 x float> [[DEST]], <vscale x 16 x float> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
vfloat32m8_t test_vslideup_vx_f32m8_tum(vbool4_t mask, vfloat32m8_t dest, vfloat32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x double> @test_vslideup_vx_f64m1_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x double> [[DEST:%.*]], <vscale x 1 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x double> @llvm.riscv.vslideup.mask.nxv1f64.i64(<vscale x 1 x double> [[DEST]], <vscale x 1 x double> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x double> [[TMP0]]
//
vfloat64m1_t test_vslideup_vx_f64m1_tum(vbool64_t mask, vfloat64m1_t dest, vfloat64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x double> @test_vslideup_vx_f64m2_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x double> [[DEST:%.*]], <vscale x 2 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x double> @llvm.riscv.vslideup.mask.nxv2f64.i64(<vscale x 2 x double> [[DEST]], <vscale x 2 x double> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
vfloat64m2_t test_vslideup_vx_f64m2_tum(vbool32_t mask, vfloat64m2_t dest, vfloat64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x double> @test_vslideup_vx_f64m4_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x double> [[DEST:%.*]], <vscale x 4 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x double> @llvm.riscv.vslideup.mask.nxv4f64.i64(<vscale x 4 x double> [[DEST]], <vscale x 4 x double> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
vfloat64m4_t test_vslideup_vx_f64m4_tum(vbool16_t mask, vfloat64m4_t dest, vfloat64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x double> @test_vslideup_vx_f64m8_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x double> [[DEST:%.*]], <vscale x 8 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x double> @llvm.riscv.vslideup.mask.nxv8f64.i64(<vscale x 8 x double> [[DEST]], <vscale x 8 x double> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
vfloat64m8_t test_vslideup_vx_f64m8_tum(vbool8_t mask, vfloat64m8_t dest, vfloat64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vslideup_vx_i8mf8_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i8> [[DEST:%.*]], <vscale x 1 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vslideup.mask.nxv1i8.i64(<vscale x 1 x i8> [[DEST]], <vscale x 1 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vint8mf8_t test_vslideup_vx_i8mf8_tum(vbool64_t mask, vint8mf8_t dest, vint8mf8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vslideup_vx_i8mf4_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i8> [[DEST:%.*]], <vscale x 2 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vslideup.mask.nxv2i8.i64(<vscale x 2 x i8> [[DEST]], <vscale x 2 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vint8mf4_t test_vslideup_vx_i8mf4_tum(vbool32_t mask, vint8mf4_t dest, vint8mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vslideup_vx_i8mf2_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i8> [[DEST:%.*]], <vscale x 4 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vslideup.mask.nxv4i8.i64(<vscale x 4 x i8> [[DEST]], <vscale x 4 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vint8mf2_t test_vslideup_vx_i8mf2_tum(vbool16_t mask, vint8mf2_t dest, vint8mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vslideup_vx_i8m1_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i8> [[DEST:%.*]], <vscale x 8 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vslideup.mask.nxv8i8.i64(<vscale x 8 x i8> [[DEST]], <vscale x 8 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vint8m1_t test_vslideup_vx_i8m1_tum(vbool8_t mask, vint8m1_t dest, vint8m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vslideup_vx_i8m2_tum
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i8> [[DEST:%.*]], <vscale x 16 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vslideup.mask.nxv16i8.i64(<vscale x 16 x i8> [[DEST]], <vscale x 16 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vint8m2_t test_vslideup_vx_i8m2_tum(vbool4_t mask, vint8m2_t dest, vint8m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vslideup_vx_i8m4_tum
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i8> [[DEST:%.*]], <vscale x 32 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vslideup.mask.nxv32i8.i64(<vscale x 32 x i8> [[DEST]], <vscale x 32 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vint8m4_t test_vslideup_vx_i8m4_tum(vbool2_t mask, vint8m4_t dest, vint8m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vslideup_vx_i8m8_tum
// CHECK-RV64-SAME: (<vscale x 64 x i1> [[MASK:%.*]], <vscale x 64 x i8> [[DEST:%.*]], <vscale x 64 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vslideup.mask.nxv64i8.i64(<vscale x 64 x i8> [[DEST]], <vscale x 64 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 64 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vint8m8_t test_vslideup_vx_i8m8_tum(vbool1_t mask, vint8m8_t dest, vint8m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vslideup_vx_i16mf4_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i16> [[DEST:%.*]], <vscale x 1 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vslideup.mask.nxv1i16.i64(<vscale x 1 x i16> [[DEST]], <vscale x 1 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vint16mf4_t test_vslideup_vx_i16mf4_tum(vbool64_t mask, vint16mf4_t dest, vint16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vslideup_vx_i16mf2_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i16> [[DEST:%.*]], <vscale x 2 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vslideup.mask.nxv2i16.i64(<vscale x 2 x i16> [[DEST]], <vscale x 2 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vint16mf2_t test_vslideup_vx_i16mf2_tum(vbool32_t mask, vint16mf2_t dest, vint16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vslideup_vx_i16m1_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i16> [[DEST:%.*]], <vscale x 4 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vslideup.mask.nxv4i16.i64(<vscale x 4 x i16> [[DEST]], <vscale x 4 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vint16m1_t test_vslideup_vx_i16m1_tum(vbool16_t mask, vint16m1_t dest, vint16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vslideup_vx_i16m2_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i16> [[DEST:%.*]], <vscale x 8 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vslideup.mask.nxv8i16.i64(<vscale x 8 x i16> [[DEST]], <vscale x 8 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vint16m2_t test_vslideup_vx_i16m2_tum(vbool8_t mask, vint16m2_t dest, vint16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vslideup_vx_i16m4_tum
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i16> [[DEST:%.*]], <vscale x 16 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vslideup.mask.nxv16i16.i64(<vscale x 16 x i16> [[DEST]], <vscale x 16 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vint16m4_t test_vslideup_vx_i16m4_tum(vbool4_t mask, vint16m4_t dest, vint16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vslideup_vx_i16m8_tum
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i16> [[DEST:%.*]], <vscale x 32 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vslideup.mask.nxv32i16.i64(<vscale x 32 x i16> [[DEST]], <vscale x 32 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vint16m8_t test_vslideup_vx_i16m8_tum(vbool2_t mask, vint16m8_t dest, vint16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i32> @test_vslideup_vx_i32mf2_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i32> [[DEST:%.*]], <vscale x 1 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.vslideup.mask.nxv1i32.i64(<vscale x 1 x i32> [[DEST]], <vscale x 1 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vint32mf2_t test_vslideup_vx_i32mf2_tum(vbool64_t mask, vint32mf2_t dest, vint32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i32> @test_vslideup_vx_i32m1_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i32> [[DEST:%.*]], <vscale x 2 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.vslideup.mask.nxv2i32.i64(<vscale x 2 x i32> [[DEST]], <vscale x 2 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vint32m1_t test_vslideup_vx_i32m1_tum(vbool32_t mask, vint32m1_t dest, vint32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i32> @test_vslideup_vx_i32m2_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i32> [[DEST:%.*]], <vscale x 4 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.vslideup.mask.nxv4i32.i64(<vscale x 4 x i32> [[DEST]], <vscale x 4 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vint32m2_t test_vslideup_vx_i32m2_tum(vbool16_t mask, vint32m2_t dest, vint32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vslideup_vx_i32m4_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i32> [[DEST:%.*]], <vscale x 8 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.vslideup.mask.nxv8i32.i64(<vscale x 8 x i32> [[DEST]], <vscale x 8 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vint32m4_t test_vslideup_vx_i32m4_tum(vbool8_t mask, vint32m4_t dest, vint32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vslideup_vx_i32m8_tum
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i32> [[DEST:%.*]], <vscale x 16 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.vslideup.mask.nxv16i32.i64(<vscale x 16 x i32> [[DEST]], <vscale x 16 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vint32m8_t test_vslideup_vx_i32m8_tum(vbool4_t mask, vint32m8_t dest, vint32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i64> @test_vslideup_vx_i64m1_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i64> [[DEST:%.*]], <vscale x 1 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.vslideup.mask.nxv1i64.i64(<vscale x 1 x i64> [[DEST]], <vscale x 1 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vint64m1_t test_vslideup_vx_i64m1_tum(vbool64_t mask, vint64m1_t dest, vint64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i64> @test_vslideup_vx_i64m2_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i64> [[DEST:%.*]], <vscale x 2 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.vslideup.mask.nxv2i64.i64(<vscale x 2 x i64> [[DEST]], <vscale x 2 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vint64m2_t test_vslideup_vx_i64m2_tum(vbool32_t mask, vint64m2_t dest, vint64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vslideup_vx_i64m4_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i64> [[DEST:%.*]], <vscale x 4 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.vslideup.mask.nxv4i64.i64(<vscale x 4 x i64> [[DEST]], <vscale x 4 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vint64m4_t test_vslideup_vx_i64m4_tum(vbool16_t mask, vint64m4_t dest, vint64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vslideup_vx_i64m8_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i64> [[DEST:%.*]], <vscale x 8 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.vslideup.mask.nxv8i64.i64(<vscale x 8 x i64> [[DEST]], <vscale x 8 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vint64m8_t test_vslideup_vx_i64m8_tum(vbool8_t mask, vint64m8_t dest, vint64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vslideup_vx_u8mf8_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i8> [[DEST:%.*]], <vscale x 1 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vslideup.mask.nxv1i8.i64(<vscale x 1 x i8> [[DEST]], <vscale x 1 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_vslideup_vx_u8mf8_tum(vbool64_t mask, vuint8mf8_t dest, vuint8mf8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vslideup_vx_u8mf4_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i8> [[DEST:%.*]], <vscale x 2 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vslideup.mask.nxv2i8.i64(<vscale x 2 x i8> [[DEST]], <vscale x 2 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_vslideup_vx_u8mf4_tum(vbool32_t mask, vuint8mf4_t dest, vuint8mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vslideup_vx_u8mf2_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i8> [[DEST:%.*]], <vscale x 4 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vslideup.mask.nxv4i8.i64(<vscale x 4 x i8> [[DEST]], <vscale x 4 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_vslideup_vx_u8mf2_tum(vbool16_t mask, vuint8mf2_t dest, vuint8mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vslideup_vx_u8m1_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i8> [[DEST:%.*]], <vscale x 8 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vslideup.mask.nxv8i8.i64(<vscale x 8 x i8> [[DEST]], <vscale x 8 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_vslideup_vx_u8m1_tum(vbool8_t mask, vuint8m1_t dest, vuint8m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vslideup_vx_u8m2_tum
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i8> [[DEST:%.*]], <vscale x 16 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vslideup.mask.nxv16i8.i64(<vscale x 16 x i8> [[DEST]], <vscale x 16 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_vslideup_vx_u8m2_tum(vbool4_t mask, vuint8m2_t dest, vuint8m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vslideup_vx_u8m4_tum
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i8> [[DEST:%.*]], <vscale x 32 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vslideup.mask.nxv32i8.i64(<vscale x 32 x i8> [[DEST]], <vscale x 32 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_vslideup_vx_u8m4_tum(vbool2_t mask, vuint8m4_t dest, vuint8m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vslideup_vx_u8m8_tum
// CHECK-RV64-SAME: (<vscale x 64 x i1> [[MASK:%.*]], <vscale x 64 x i8> [[DEST:%.*]], <vscale x 64 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vslideup.mask.nxv64i8.i64(<vscale x 64 x i8> [[DEST]], <vscale x 64 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 64 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vslideup_vx_u8m8_tum(vbool1_t mask, vuint8m8_t dest, vuint8m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vslideup_vx_u16mf4_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i16> [[DEST:%.*]], <vscale x 1 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vslideup.mask.nxv1i16.i64(<vscale x 1 x i16> [[DEST]], <vscale x 1 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_vslideup_vx_u16mf4_tum(vbool64_t mask, vuint16mf4_t dest, vuint16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vslideup_vx_u16mf2_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i16> [[DEST:%.*]], <vscale x 2 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vslideup.mask.nxv2i16.i64(<vscale x 2 x i16> [[DEST]], <vscale x 2 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_vslideup_vx_u16mf2_tum(vbool32_t mask, vuint16mf2_t dest, vuint16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vslideup_vx_u16m1_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i16> [[DEST:%.*]], <vscale x 4 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vslideup.mask.nxv4i16.i64(<vscale x 4 x i16> [[DEST]], <vscale x 4 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_vslideup_vx_u16m1_tum(vbool16_t mask, vuint16m1_t dest, vuint16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vslideup_vx_u16m2_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i16> [[DEST:%.*]], <vscale x 8 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vslideup.mask.nxv8i16.i64(<vscale x 8 x i16> [[DEST]], <vscale x 8 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_vslideup_vx_u16m2_tum(vbool8_t mask, vuint16m2_t dest, vuint16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vslideup_vx_u16m4_tum
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i16> [[DEST:%.*]], <vscale x 16 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vslideup.mask.nxv16i16.i64(<vscale x 16 x i16> [[DEST]], <vscale x 16 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_vslideup_vx_u16m4_tum(vbool4_t mask, vuint16m4_t dest, vuint16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vslideup_vx_u16m8_tum
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i16> [[DEST:%.*]], <vscale x 32 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vslideup.mask.nxv32i16.i64(<vscale x 32 x i16> [[DEST]], <vscale x 32 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vslideup_vx_u16m8_tum(vbool2_t mask, vuint16m8_t dest, vuint16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i32> @test_vslideup_vx_u32mf2_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i32> [[DEST:%.*]], <vscale x 1 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.vslideup.mask.nxv1i32.i64(<vscale x 1 x i32> [[DEST]], <vscale x 1 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_vslideup_vx_u32mf2_tum(vbool64_t mask, vuint32mf2_t dest, vuint32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i32> @test_vslideup_vx_u32m1_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i32> [[DEST:%.*]], <vscale x 2 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.vslideup.mask.nxv2i32.i64(<vscale x 2 x i32> [[DEST]], <vscale x 2 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_vslideup_vx_u32m1_tum(vbool32_t mask, vuint32m1_t dest, vuint32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i32> @test_vslideup_vx_u32m2_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i32> [[DEST:%.*]], <vscale x 4 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.vslideup.mask.nxv4i32.i64(<vscale x 4 x i32> [[DEST]], <vscale x 4 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_vslideup_vx_u32m2_tum(vbool16_t mask, vuint32m2_t dest, vuint32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vslideup_vx_u32m4_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i32> [[DEST:%.*]], <vscale x 8 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.vslideup.mask.nxv8i32.i64(<vscale x 8 x i32> [[DEST]], <vscale x 8 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_vslideup_vx_u32m4_tum(vbool8_t mask, vuint32m4_t dest, vuint32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vslideup_vx_u32m8_tum
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i32> [[DEST:%.*]], <vscale x 16 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.vslideup.mask.nxv16i32.i64(<vscale x 16 x i32> [[DEST]], <vscale x 16 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_vslideup_vx_u32m8_tum(vbool4_t mask, vuint32m8_t dest, vuint32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i64> @test_vslideup_vx_u64m1_tum
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i64> [[DEST:%.*]], <vscale x 1 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.vslideup.mask.nxv1i64.i64(<vscale x 1 x i64> [[DEST]], <vscale x 1 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_vslideup_vx_u64m1_tum(vbool64_t mask, vuint64m1_t dest, vuint64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i64> @test_vslideup_vx_u64m2_tum
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i64> [[DEST:%.*]], <vscale x 2 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.vslideup.mask.nxv2i64.i64(<vscale x 2 x i64> [[DEST]], <vscale x 2 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_vslideup_vx_u64m2_tum(vbool32_t mask, vuint64m2_t dest, vuint64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vslideup_vx_u64m4_tum
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i64> [[DEST:%.*]], <vscale x 4 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.vslideup.mask.nxv4i64.i64(<vscale x 4 x i64> [[DEST]], <vscale x 4 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_vslideup_vx_u64m4_tum(vbool16_t mask, vuint64m4_t dest, vuint64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vslideup_vx_u64m8_tum
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i64> [[DEST:%.*]], <vscale x 8 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.vslideup.mask.nxv8i64.i64(<vscale x 8 x i64> [[DEST]], <vscale x 8 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 2)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_vslideup_vx_u64m8_tum(vbool8_t mask, vuint64m8_t dest, vuint64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tum(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x half> @test_vslideup_vx_f16mf4_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x half> [[DEST:%.*]], <vscale x 1 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.vslideup.mask.nxv1f16.i64(<vscale x 1 x half> [[DEST]], <vscale x 1 x half> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_vslideup_vx_f16mf4_tumu(vbool64_t mask, vfloat16mf4_t dest, vfloat16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x half> @test_vslideup_vx_f16mf2_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x half> [[DEST:%.*]], <vscale x 2 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.vslideup.mask.nxv2f16.i64(<vscale x 2 x half> [[DEST]], <vscale x 2 x half> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_vslideup_vx_f16mf2_tumu(vbool32_t mask, vfloat16mf2_t dest, vfloat16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x half> @test_vslideup_vx_f16m1_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x half> [[DEST:%.*]], <vscale x 4 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vslideup.mask.nxv4f16.i64(<vscale x 4 x half> [[DEST]], <vscale x 4 x half> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vslideup_vx_f16m1_tumu(vbool16_t mask, vfloat16m1_t dest, vfloat16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x half> @test_vslideup_vx_f16m2_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x half> [[DEST:%.*]], <vscale x 8 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.vslideup.mask.nxv8f16.i64(<vscale x 8 x half> [[DEST]], <vscale x 8 x half> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_vslideup_vx_f16m2_tumu(vbool8_t mask, vfloat16m2_t dest, vfloat16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x half> @test_vslideup_vx_f16m4_tumu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x half> [[DEST:%.*]], <vscale x 16 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.vslideup.mask.nxv16f16.i64(<vscale x 16 x half> [[DEST]], <vscale x 16 x half> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_vslideup_vx_f16m4_tumu(vbool4_t mask, vfloat16m4_t dest, vfloat16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x half> @test_vslideup_vx_f16m8_tumu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x half> [[DEST:%.*]], <vscale x 32 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.vslideup.mask.nxv32f16.i64(<vscale x 32 x half> [[DEST]], <vscale x 32 x half> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_vslideup_vx_f16m8_tumu(vbool2_t mask, vfloat16m8_t dest, vfloat16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x float> @test_vslideup_vx_f32mf2_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x float> [[DEST:%.*]], <vscale x 1 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x float> @llvm.riscv.vslideup.mask.nxv1f32.i64(<vscale x 1 x float> [[DEST]], <vscale x 1 x float> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x float> [[TMP0]]
//
vfloat32mf2_t test_vslideup_vx_f32mf2_tumu(vbool64_t mask, vfloat32mf2_t dest, vfloat32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x float> @test_vslideup_vx_f32m1_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x float> [[DEST:%.*]], <vscale x 2 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x float> @llvm.riscv.vslideup.mask.nxv2f32.i64(<vscale x 2 x float> [[DEST]], <vscale x 2 x float> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x float> [[TMP0]]
//
vfloat32m1_t test_vslideup_vx_f32m1_tumu(vbool32_t mask, vfloat32m1_t dest, vfloat32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x float> @test_vslideup_vx_f32m2_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x float> [[DEST:%.*]], <vscale x 4 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x float> @llvm.riscv.vslideup.mask.nxv4f32.i64(<vscale x 4 x float> [[DEST]], <vscale x 4 x float> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
vfloat32m2_t test_vslideup_vx_f32m2_tumu(vbool16_t mask, vfloat32m2_t dest, vfloat32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x float> @test_vslideup_vx_f32m4_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x float> [[DEST:%.*]], <vscale x 8 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x float> @llvm.riscv.vslideup.mask.nxv8f32.i64(<vscale x 8 x float> [[DEST]], <vscale x 8 x float> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
vfloat32m4_t test_vslideup_vx_f32m4_tumu(vbool8_t mask, vfloat32m4_t dest, vfloat32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x float> @test_vslideup_vx_f32m8_tumu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x float> [[DEST:%.*]], <vscale x 16 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x float> @llvm.riscv.vslideup.mask.nxv16f32.i64(<vscale x 16 x float> [[DEST]], <vscale x 16 x float> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
vfloat32m8_t test_vslideup_vx_f32m8_tumu(vbool4_t mask, vfloat32m8_t dest, vfloat32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x double> @test_vslideup_vx_f64m1_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x double> [[DEST:%.*]], <vscale x 1 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x double> @llvm.riscv.vslideup.mask.nxv1f64.i64(<vscale x 1 x double> [[DEST]], <vscale x 1 x double> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x double> [[TMP0]]
//
vfloat64m1_t test_vslideup_vx_f64m1_tumu(vbool64_t mask, vfloat64m1_t dest, vfloat64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x double> @test_vslideup_vx_f64m2_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x double> [[DEST:%.*]], <vscale x 2 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x double> @llvm.riscv.vslideup.mask.nxv2f64.i64(<vscale x 2 x double> [[DEST]], <vscale x 2 x double> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
vfloat64m2_t test_vslideup_vx_f64m2_tumu(vbool32_t mask, vfloat64m2_t dest, vfloat64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x double> @test_vslideup_vx_f64m4_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x double> [[DEST:%.*]], <vscale x 4 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x double> @llvm.riscv.vslideup.mask.nxv4f64.i64(<vscale x 4 x double> [[DEST]], <vscale x 4 x double> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
vfloat64m4_t test_vslideup_vx_f64m4_tumu(vbool16_t mask, vfloat64m4_t dest, vfloat64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x double> @test_vslideup_vx_f64m8_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x double> [[DEST:%.*]], <vscale x 8 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x double> @llvm.riscv.vslideup.mask.nxv8f64.i64(<vscale x 8 x double> [[DEST]], <vscale x 8 x double> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
vfloat64m8_t test_vslideup_vx_f64m8_tumu(vbool8_t mask, vfloat64m8_t dest, vfloat64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vslideup_vx_i8mf8_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i8> [[DEST:%.*]], <vscale x 1 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vslideup.mask.nxv1i8.i64(<vscale x 1 x i8> [[DEST]], <vscale x 1 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vint8mf8_t test_vslideup_vx_i8mf8_tumu(vbool64_t mask, vint8mf8_t dest, vint8mf8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vslideup_vx_i8mf4_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i8> [[DEST:%.*]], <vscale x 2 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vslideup.mask.nxv2i8.i64(<vscale x 2 x i8> [[DEST]], <vscale x 2 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vint8mf4_t test_vslideup_vx_i8mf4_tumu(vbool32_t mask, vint8mf4_t dest, vint8mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vslideup_vx_i8mf2_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i8> [[DEST:%.*]], <vscale x 4 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vslideup.mask.nxv4i8.i64(<vscale x 4 x i8> [[DEST]], <vscale x 4 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vint8mf2_t test_vslideup_vx_i8mf2_tumu(vbool16_t mask, vint8mf2_t dest, vint8mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vslideup_vx_i8m1_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i8> [[DEST:%.*]], <vscale x 8 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vslideup.mask.nxv8i8.i64(<vscale x 8 x i8> [[DEST]], <vscale x 8 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vint8m1_t test_vslideup_vx_i8m1_tumu(vbool8_t mask, vint8m1_t dest, vint8m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vslideup_vx_i8m2_tumu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i8> [[DEST:%.*]], <vscale x 16 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vslideup.mask.nxv16i8.i64(<vscale x 16 x i8> [[DEST]], <vscale x 16 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vint8m2_t test_vslideup_vx_i8m2_tumu(vbool4_t mask, vint8m2_t dest, vint8m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vslideup_vx_i8m4_tumu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i8> [[DEST:%.*]], <vscale x 32 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vslideup.mask.nxv32i8.i64(<vscale x 32 x i8> [[DEST]], <vscale x 32 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vint8m4_t test_vslideup_vx_i8m4_tumu(vbool2_t mask, vint8m4_t dest, vint8m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vslideup_vx_i8m8_tumu
// CHECK-RV64-SAME: (<vscale x 64 x i1> [[MASK:%.*]], <vscale x 64 x i8> [[DEST:%.*]], <vscale x 64 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vslideup.mask.nxv64i8.i64(<vscale x 64 x i8> [[DEST]], <vscale x 64 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 64 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vint8m8_t test_vslideup_vx_i8m8_tumu(vbool1_t mask, vint8m8_t dest, vint8m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vslideup_vx_i16mf4_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i16> [[DEST:%.*]], <vscale x 1 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vslideup.mask.nxv1i16.i64(<vscale x 1 x i16> [[DEST]], <vscale x 1 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vint16mf4_t test_vslideup_vx_i16mf4_tumu(vbool64_t mask, vint16mf4_t dest, vint16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vslideup_vx_i16mf2_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i16> [[DEST:%.*]], <vscale x 2 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vslideup.mask.nxv2i16.i64(<vscale x 2 x i16> [[DEST]], <vscale x 2 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vint16mf2_t test_vslideup_vx_i16mf2_tumu(vbool32_t mask, vint16mf2_t dest, vint16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vslideup_vx_i16m1_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i16> [[DEST:%.*]], <vscale x 4 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vslideup.mask.nxv4i16.i64(<vscale x 4 x i16> [[DEST]], <vscale x 4 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vint16m1_t test_vslideup_vx_i16m1_tumu(vbool16_t mask, vint16m1_t dest, vint16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vslideup_vx_i16m2_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i16> [[DEST:%.*]], <vscale x 8 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vslideup.mask.nxv8i16.i64(<vscale x 8 x i16> [[DEST]], <vscale x 8 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vint16m2_t test_vslideup_vx_i16m2_tumu(vbool8_t mask, vint16m2_t dest, vint16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vslideup_vx_i16m4_tumu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i16> [[DEST:%.*]], <vscale x 16 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vslideup.mask.nxv16i16.i64(<vscale x 16 x i16> [[DEST]], <vscale x 16 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vint16m4_t test_vslideup_vx_i16m4_tumu(vbool4_t mask, vint16m4_t dest, vint16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vslideup_vx_i16m8_tumu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i16> [[DEST:%.*]], <vscale x 32 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vslideup.mask.nxv32i16.i64(<vscale x 32 x i16> [[DEST]], <vscale x 32 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vint16m8_t test_vslideup_vx_i16m8_tumu(vbool2_t mask, vint16m8_t dest, vint16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i32> @test_vslideup_vx_i32mf2_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i32> [[DEST:%.*]], <vscale x 1 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.vslideup.mask.nxv1i32.i64(<vscale x 1 x i32> [[DEST]], <vscale x 1 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vint32mf2_t test_vslideup_vx_i32mf2_tumu(vbool64_t mask, vint32mf2_t dest, vint32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i32> @test_vslideup_vx_i32m1_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i32> [[DEST:%.*]], <vscale x 2 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.vslideup.mask.nxv2i32.i64(<vscale x 2 x i32> [[DEST]], <vscale x 2 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vint32m1_t test_vslideup_vx_i32m1_tumu(vbool32_t mask, vint32m1_t dest, vint32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i32> @test_vslideup_vx_i32m2_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i32> [[DEST:%.*]], <vscale x 4 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.vslideup.mask.nxv4i32.i64(<vscale x 4 x i32> [[DEST]], <vscale x 4 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vint32m2_t test_vslideup_vx_i32m2_tumu(vbool16_t mask, vint32m2_t dest, vint32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vslideup_vx_i32m4_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i32> [[DEST:%.*]], <vscale x 8 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.vslideup.mask.nxv8i32.i64(<vscale x 8 x i32> [[DEST]], <vscale x 8 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vint32m4_t test_vslideup_vx_i32m4_tumu(vbool8_t mask, vint32m4_t dest, vint32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vslideup_vx_i32m8_tumu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i32> [[DEST:%.*]], <vscale x 16 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.vslideup.mask.nxv16i32.i64(<vscale x 16 x i32> [[DEST]], <vscale x 16 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vint32m8_t test_vslideup_vx_i32m8_tumu(vbool4_t mask, vint32m8_t dest, vint32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i64> @test_vslideup_vx_i64m1_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i64> [[DEST:%.*]], <vscale x 1 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.vslideup.mask.nxv1i64.i64(<vscale x 1 x i64> [[DEST]], <vscale x 1 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vint64m1_t test_vslideup_vx_i64m1_tumu(vbool64_t mask, vint64m1_t dest, vint64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i64> @test_vslideup_vx_i64m2_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i64> [[DEST:%.*]], <vscale x 2 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.vslideup.mask.nxv2i64.i64(<vscale x 2 x i64> [[DEST]], <vscale x 2 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vint64m2_t test_vslideup_vx_i64m2_tumu(vbool32_t mask, vint64m2_t dest, vint64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vslideup_vx_i64m4_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i64> [[DEST:%.*]], <vscale x 4 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.vslideup.mask.nxv4i64.i64(<vscale x 4 x i64> [[DEST]], <vscale x 4 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vint64m4_t test_vslideup_vx_i64m4_tumu(vbool16_t mask, vint64m4_t dest, vint64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vslideup_vx_i64m8_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i64> [[DEST:%.*]], <vscale x 8 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.vslideup.mask.nxv8i64.i64(<vscale x 8 x i64> [[DEST]], <vscale x 8 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vint64m8_t test_vslideup_vx_i64m8_tumu(vbool8_t mask, vint64m8_t dest, vint64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vslideup_vx_u8mf8_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i8> [[DEST:%.*]], <vscale x 1 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vslideup.mask.nxv1i8.i64(<vscale x 1 x i8> [[DEST]], <vscale x 1 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_vslideup_vx_u8mf8_tumu(vbool64_t mask, vuint8mf8_t dest, vuint8mf8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vslideup_vx_u8mf4_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i8> [[DEST:%.*]], <vscale x 2 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vslideup.mask.nxv2i8.i64(<vscale x 2 x i8> [[DEST]], <vscale x 2 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_vslideup_vx_u8mf4_tumu(vbool32_t mask, vuint8mf4_t dest, vuint8mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vslideup_vx_u8mf2_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i8> [[DEST:%.*]], <vscale x 4 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vslideup.mask.nxv4i8.i64(<vscale x 4 x i8> [[DEST]], <vscale x 4 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_vslideup_vx_u8mf2_tumu(vbool16_t mask, vuint8mf2_t dest, vuint8mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vslideup_vx_u8m1_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i8> [[DEST:%.*]], <vscale x 8 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vslideup.mask.nxv8i8.i64(<vscale x 8 x i8> [[DEST]], <vscale x 8 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_vslideup_vx_u8m1_tumu(vbool8_t mask, vuint8m1_t dest, vuint8m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vslideup_vx_u8m2_tumu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i8> [[DEST:%.*]], <vscale x 16 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vslideup.mask.nxv16i8.i64(<vscale x 16 x i8> [[DEST]], <vscale x 16 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_vslideup_vx_u8m2_tumu(vbool4_t mask, vuint8m2_t dest, vuint8m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vslideup_vx_u8m4_tumu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i8> [[DEST:%.*]], <vscale x 32 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vslideup.mask.nxv32i8.i64(<vscale x 32 x i8> [[DEST]], <vscale x 32 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_vslideup_vx_u8m4_tumu(vbool2_t mask, vuint8m4_t dest, vuint8m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vslideup_vx_u8m8_tumu
// CHECK-RV64-SAME: (<vscale x 64 x i1> [[MASK:%.*]], <vscale x 64 x i8> [[DEST:%.*]], <vscale x 64 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vslideup.mask.nxv64i8.i64(<vscale x 64 x i8> [[DEST]], <vscale x 64 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 64 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vslideup_vx_u8m8_tumu(vbool1_t mask, vuint8m8_t dest, vuint8m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vslideup_vx_u16mf4_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i16> [[DEST:%.*]], <vscale x 1 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vslideup.mask.nxv1i16.i64(<vscale x 1 x i16> [[DEST]], <vscale x 1 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_vslideup_vx_u16mf4_tumu(vbool64_t mask, vuint16mf4_t dest, vuint16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vslideup_vx_u16mf2_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i16> [[DEST:%.*]], <vscale x 2 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vslideup.mask.nxv2i16.i64(<vscale x 2 x i16> [[DEST]], <vscale x 2 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_vslideup_vx_u16mf2_tumu(vbool32_t mask, vuint16mf2_t dest, vuint16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vslideup_vx_u16m1_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i16> [[DEST:%.*]], <vscale x 4 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vslideup.mask.nxv4i16.i64(<vscale x 4 x i16> [[DEST]], <vscale x 4 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_vslideup_vx_u16m1_tumu(vbool16_t mask, vuint16m1_t dest, vuint16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vslideup_vx_u16m2_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i16> [[DEST:%.*]], <vscale x 8 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vslideup.mask.nxv8i16.i64(<vscale x 8 x i16> [[DEST]], <vscale x 8 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_vslideup_vx_u16m2_tumu(vbool8_t mask, vuint16m2_t dest, vuint16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vslideup_vx_u16m4_tumu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i16> [[DEST:%.*]], <vscale x 16 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vslideup.mask.nxv16i16.i64(<vscale x 16 x i16> [[DEST]], <vscale x 16 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_vslideup_vx_u16m4_tumu(vbool4_t mask, vuint16m4_t dest, vuint16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vslideup_vx_u16m8_tumu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i16> [[DEST:%.*]], <vscale x 32 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vslideup.mask.nxv32i16.i64(<vscale x 32 x i16> [[DEST]], <vscale x 32 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vslideup_vx_u16m8_tumu(vbool2_t mask, vuint16m8_t dest, vuint16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i32> @test_vslideup_vx_u32mf2_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i32> [[DEST:%.*]], <vscale x 1 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.vslideup.mask.nxv1i32.i64(<vscale x 1 x i32> [[DEST]], <vscale x 1 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_vslideup_vx_u32mf2_tumu(vbool64_t mask, vuint32mf2_t dest, vuint32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i32> @test_vslideup_vx_u32m1_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i32> [[DEST:%.*]], <vscale x 2 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.vslideup.mask.nxv2i32.i64(<vscale x 2 x i32> [[DEST]], <vscale x 2 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_vslideup_vx_u32m1_tumu(vbool32_t mask, vuint32m1_t dest, vuint32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i32> @test_vslideup_vx_u32m2_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i32> [[DEST:%.*]], <vscale x 4 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.vslideup.mask.nxv4i32.i64(<vscale x 4 x i32> [[DEST]], <vscale x 4 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_vslideup_vx_u32m2_tumu(vbool16_t mask, vuint32m2_t dest, vuint32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vslideup_vx_u32m4_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i32> [[DEST:%.*]], <vscale x 8 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.vslideup.mask.nxv8i32.i64(<vscale x 8 x i32> [[DEST]], <vscale x 8 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_vslideup_vx_u32m4_tumu(vbool8_t mask, vuint32m4_t dest, vuint32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vslideup_vx_u32m8_tumu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i32> [[DEST:%.*]], <vscale x 16 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.vslideup.mask.nxv16i32.i64(<vscale x 16 x i32> [[DEST]], <vscale x 16 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_vslideup_vx_u32m8_tumu(vbool4_t mask, vuint32m8_t dest, vuint32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i64> @test_vslideup_vx_u64m1_tumu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i64> [[DEST:%.*]], <vscale x 1 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.vslideup.mask.nxv1i64.i64(<vscale x 1 x i64> [[DEST]], <vscale x 1 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_vslideup_vx_u64m1_tumu(vbool64_t mask, vuint64m1_t dest, vuint64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i64> @test_vslideup_vx_u64m2_tumu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i64> [[DEST:%.*]], <vscale x 2 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.vslideup.mask.nxv2i64.i64(<vscale x 2 x i64> [[DEST]], <vscale x 2 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_vslideup_vx_u64m2_tumu(vbool32_t mask, vuint64m2_t dest, vuint64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vslideup_vx_u64m4_tumu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i64> [[DEST:%.*]], <vscale x 4 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.vslideup.mask.nxv4i64.i64(<vscale x 4 x i64> [[DEST]], <vscale x 4 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_vslideup_vx_u64m4_tumu(vbool16_t mask, vuint64m4_t dest, vuint64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vslideup_vx_u64m8_tumu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i64> [[DEST:%.*]], <vscale x 8 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.vslideup.mask.nxv8i64.i64(<vscale x 8 x i64> [[DEST]], <vscale x 8 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 0)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_vslideup_vx_u64m8_tumu(vbool8_t mask, vuint64m8_t dest, vuint64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_tumu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x half> @test_vslideup_vx_f16mf4_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x half> [[DEST:%.*]], <vscale x 1 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x half> @llvm.riscv.vslideup.mask.nxv1f16.i64(<vscale x 1 x half> [[DEST]], <vscale x 1 x half> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x half> [[TMP0]]
//
vfloat16mf4_t test_vslideup_vx_f16mf4_mu(vbool64_t mask, vfloat16mf4_t dest, vfloat16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x half> @test_vslideup_vx_f16mf2_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x half> [[DEST:%.*]], <vscale x 2 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x half> @llvm.riscv.vslideup.mask.nxv2f16.i64(<vscale x 2 x half> [[DEST]], <vscale x 2 x half> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x half> [[TMP0]]
//
vfloat16mf2_t test_vslideup_vx_f16mf2_mu(vbool32_t mask, vfloat16mf2_t dest, vfloat16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x half> @test_vslideup_vx_f16m1_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x half> [[DEST:%.*]], <vscale x 4 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x half> @llvm.riscv.vslideup.mask.nxv4f16.i64(<vscale x 4 x half> [[DEST]], <vscale x 4 x half> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x half> [[TMP0]]
//
vfloat16m1_t test_vslideup_vx_f16m1_mu(vbool16_t mask, vfloat16m1_t dest, vfloat16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x half> @test_vslideup_vx_f16m2_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x half> [[DEST:%.*]], <vscale x 8 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x half> @llvm.riscv.vslideup.mask.nxv8f16.i64(<vscale x 8 x half> [[DEST]], <vscale x 8 x half> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x half> [[TMP0]]
//
vfloat16m2_t test_vslideup_vx_f16m2_mu(vbool8_t mask, vfloat16m2_t dest, vfloat16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x half> @test_vslideup_vx_f16m4_mu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x half> [[DEST:%.*]], <vscale x 16 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x half> @llvm.riscv.vslideup.mask.nxv16f16.i64(<vscale x 16 x half> [[DEST]], <vscale x 16 x half> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x half> [[TMP0]]
//
vfloat16m4_t test_vslideup_vx_f16m4_mu(vbool4_t mask, vfloat16m4_t dest, vfloat16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x half> @test_vslideup_vx_f16m8_mu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x half> [[DEST:%.*]], <vscale x 32 x half> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x half> @llvm.riscv.vslideup.mask.nxv32f16.i64(<vscale x 32 x half> [[DEST]], <vscale x 32 x half> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 32 x half> [[TMP0]]
//
vfloat16m8_t test_vslideup_vx_f16m8_mu(vbool2_t mask, vfloat16m8_t dest, vfloat16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x float> @test_vslideup_vx_f32mf2_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x float> [[DEST:%.*]], <vscale x 1 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x float> @llvm.riscv.vslideup.mask.nxv1f32.i64(<vscale x 1 x float> [[DEST]], <vscale x 1 x float> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x float> [[TMP0]]
//
vfloat32mf2_t test_vslideup_vx_f32mf2_mu(vbool64_t mask, vfloat32mf2_t dest, vfloat32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x float> @test_vslideup_vx_f32m1_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x float> [[DEST:%.*]], <vscale x 2 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x float> @llvm.riscv.vslideup.mask.nxv2f32.i64(<vscale x 2 x float> [[DEST]], <vscale x 2 x float> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x float> [[TMP0]]
//
vfloat32m1_t test_vslideup_vx_f32m1_mu(vbool32_t mask, vfloat32m1_t dest, vfloat32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x float> @test_vslideup_vx_f32m2_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x float> [[DEST:%.*]], <vscale x 4 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x float> @llvm.riscv.vslideup.mask.nxv4f32.i64(<vscale x 4 x float> [[DEST]], <vscale x 4 x float> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x float> [[TMP0]]
//
vfloat32m2_t test_vslideup_vx_f32m2_mu(vbool16_t mask, vfloat32m2_t dest, vfloat32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x float> @test_vslideup_vx_f32m4_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x float> [[DEST:%.*]], <vscale x 8 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x float> @llvm.riscv.vslideup.mask.nxv8f32.i64(<vscale x 8 x float> [[DEST]], <vscale x 8 x float> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x float> [[TMP0]]
//
vfloat32m4_t test_vslideup_vx_f32m4_mu(vbool8_t mask, vfloat32m4_t dest, vfloat32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x float> @test_vslideup_vx_f32m8_mu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x float> [[DEST:%.*]], <vscale x 16 x float> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x float> @llvm.riscv.vslideup.mask.nxv16f32.i64(<vscale x 16 x float> [[DEST]], <vscale x 16 x float> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x float> [[TMP0]]
//
vfloat32m8_t test_vslideup_vx_f32m8_mu(vbool4_t mask, vfloat32m8_t dest, vfloat32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x double> @test_vslideup_vx_f64m1_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x double> [[DEST:%.*]], <vscale x 1 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x double> @llvm.riscv.vslideup.mask.nxv1f64.i64(<vscale x 1 x double> [[DEST]], <vscale x 1 x double> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x double> [[TMP0]]
//
vfloat64m1_t test_vslideup_vx_f64m1_mu(vbool64_t mask, vfloat64m1_t dest, vfloat64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x double> @test_vslideup_vx_f64m2_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x double> [[DEST:%.*]], <vscale x 2 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x double> @llvm.riscv.vslideup.mask.nxv2f64.i64(<vscale x 2 x double> [[DEST]], <vscale x 2 x double> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x double> [[TMP0]]
//
vfloat64m2_t test_vslideup_vx_f64m2_mu(vbool32_t mask, vfloat64m2_t dest, vfloat64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x double> @test_vslideup_vx_f64m4_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x double> [[DEST:%.*]], <vscale x 4 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x double> @llvm.riscv.vslideup.mask.nxv4f64.i64(<vscale x 4 x double> [[DEST]], <vscale x 4 x double> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x double> [[TMP0]]
//
vfloat64m4_t test_vslideup_vx_f64m4_mu(vbool16_t mask, vfloat64m4_t dest, vfloat64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x double> @test_vslideup_vx_f64m8_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x double> [[DEST:%.*]], <vscale x 8 x double> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x double> @llvm.riscv.vslideup.mask.nxv8f64.i64(<vscale x 8 x double> [[DEST]], <vscale x 8 x double> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x double> [[TMP0]]
//
vfloat64m8_t test_vslideup_vx_f64m8_mu(vbool8_t mask, vfloat64m8_t dest, vfloat64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vslideup_vx_i8mf8_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i8> [[DEST:%.*]], <vscale x 1 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vslideup.mask.nxv1i8.i64(<vscale x 1 x i8> [[DEST]], <vscale x 1 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vint8mf8_t test_vslideup_vx_i8mf8_mu(vbool64_t mask, vint8mf8_t dest, vint8mf8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vslideup_vx_i8mf4_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i8> [[DEST:%.*]], <vscale x 2 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vslideup.mask.nxv2i8.i64(<vscale x 2 x i8> [[DEST]], <vscale x 2 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vint8mf4_t test_vslideup_vx_i8mf4_mu(vbool32_t mask, vint8mf4_t dest, vint8mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vslideup_vx_i8mf2_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i8> [[DEST:%.*]], <vscale x 4 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vslideup.mask.nxv4i8.i64(<vscale x 4 x i8> [[DEST]], <vscale x 4 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vint8mf2_t test_vslideup_vx_i8mf2_mu(vbool16_t mask, vint8mf2_t dest, vint8mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vslideup_vx_i8m1_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i8> [[DEST:%.*]], <vscale x 8 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vslideup.mask.nxv8i8.i64(<vscale x 8 x i8> [[DEST]], <vscale x 8 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vint8m1_t test_vslideup_vx_i8m1_mu(vbool8_t mask, vint8m1_t dest, vint8m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vslideup_vx_i8m2_mu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i8> [[DEST:%.*]], <vscale x 16 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vslideup.mask.nxv16i8.i64(<vscale x 16 x i8> [[DEST]], <vscale x 16 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vint8m2_t test_vslideup_vx_i8m2_mu(vbool4_t mask, vint8m2_t dest, vint8m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vslideup_vx_i8m4_mu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i8> [[DEST:%.*]], <vscale x 32 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vslideup.mask.nxv32i8.i64(<vscale x 32 x i8> [[DEST]], <vscale x 32 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vint8m4_t test_vslideup_vx_i8m4_mu(vbool2_t mask, vint8m4_t dest, vint8m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vslideup_vx_i8m8_mu
// CHECK-RV64-SAME: (<vscale x 64 x i1> [[MASK:%.*]], <vscale x 64 x i8> [[DEST:%.*]], <vscale x 64 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vslideup.mask.nxv64i8.i64(<vscale x 64 x i8> [[DEST]], <vscale x 64 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 64 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vint8m8_t test_vslideup_vx_i8m8_mu(vbool1_t mask, vint8m8_t dest, vint8m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vslideup_vx_i16mf4_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i16> [[DEST:%.*]], <vscale x 1 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vslideup.mask.nxv1i16.i64(<vscale x 1 x i16> [[DEST]], <vscale x 1 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vint16mf4_t test_vslideup_vx_i16mf4_mu(vbool64_t mask, vint16mf4_t dest, vint16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vslideup_vx_i16mf2_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i16> [[DEST:%.*]], <vscale x 2 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vslideup.mask.nxv2i16.i64(<vscale x 2 x i16> [[DEST]], <vscale x 2 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vint16mf2_t test_vslideup_vx_i16mf2_mu(vbool32_t mask, vint16mf2_t dest, vint16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vslideup_vx_i16m1_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i16> [[DEST:%.*]], <vscale x 4 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vslideup.mask.nxv4i16.i64(<vscale x 4 x i16> [[DEST]], <vscale x 4 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vint16m1_t test_vslideup_vx_i16m1_mu(vbool16_t mask, vint16m1_t dest, vint16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vslideup_vx_i16m2_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i16> [[DEST:%.*]], <vscale x 8 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vslideup.mask.nxv8i16.i64(<vscale x 8 x i16> [[DEST]], <vscale x 8 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vint16m2_t test_vslideup_vx_i16m2_mu(vbool8_t mask, vint16m2_t dest, vint16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vslideup_vx_i16m4_mu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i16> [[DEST:%.*]], <vscale x 16 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vslideup.mask.nxv16i16.i64(<vscale x 16 x i16> [[DEST]], <vscale x 16 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vint16m4_t test_vslideup_vx_i16m4_mu(vbool4_t mask, vint16m4_t dest, vint16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vslideup_vx_i16m8_mu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i16> [[DEST:%.*]], <vscale x 32 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vslideup.mask.nxv32i16.i64(<vscale x 32 x i16> [[DEST]], <vscale x 32 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vint16m8_t test_vslideup_vx_i16m8_mu(vbool2_t mask, vint16m8_t dest, vint16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i32> @test_vslideup_vx_i32mf2_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i32> [[DEST:%.*]], <vscale x 1 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.vslideup.mask.nxv1i32.i64(<vscale x 1 x i32> [[DEST]], <vscale x 1 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vint32mf2_t test_vslideup_vx_i32mf2_mu(vbool64_t mask, vint32mf2_t dest, vint32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i32> @test_vslideup_vx_i32m1_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i32> [[DEST:%.*]], <vscale x 2 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.vslideup.mask.nxv2i32.i64(<vscale x 2 x i32> [[DEST]], <vscale x 2 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vint32m1_t test_vslideup_vx_i32m1_mu(vbool32_t mask, vint32m1_t dest, vint32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i32> @test_vslideup_vx_i32m2_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i32> [[DEST:%.*]], <vscale x 4 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.vslideup.mask.nxv4i32.i64(<vscale x 4 x i32> [[DEST]], <vscale x 4 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vint32m2_t test_vslideup_vx_i32m2_mu(vbool16_t mask, vint32m2_t dest, vint32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vslideup_vx_i32m4_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i32> [[DEST:%.*]], <vscale x 8 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.vslideup.mask.nxv8i32.i64(<vscale x 8 x i32> [[DEST]], <vscale x 8 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vint32m4_t test_vslideup_vx_i32m4_mu(vbool8_t mask, vint32m4_t dest, vint32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vslideup_vx_i32m8_mu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i32> [[DEST:%.*]], <vscale x 16 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.vslideup.mask.nxv16i32.i64(<vscale x 16 x i32> [[DEST]], <vscale x 16 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vint32m8_t test_vslideup_vx_i32m8_mu(vbool4_t mask, vint32m8_t dest, vint32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i64> @test_vslideup_vx_i64m1_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i64> [[DEST:%.*]], <vscale x 1 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.vslideup.mask.nxv1i64.i64(<vscale x 1 x i64> [[DEST]], <vscale x 1 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vint64m1_t test_vslideup_vx_i64m1_mu(vbool64_t mask, vint64m1_t dest, vint64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i64> @test_vslideup_vx_i64m2_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i64> [[DEST:%.*]], <vscale x 2 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.vslideup.mask.nxv2i64.i64(<vscale x 2 x i64> [[DEST]], <vscale x 2 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vint64m2_t test_vslideup_vx_i64m2_mu(vbool32_t mask, vint64m2_t dest, vint64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vslideup_vx_i64m4_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i64> [[DEST:%.*]], <vscale x 4 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.vslideup.mask.nxv4i64.i64(<vscale x 4 x i64> [[DEST]], <vscale x 4 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vint64m4_t test_vslideup_vx_i64m4_mu(vbool16_t mask, vint64m4_t dest, vint64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vslideup_vx_i64m8_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i64> [[DEST:%.*]], <vscale x 8 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.vslideup.mask.nxv8i64.i64(<vscale x 8 x i64> [[DEST]], <vscale x 8 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vint64m8_t test_vslideup_vx_i64m8_mu(vbool8_t mask, vint64m8_t dest, vint64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i8> @test_vslideup_vx_u8mf8_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i8> [[DEST:%.*]], <vscale x 1 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.vslideup.mask.nxv1i8.i64(<vscale x 1 x i8> [[DEST]], <vscale x 1 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_vslideup_vx_u8mf8_mu(vbool64_t mask, vuint8mf8_t dest, vuint8mf8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i8> @test_vslideup_vx_u8mf4_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i8> [[DEST:%.*]], <vscale x 2 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.vslideup.mask.nxv2i8.i64(<vscale x 2 x i8> [[DEST]], <vscale x 2 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_vslideup_vx_u8mf4_mu(vbool32_t mask, vuint8mf4_t dest, vuint8mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i8> @test_vslideup_vx_u8mf2_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i8> [[DEST:%.*]], <vscale x 4 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.vslideup.mask.nxv4i8.i64(<vscale x 4 x i8> [[DEST]], <vscale x 4 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_vslideup_vx_u8mf2_mu(vbool16_t mask, vuint8mf2_t dest, vuint8mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i8> @test_vslideup_vx_u8m1_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i8> [[DEST:%.*]], <vscale x 8 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.vslideup.mask.nxv8i8.i64(<vscale x 8 x i8> [[DEST]], <vscale x 8 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_vslideup_vx_u8m1_mu(vbool8_t mask, vuint8m1_t dest, vuint8m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i8> @test_vslideup_vx_u8m2_mu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i8> [[DEST:%.*]], <vscale x 16 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.vslideup.mask.nxv16i8.i64(<vscale x 16 x i8> [[DEST]], <vscale x 16 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_vslideup_vx_u8m2_mu(vbool4_t mask, vuint8m2_t dest, vuint8m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i8> @test_vslideup_vx_u8m4_mu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i8> [[DEST:%.*]], <vscale x 32 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.vslideup.mask.nxv32i8.i64(<vscale x 32 x i8> [[DEST]], <vscale x 32 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_vslideup_vx_u8m4_mu(vbool2_t mask, vuint8m4_t dest, vuint8m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 64 x i8> @test_vslideup_vx_u8m8_mu
// CHECK-RV64-SAME: (<vscale x 64 x i1> [[MASK:%.*]], <vscale x 64 x i8> [[DEST:%.*]], <vscale x 64 x i8> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.vslideup.mask.nxv64i8.i64(<vscale x 64 x i8> [[DEST]], <vscale x 64 x i8> [[SRC]], i64 [[OFFSET]], <vscale x 64 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_vslideup_vx_u8m8_mu(vbool1_t mask, vuint8m8_t dest, vuint8m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i16> @test_vslideup_vx_u16mf4_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i16> [[DEST:%.*]], <vscale x 1 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.vslideup.mask.nxv1i16.i64(<vscale x 1 x i16> [[DEST]], <vscale x 1 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_vslideup_vx_u16mf4_mu(vbool64_t mask, vuint16mf4_t dest, vuint16mf4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i16> @test_vslideup_vx_u16mf2_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i16> [[DEST:%.*]], <vscale x 2 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.vslideup.mask.nxv2i16.i64(<vscale x 2 x i16> [[DEST]], <vscale x 2 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_vslideup_vx_u16mf2_mu(vbool32_t mask, vuint16mf2_t dest, vuint16mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i16> @test_vslideup_vx_u16m1_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i16> [[DEST:%.*]], <vscale x 4 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.vslideup.mask.nxv4i16.i64(<vscale x 4 x i16> [[DEST]], <vscale x 4 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_vslideup_vx_u16m1_mu(vbool16_t mask, vuint16m1_t dest, vuint16m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i16> @test_vslideup_vx_u16m2_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i16> [[DEST:%.*]], <vscale x 8 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.vslideup.mask.nxv8i16.i64(<vscale x 8 x i16> [[DEST]], <vscale x 8 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_vslideup_vx_u16m2_mu(vbool8_t mask, vuint16m2_t dest, vuint16m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i16> @test_vslideup_vx_u16m4_mu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i16> [[DEST:%.*]], <vscale x 16 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.vslideup.mask.nxv16i16.i64(<vscale x 16 x i16> [[DEST]], <vscale x 16 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_vslideup_vx_u16m4_mu(vbool4_t mask, vuint16m4_t dest, vuint16m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 32 x i16> @test_vslideup_vx_u16m8_mu
// CHECK-RV64-SAME: (<vscale x 32 x i1> [[MASK:%.*]], <vscale x 32 x i16> [[DEST:%.*]], <vscale x 32 x i16> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.vslideup.mask.nxv32i16.i64(<vscale x 32 x i16> [[DEST]], <vscale x 32 x i16> [[SRC]], i64 [[OFFSET]], <vscale x 32 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_vslideup_vx_u16m8_mu(vbool2_t mask, vuint16m8_t dest, vuint16m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i32> @test_vslideup_vx_u32mf2_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i32> [[DEST:%.*]], <vscale x 1 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.vslideup.mask.nxv1i32.i64(<vscale x 1 x i32> [[DEST]], <vscale x 1 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_vslideup_vx_u32mf2_mu(vbool64_t mask, vuint32mf2_t dest, vuint32mf2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i32> @test_vslideup_vx_u32m1_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i32> [[DEST:%.*]], <vscale x 2 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.vslideup.mask.nxv2i32.i64(<vscale x 2 x i32> [[DEST]], <vscale x 2 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_vslideup_vx_u32m1_mu(vbool32_t mask, vuint32m1_t dest, vuint32m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i32> @test_vslideup_vx_u32m2_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i32> [[DEST:%.*]], <vscale x 4 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.vslideup.mask.nxv4i32.i64(<vscale x 4 x i32> [[DEST]], <vscale x 4 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_vslideup_vx_u32m2_mu(vbool16_t mask, vuint32m2_t dest, vuint32m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i32> @test_vslideup_vx_u32m4_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i32> [[DEST:%.*]], <vscale x 8 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.vslideup.mask.nxv8i32.i64(<vscale x 8 x i32> [[DEST]], <vscale x 8 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_vslideup_vx_u32m4_mu(vbool8_t mask, vuint32m4_t dest, vuint32m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 16 x i32> @test_vslideup_vx_u32m8_mu
// CHECK-RV64-SAME: (<vscale x 16 x i1> [[MASK:%.*]], <vscale x 16 x i32> [[DEST:%.*]], <vscale x 16 x i32> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.vslideup.mask.nxv16i32.i64(<vscale x 16 x i32> [[DEST]], <vscale x 16 x i32> [[SRC]], i64 [[OFFSET]], <vscale x 16 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_vslideup_vx_u32m8_mu(vbool4_t mask, vuint32m8_t dest, vuint32m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 1 x i64> @test_vslideup_vx_u64m1_mu
// CHECK-RV64-SAME: (<vscale x 1 x i1> [[MASK:%.*]], <vscale x 1 x i64> [[DEST:%.*]], <vscale x 1 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.vslideup.mask.nxv1i64.i64(<vscale x 1 x i64> [[DEST]], <vscale x 1 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 1 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_vslideup_vx_u64m1_mu(vbool64_t mask, vuint64m1_t dest, vuint64m1_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 2 x i64> @test_vslideup_vx_u64m2_mu
// CHECK-RV64-SAME: (<vscale x 2 x i1> [[MASK:%.*]], <vscale x 2 x i64> [[DEST:%.*]], <vscale x 2 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.vslideup.mask.nxv2i64.i64(<vscale x 2 x i64> [[DEST]], <vscale x 2 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 2 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_vslideup_vx_u64m2_mu(vbool32_t mask, vuint64m2_t dest, vuint64m2_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 4 x i64> @test_vslideup_vx_u64m4_mu
// CHECK-RV64-SAME: (<vscale x 4 x i1> [[MASK:%.*]], <vscale x 4 x i64> [[DEST:%.*]], <vscale x 4 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.vslideup.mask.nxv4i64.i64(<vscale x 4 x i64> [[DEST]], <vscale x 4 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 4 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_vslideup_vx_u64m4_mu(vbool16_t mask, vuint64m4_t dest, vuint64m4_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

// CHECK-RV64-LABEL: define dso_local <vscale x 8 x i64> @test_vslideup_vx_u64m8_mu
// CHECK-RV64-SAME: (<vscale x 8 x i1> [[MASK:%.*]], <vscale x 8 x i64> [[DEST:%.*]], <vscale x 8 x i64> [[SRC:%.*]], i64 noundef [[OFFSET:%.*]], i64 noundef [[VL:%.*]]) #[[ATTR0]] {
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.vslideup.mask.nxv8i64.i64(<vscale x 8 x i64> [[DEST]], <vscale x 8 x i64> [[SRC]], i64 [[OFFSET]], <vscale x 8 x i1> [[MASK]], i64 [[VL]], i64 1)
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_vslideup_vx_u64m8_mu(vbool8_t mask, vuint64m8_t dest, vuint64m8_t src, size_t offset, size_t vl) {
  return __riscv_vslideup_mu(mask, dest, src, offset, vl);
}

