import React from 'react';
import PropTypes from 'prop-types';

const UilVkAlt = (props) => {
  const { color, size, ...otherProps } = props
  return React.createElement('svg', {
    xmlns: 'http://www.w3.org/2000/svg',
    width: size,
    height: size,
    viewBox: '0 0 24 24',
    fill: color,
    ...otherProps
  }, React.createElement('path', {
    d: 'M15.74365,13.5293a5.5186,5.5186,0,0,0-.97741-.83612A7.87286,7.87286,0,0,0,17.625,8.22168a1,1,0,1,0-1.9502-.44336,5.86,5.86,0,0,1-3.0205,3.90228V8.002a.95817.95817,0,0,0-.0437-.21643,1.0238,1.0238,0,0,0-.03449-.17083.991.991,0,0,0-.16681-.24891c-.01788-.02124-.02691-.04925-.04645-.0689a1.00121,1.00121,0,0,0-.24609-.16706c-.02551-.01361-.04449-.03662-.07129-.048a1.01943,1.01943,0,0,0-.23645-.04865.94528.94528,0,0,0-.15179-.03119L11.00293,7H11a.99525.99525,0,0,0-.3501,1.92865v4.89069A11.307,11.307,0,0,1,7.64014,7.835a.99988.99988,0,1,0-1.97168.334,13.33371,13.33371,0,0,0,5.3999,8.64355.986.986,0,0,0,.12781.06445.94.94,0,0,0,.10748.0542.99383.99383,0,0,0,.35065.0708.98307.98307,0,0,0,.42382-.10186c.00995-.0047.02137-.00251.03126-.00751a.99262.99262,0,0,0,.24011-.17529c.01422-.01386.02374-.03089.03717-.04554a.98836.98836,0,0,0,.15991-.23718c.01392-.02869.02661-.05609.03778-.08624a.9878.9878,0,0,0,.06995-.34638l.00049-2.126a3.55144,3.55144,0,0,1,1.61474,1.00488l1.64795,1.79687a.99979.99979,0,1,0,1.47363-1.35156ZM15.07275,1H8.9375C2.78027,1,1,2.77832,1,8.92676V15.0625C1,21.21973,2.77783,23,8.92725,23H15.0625C21.21973,23,23,21.22168,23,15.07324V8.9375C23,2.78027,21.22217,1,15.07275,1ZM21,15.07324C21,20.11328,20.1123,21,15.0625,21H8.92725C3.88623,21,3,20.1123,3,15.0625V8.92676C3,3.88672,3.8877,3,8.9375,3h6.13525C20.11377,3,21,3.8877,21,8.9375Z'
  }));
};

UilVkAlt.propTypes = {
  color: PropTypes.string,
  size: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),
};

UilVkAlt.defaultProps = {
  color: 'currentColor',
  size: '24',
};

export default UilVkAlt;