import * as webpack from 'webpack';
import { EditorLanguage } from './languages';
import { EditorFeature, NegatedEditorFeature } from './features';
interface IMonacoEditorWebpackPluginOpts {
    /**
     * Include only a subset of the languages supported.
     */
    languages?: EditorLanguage[];
    /**
     * Include only a subset of the editor features.
     * Use e.g. '!contextmenu' to exclude a certain feature.
     */
    features?: (EditorFeature | NegatedEditorFeature)[];
    /**
     * Specify a filename template to use for generated files.
     * Use e.g. '[name].worker.[contenthash].js' to include content-based hashes.
     */
    filename?: string;
    /**
     * Override the public path from which files generated by this plugin will be served.
     * This wins out over Webpack's dynamic runtime path and can be useful to avoid attempting to load workers cross-
     * origin when using a CDN for other static resources.
     * Use e.g. '/' if you want to load your resources from the current origin.
     */
    publicPath?: string;
}
declare class MonacoEditorWebpackPlugin implements webpack.Plugin {
    private readonly options;
    constructor(options?: IMonacoEditorWebpackPluginOpts);
    apply(compiler: webpack.Compiler): void;
}
export = MonacoEditorWebpackPlugin;
