/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.common;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ShareableEnv
implements Cloneable {
    private static final Object REMOVED_PROPERTY = new Object();
    protected Hashtable<Object, Object> m_privateEnv;
    protected Vector<Hashtable<Object, Object>> m_sharedEnv;
    protected ShareableEnv m_parentEnv;
    protected int m_parentSharedEnvIdx = -1;

    private ShareableEnv() {
    }

    public ShareableEnv(ShareableEnv parent, int parentSharedEnvIdx) {
        this.m_parentEnv = parent;
        this.m_parentSharedEnvIdx = parentSharedEnvIdx;
    }

    public ShareableEnv(Hashtable<Object, Object> initialEnv) {
        this.m_privateEnv = initialEnv;
    }

    public Object setProperty(String prop, Object val) {
        Object oldVal = this.getProperty(prop);
        if (this.m_privateEnv == null) {
            this.m_privateEnv = new Hashtable(5);
        }
        this.m_privateEnv.put(prop, val);
        return oldVal;
    }

    public Object getProperty(String prop) {
        Object val;
        if (this.m_privateEnv != null && (val = this.m_privateEnv.get(prop)) != null) {
            return val == REMOVED_PROPERTY ? null : val;
        }
        if (this.m_sharedEnv != null) {
            return this.getSharedProperty(this.m_sharedEnv.size() - 1, prop);
        }
        return this.getSharedProperty(-1, prop);
    }

    private Object getSharedProperty(int envIdx, String prop) {
        if (envIdx >= 0) {
            for (int i = envIdx; i >= 0; --i) {
                Hashtable<Object, Object> tab = this.m_sharedEnv.elementAt(i);
                Object val = tab.get(prop);
                if (val == null) continue;
                return val == REMOVED_PROPERTY ? null : val;
            }
        }
        if (this.m_parentSharedEnvIdx >= 0) {
            return this.m_parentEnv.getSharedProperty(this.m_parentSharedEnvIdx, prop);
        }
        return null;
    }

    public Object removeProperty(String prop) {
        Object val = null;
        val = this.m_sharedEnv != null ? this.getSharedProperty(this.m_sharedEnv.size() - 1, prop) : this.getSharedProperty(-1, prop);
        if (val == null) {
            if (this.m_privateEnv != null) {
                return this.m_privateEnv.remove(prop);
            }
        } else {
            this.setProperty(prop, REMOVED_PROPERTY);
        }
        return val;
    }

    public Hashtable<Object, Object> getAllProperties() {
        Hashtable<Object, Object> res = null;
        res = this.m_sharedEnv != null ? this.getAllSharedProperties(this.m_sharedEnv.size() - 1) : this.getAllSharedProperties(-1);
        if (res == null) {
            res = new Hashtable(51);
        }
        if (this.m_privateEnv != null) {
            Hashtable<Object, Object> tab = this.m_privateEnv;
            Enumeration<Object> e = tab.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object val = tab.get(key);
                if (val != REMOVED_PROPERTY) {
                    res.put(key, val);
                    continue;
                }
                res.remove(key);
            }
        }
        return res;
    }

    private Hashtable<Object, Object> getAllSharedProperties(int envIdx) {
        Hashtable<Object, Object> res = null;
        if (this.m_parentEnv != null) {
            res = this.m_parentEnv.getAllSharedProperties(this.m_parentSharedEnvIdx);
        }
        if (res == null) {
            res = new Hashtable(51);
        }
        if (envIdx >= 0) {
            for (int i = 0; i <= envIdx; ++i) {
                Hashtable<Object, Object> tab = this.m_sharedEnv.elementAt(i);
                Enumeration<Object> e = tab.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    Object val = tab.get(key);
                    if (val != REMOVED_PROPERTY) {
                        res.put(key, val);
                        continue;
                    }
                    res.remove(key);
                }
            }
        }
        return res;
    }

    protected void freezeUpdates() {
        if (this.m_privateEnv != null) {
            if (this.m_sharedEnv == null) {
                this.m_sharedEnv = new Vector();
            }
            this.m_sharedEnv.addElement(this.m_privateEnv);
            this.m_privateEnv = null;
        }
    }

    public Object clone() {
        this.freezeUpdates();
        if (this.m_sharedEnv != null) {
            return new ShareableEnv(this, this.m_sharedEnv.size() - 1);
        }
        return new ShareableEnv(this.m_parentEnv, this.m_parentSharedEnvIdx);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ShareableEnv private=");
        if (this.m_privateEnv != null) {
            buf.append("(");
            buf.append(this.m_privateEnv.size());
            buf.append(")");
        }
        buf.append(" shared=");
        if (this.m_sharedEnv != null) {
            for (int i = 0; i < this.m_sharedEnv.size(); ++i) {
                Hashtable<Object, Object> tab = this.m_sharedEnv.elementAt(i);
                buf.append("(");
                buf.append(tab.size());
                buf.append(")");
            }
        }
        buf.append(" parentIdx=");
        buf.append(this.m_parentSharedEnvIdx);
        return buf.toString();
    }

    public static void main(String[] args) {
        ShareableEnv c0 = new ShareableEnv(null, -1);
        System.err.println("c0.getProperty(p1)=" + c0.getProperty("p1"));
        System.err.println("c0.getAllProperties()=" + c0.getAllProperties());
        System.err.println("c0.setProperty(p1,vxxx)=" + c0.setProperty("p1", "vxxx"));
        System.err.println("c0.setProperty(p2,v2)=" + c0.setProperty("p2", "v2"));
        System.err.println("c0.setProperty(p3,v3)=" + c0.setProperty("p3", "v3"));
        System.err.println("c0.setProperty(p1,v1)=" + c0.setProperty("p1", "v1"));
        System.err.println("c0.getAllProperties()=" + c0.getAllProperties());
        System.err.println("---");
        ShareableEnv c01 = (ShareableEnv)c0.clone();
        System.err.println("c01.getProperty(p1)=" + c01.getProperty("p1"));
        System.err.println("c01.getAllProperties()=" + c01.getAllProperties());
        System.err.println("c01.setProperty(p1,v1a)=" + c01.setProperty("p1", "v1a"));
        System.err.println("c01.getProperty(p1)=" + c01.getProperty("p1"));
        System.err.println("c01.removeProperty(p2)=" + c01.removeProperty("p2"));
        System.err.println("c01.getProperty(p2)=" + c01.getProperty("p2"));
        System.err.println("c01.setProperty(p11,v11a)=" + c01.setProperty("p11", "v11a"));
        System.err.println("c01.getAllProperties()=" + c01.getAllProperties());
        System.err.println("---");
        ShareableEnv c02 = (ShareableEnv)c0.clone();
        System.err.println("c02.getProperty(p1)=" + c02.getProperty("p1"));
        System.err.println("c02.getAllProperties()=" + c02.getAllProperties());
        System.err.println("---");
        ShareableEnv c011 = (ShareableEnv)c01.clone();
        System.err.println("c011.getProperty(p1)=" + c011.getProperty("p1"));
        System.err.println("c011.getAllProperties()=" + c011.getAllProperties());
        System.err.println("c011.setProperty(p1,v11b)=" + c011.setProperty("p1", "v11b"));
        System.err.println("c011.getProperty(p1)=" + c011.getProperty("p1"));
        System.err.println("c011.getAllProperties()=" + c011.getAllProperties());
        System.err.println("---");
        System.err.println("c01.getAllProperties()=" + c01.getAllProperties());
        System.err.println("c01.removeProperty(p11)=" + c01.removeProperty("p11"));
        System.err.println("c01.getAllProperties()=" + c01.getAllProperties());
        System.err.println("c011.getAllProperties()=" + c011.getAllProperties());
        System.err.println("---");
        ShareableEnv c012 = (ShareableEnv)c01.clone();
        System.err.println("c012.getAllProperties()=" + c012.getAllProperties());
        System.err.println("c012.getProperty(p1)=" + c012.getProperty("p1"));
        System.err.println("---");
        System.err.println("c0=" + c0);
        System.err.println("c01=" + c01);
        System.err.println("c02=" + c02);
        System.err.println("c011=" + c011);
        System.err.println("c012=" + c012);
    }
}

