; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: opt < %s -passes=instcombine -mtriple=x86_64-unknown-unknown -S | llc -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s

;; This is just a simple test to make sure there are no regressions
;; cause by splitting/recombining ternlog intrinsics.

declare <4 x i64> @use_merge_4xi64(<4 x i64>, <4 x i64>)

declare <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32>, <4 x i32>, <4 x i32>, i32 immarg)
declare <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64>, <4 x i64>, <4 x i64>, i32 immarg)
declare <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64>, <8 x i64>, <8 x i64>, i32 immarg)
declare <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64>, <2 x i64>, <2 x i64>, i32 immarg)
declare <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32>, <16 x i32>, <16 x i32>, i32 immarg)
declare <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32>, <8 x i32>, <8 x i32>, i32 immarg)

define <16 x i32> @vpternlog_d_v512_imm0(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 0)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm1(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $1, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 1)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm2(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $2, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 2)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm3(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $3, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 3)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm4(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $4, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 4)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm5(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $5, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 5)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm6(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $6, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 6)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm7(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $7, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 7)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm8(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $8, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 8)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm9(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $9, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 9)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm10(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $10, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 10)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm11(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $11, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 11)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm12(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $12, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 12)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm13(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm13:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $13, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 13)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm14(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm14:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $14, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 14)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm15(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm15:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $51, %zmm0, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 15)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm16(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $16, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 16)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm17(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm17:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $17, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 17)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm18(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm18:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $18, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 18)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm19(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm19:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $19, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 19)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm20(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm20:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $20, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 20)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm21(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm21:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $21, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 21)
  ret <8 x i64> %r
}

;; This is one_bit_set pattern
define <4 x i32> @vpternlog_d_v128_imm22(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm22:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $22, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 22)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm23(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm23:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $23, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 23)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm24(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $24, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 24)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm25(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm25:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $25, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 25)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm26(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm26:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $26, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 26)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm27(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm27:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $27, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 27)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm28(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm28:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $28, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 28)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm29(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm29:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $29, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 29)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm30(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm30:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $30, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 30)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm31(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm31:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $31, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 31)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm32(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $32, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 32)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm33(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm33:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $33, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 33)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm34(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm34:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $34, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 34)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm35(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm35:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $35, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 35)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm36(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm36:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $36, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 36)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm37(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm37:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $37, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 37)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm38(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm38:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $38, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 38)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm39(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm39:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $39, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 39)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm40(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm40:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $40, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 40)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm41(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm41:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $41, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 41)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm42(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm42:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $42, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 42)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm43(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm43:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $43, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 43)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm44(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm44:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $44, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 44)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm45(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm45:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $45, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 45)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm46(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm46:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $46, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 46)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm47(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm47:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $47, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 47)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm48(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm48:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $48, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 48)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm49(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm49:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $49, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 49)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm50(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm50:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $50, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 50)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm51(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm51:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovdqa64 %zmm1, %zmm0
; CHECK-NEXT:    vpternlogq $15, %zmm1, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 51)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm52(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm52:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $52, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 52)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm53(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm53:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $53, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 53)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm54(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm54:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $54, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 54)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm55(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm55:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $55, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 55)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm56(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm56:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $56, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 56)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm57(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm57:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $57, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 57)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm58(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm58:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $58, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 58)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm59(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm59:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $59, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 59)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm60(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm60:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpxord %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 60)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm61(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm61:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $61, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 61)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm62(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm62:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $62, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 62)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm63(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm63:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $63, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 63)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm64(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $64, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 64)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm65(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm65:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $65, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 65)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm66(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm66:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $66, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 66)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm67(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm67:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $67, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 67)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm68(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm68:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $68, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 68)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm69(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm69:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $69, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 69)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm70(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm70:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $70, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 70)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm71(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm71:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $71, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 71)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm72(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm72:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $72, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 72)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm73(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm73:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $73, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 73)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm74(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm74:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $74, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 74)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm75(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm75:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $75, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 75)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm76(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm76:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $76, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 76)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm77(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm77:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $77, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 77)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm78(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm78:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $78, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 78)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm79(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm79:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $79, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 79)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm80(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm80:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $80, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 80)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm81(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm81:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $81, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 81)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm82(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm82:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $82, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 82)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm83(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm83:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $83, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 83)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm84(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm84:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $84, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 84)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm85(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm85:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovdqa %xmm2, %xmm0
; CHECK-NEXT:    vpternlogq $15, %xmm2, %xmm2, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 85)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm86(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm86:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $86, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 86)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm87(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm87:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $87, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 87)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm88(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm88:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $88, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 88)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm89(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm89:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $89, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 89)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm90(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm90:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpxord %zmm2, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 90)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm91(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm91:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $91, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 91)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm92(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm92:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $92, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 92)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm93(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm93:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $93, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 93)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm94(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm94:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $94, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 94)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm95(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm95:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $95, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 95)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm96(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm96:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $96, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 96)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm97(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm97:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $97, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 97)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm98(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm98:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $98, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 98)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm99(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm99:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $99, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 99)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm100(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm100:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $100, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 100)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm101(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm101:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $101, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 101)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm102(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm102:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpxord %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 102)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm103(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm103:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $103, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 103)
  ret <2 x i64> %r
}

; This is two_bits_set pattern
define <8 x i32> @vpternlog_d_v256_imm104(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm104:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $104, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 104)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm105(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm105:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $105, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 105)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm106(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm106:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $106, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 106)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm107(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm107:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $107, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 107)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm108(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm108:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $108, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 108)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm109(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm109:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $109, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 109)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm110(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm110:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $110, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 110)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm111(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm111:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $111, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 111)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm112(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm112:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $112, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 112)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm113(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm113:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $113, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 113)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm114(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm114:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $114, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 114)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm115(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm115:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $115, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 115)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm116(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm116:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $116, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 116)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm117(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm117:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $117, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 117)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm118(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm118:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $118, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 118)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm119(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm119:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $119, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 119)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm120(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm120:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $120, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 120)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm121(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm121:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $121, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 121)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm122(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm122:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $122, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 122)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm123(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm123:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $123, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 123)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm124(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm124:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $124, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 124)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm125(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm125:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $125, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 125)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm126(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm126:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $126, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 126)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm127(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm127:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $127, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 127)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm128(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $128, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 128)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm129(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm129:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $129, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 129)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm130(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm130:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $130, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 130)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm131(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm131:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $131, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 131)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm132(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm132:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $132, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 132)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm133(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm133:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $133, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 133)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm134(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm134:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $134, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 134)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm135(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm135:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $135, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 135)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm136(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm136:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vandps %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 136)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm137(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm137:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $137, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 137)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm138(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm138:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $138, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 138)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm139(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm139:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $139, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 139)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm140(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm140:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $140, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 140)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm141(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm141:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $141, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 141)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm142(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm142:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $142, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 142)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm143(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm143:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $143, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 143)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm144(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm144:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $144, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 144)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm145(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm145:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $145, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 145)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm146(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm146:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $146, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 146)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm147(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm147:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $147, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 147)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm148(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm148:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $148, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 148)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm149(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm149:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $149, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 149)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm150(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm150:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $150, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 150)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm151(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm151:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $151, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 151)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm152(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm152:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $152, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 152)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm153(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm153:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $153, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 153)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm154(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm154:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $154, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 154)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm155(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm155:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $155, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 155)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm156(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm156:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $156, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 156)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm157(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm157:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $157, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 157)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm158(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm158:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $158, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 158)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm159(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm159:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $159, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 159)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm160(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm160:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vandps %xmm2, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 160)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm161(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm161:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $161, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 161)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm162(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm162:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $162, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 162)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm163(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm163:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $163, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 163)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm164(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm164:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $164, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 164)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm165(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm165:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $165, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 165)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm166(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm166:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $166, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 166)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm167(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm167:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $167, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 167)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm168(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm168:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $168, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 168)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm169(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm169:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $169, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 169)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm170(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm170:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %ymm2, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 170)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm171(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm171:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $171, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 171)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm172(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm172:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $172, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 172)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm173(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm173:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $173, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 173)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm174(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm174:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $174, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 174)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm175(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm175:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $175, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 175)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm176(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm176:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $176, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 176)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm177(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm177:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $177, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 177)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm178(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm178:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $178, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 178)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm179(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm179:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $179, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 179)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm180(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm180:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $180, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 180)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm181(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm181:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $181, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 181)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm182(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm182:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $182, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 182)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm183(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm183:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $183, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 183)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm184(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm184:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $184, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 184)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm185(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm185:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $185, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 185)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm186(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm186:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $186, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 186)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm187(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm187:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $187, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 187)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm188(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm188:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $188, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 188)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm189(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm189:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $189, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 189)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm190(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm190:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $190, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 190)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm191(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm191:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $191, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 191)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm192(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm192:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpandd %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 192)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm193(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm193:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $193, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 193)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm194(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm194:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $194, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 194)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm195(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm195:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $195, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 195)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm196(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm196:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $196, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 196)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm197(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm197:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $197, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 197)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm198(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm198:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $198, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 198)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm199(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm199:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $199, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 199)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm200(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm200:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $200, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 200)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm201(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm201:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $201, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 201)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm202(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm202:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $202, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 202)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm203(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm203:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $203, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 203)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm204(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm204:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovaps %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 204)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm205(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm205:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $205, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 205)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm206(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm206:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $206, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 206)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm207(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm207:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $207, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 207)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm208(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm208:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $208, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 208)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm209(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm209:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $209, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 209)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm210(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm210:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $210, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 210)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm211(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm211:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $211, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 211)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm212(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm212:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $212, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 212)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm213(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm213:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $213, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 213)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm214(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm214:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $214, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 214)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm215(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm215:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $215, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 215)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm216(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm216:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $216, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 216)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm217(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm217:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $217, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 217)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm218(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm218:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $218, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 218)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm219(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm219:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $219, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 219)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm220(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm220:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $220, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 220)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm221(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm221:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $221, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 221)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm222(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm222:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $222, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 222)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm223(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm223:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $223, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 223)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm224(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm224:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $224, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 224)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm225(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm225:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $225, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 225)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm226(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm226:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $226, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 226)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm227(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm227:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $227, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 227)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm228(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm228:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $228, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 228)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm229(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm229:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $229, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 229)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm230(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm230:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $230, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 230)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm231(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm231:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $231, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 231)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm232(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm232:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $232, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 232)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm233(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm233:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $233, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 233)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm234(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm234:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $234, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 234)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm235(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm235:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $235, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 235)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm236(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm236:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $236, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 236)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm237(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm237:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $237, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 237)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm238(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm238:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vorps %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 238)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm239(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm239:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $239, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 239)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm240(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm240:
; CHECK:       # %bb.0:
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 240)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm241(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm241:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $241, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 241)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm242(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm242:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $242, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 242)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm243(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm243:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $243, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 243)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm244(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm244:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $244, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 244)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm245(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm245:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $245, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 245)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm246(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm246:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $246, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 246)
  ret <16 x i32> %r
}

define <2 x i64> @vpternlog_q_v128_imm247(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm247:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $247, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 247)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm248(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm248:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $248, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 248)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm249(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm249:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $249, %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 249)
  ret <8 x i64> %r
}

define <4 x i32> @vpternlog_d_v128_imm250(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v128_imm250:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vorps %xmm2, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i32> @llvm.x86.avx512.pternlog.d.128(<4 x i32> %v0, <4 x i32> %v1, <4 x i32> %v2, i32 250)
  ret <4 x i32> %r
}

define <4 x i64> @vpternlog_q_v256_imm251(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v256_imm251:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $251, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 251)
  ret <4 x i64> %r
}

define <16 x i32> @vpternlog_d_v512_imm252(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v512_imm252:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpord %zmm1, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <16 x i32> @llvm.x86.avx512.pternlog.d.512(<16 x i32> %v0, <16 x i32> %v1, <16 x i32> %v2, i32 252)
  ret <16 x i32> %r
}

; This is bitselect pattern
define <2 x i64> @vpternlog_q_v128_imm253(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v128_imm253:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogq $253, %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %r = tail call <2 x i64> @llvm.x86.avx512.pternlog.q.128(<2 x i64> %v0, <2 x i64> %v1, <2 x i64> %v2, i32 253)
  ret <2 x i64> %r
}

define <8 x i32> @vpternlog_d_v256_imm254(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2) nounwind {
; CHECK-LABEL: vpternlog_d_v256_imm254:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $254, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, i32 254)
  ret <8 x i32> %r
}

define <8 x i64> @vpternlog_q_v512_imm255(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_q_v512_imm255:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %r = tail call <8 x i64> @llvm.x86.avx512.pternlog.q.512(<8 x i64> %v0, <8 x i64> %v1, <8 x i64> %v2, i32 255)
  ret <8 x i64> %r
}

define <8 x i32> @vpternlog_vselect_8xi32(<8 x i32> %v0, <8 x i32> %v1, <8 x i32> %v2, <8 x i32> %v3) nounwind {
; CHECK-LABEL: vpternlog_vselect_8xi32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; CHECK-NEXT:    vpternlogd $202, %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %vcmp = icmp eq <8 x i32> %v0, %v1
  %vmask = sext <8 x i1> %vcmp to <8 x i32>
  %r = tail call <8 x i32> @llvm.x86.avx512.pternlog.d.256(<8 x i32> %vmask, <8 x i32> %v1, <8 x i32> %v2, i32 202)
  ret <8 x i32> %r
}

define <4 x i64> @vpternlog_carry_save_add_4xi64(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2) nounwind {
; CHECK-LABEL: vpternlog_carry_save_add_4xi64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmovdqa %ymm0, %ymm3
; CHECK-NEXT:    vpternlogq $150, %ymm2, %ymm1, %ymm3
; CHECK-NEXT:    vpternlogq $232, %ymm2, %ymm0, %ymm1
; CHECK-NEXT:    vmovdqa %ymm3, %ymm0
; CHECK-NEXT:    jmp use_merge_4xi64@PLT # TAILCALL
  %l = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 150)
  %h = tail call <4 x i64> @llvm.x86.avx512.pternlog.q.256(<4 x i64> %v0, <4 x i64> %v1, <4 x i64> %v2, i32 232)
  %r = tail call <4 x i64> @use_merge_4xi64(<4 x i64> %l, <4 x i64> %h)
  ret <4 x i64> %r
}
