/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiler;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.tracing.Tracer;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.profiler.GetProfilingAction;
import org.elasticsearch.xpack.profiler.RestGetProfilingAction;
import org.elasticsearch.xpack.profiler.TransportGetProfilingAction;

public class ProfilingPlugin
extends Plugin
implements ActionPlugin {
    private static final Logger logger = LogManager.getLogger(ProfilingPlugin.class);
    public static final Setting<Boolean> PROFILING_ENABLED = Setting.boolSetting((String)"xpack.profiling.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final boolean enabled;

    public ProfilingPlugin(Settings settings) {
        this.enabled = (Boolean)PROFILING_ENABLED.get(settings);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, Tracer tracer, AllocationService allocationService) {
        logger.info("Profiling is {}", (Object)(this.enabled ? "enabled" : "disabled"));
        return super.createComponents(client, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, environment, nodeEnvironment, namedWriteableRegistry, indexNameExpressionResolver, repositoriesServiceSupplier, tracer, allocationService);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        if (this.enabled) {
            return Collections.singletonList(new RestGetProfilingAction());
        }
        return Collections.emptyList();
    }

    public List<Setting<?>> getSettings() {
        return List.of(PROFILING_ENABLED, TransportGetProfilingAction.PROFILING_MAX_STACKTRACE_QUERY_SLICES, TransportGetProfilingAction.PROFILING_MAX_DETAIL_QUERY_SLICES, TransportGetProfilingAction.PROFILING_QUERY_REALTIME);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)GetProfilingAction.INSTANCE, TransportGetProfilingAction.class));
    }
}

