/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiler;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xcontent.ObjectPath;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

final class StackFrame
implements ToXContentObject {
    List<String> fileName;
    List<String> functionName;
    List<Integer> functionOffset;
    List<Integer> lineNumber;
    List<Integer> sourceType;

    StackFrame(Object fileName, Object functionName, Object functionOffset, Object lineNumber, Object sourceType) {
        this.fileName = StackFrame.listOf(fileName);
        this.functionName = StackFrame.listOf(functionName);
        this.functionOffset = StackFrame.listOf(functionOffset);
        this.lineNumber = StackFrame.listOf(lineNumber);
        this.sourceType = StackFrame.listOf(sourceType);
    }

    private static <T> List<T> listOf(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        if (o != null) {
            return List.of(o);
        }
        return Collections.emptyList();
    }

    public static StackFrame fromSource(Map<String, Object> source) {
        if (source.containsKey("Stackframe")) {
            return new StackFrame(ObjectPath.eval((String)"Stackframe.file.name", source), ObjectPath.eval((String)"Stackframe.function.name", source), ObjectPath.eval((String)"Stackframe.function.offset", source), ObjectPath.eval((String)"Stackframe.line.number", source), ObjectPath.eval((String)"Stackframe.source.type", source));
        }
        return new StackFrame(source.get("Stackframe.file.name"), source.get("Stackframe.function.name"), source.get("Stackframe.function.offset"), source.get("Stackframe.line.number"), source.get("Stackframe.source.type"));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("file_name", this.fileName);
        builder.field("function_name", this.functionName);
        builder.field("function_offset", this.functionOffset);
        builder.field("line_number", this.lineNumber);
        builder.field("source_type", this.sourceType);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackFrame that = (StackFrame)o;
        return Objects.equals(this.fileName, that.fileName) && Objects.equals(this.functionName, that.functionName) && Objects.equals(this.functionOffset, that.functionOffset) && Objects.equals(this.lineNumber, that.lineNumber) && Objects.equals(this.sourceType, that.sourceType);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.functionName, this.functionOffset, this.lineNumber, this.sourceType);
    }
}

