/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Streams;
import org.elasticsearch.license.CryptUtils;
import org.elasticsearch.license.License;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class LicenseVerifier {
    private static final PublicKey PUBLIC_KEY;

    public static boolean verifyLicense(License license, PublicKey publicKey) {
        boolean bl;
        block6: {
            byte[] signedContent = null;
            byte[] publicKeyFingerprint = null;
            try {
                BytesRef ref;
                byte[] signatureBytes = Base64.getDecoder().decode(license.signature());
                ByteBuffer byteBuffer = ByteBuffer.wrap(signatureBytes);
                int version = byteBuffer.getInt();
                int magicLen = byteBuffer.getInt();
                byte[] magic = new byte[magicLen];
                byteBuffer.get(magic);
                int hashLen = byteBuffer.getInt();
                publicKeyFingerprint = new byte[hashLen];
                byteBuffer.get(publicKeyFingerprint);
                int signedContentLen = byteBuffer.getInt();
                signedContent = new byte[signedContentLen];
                byteBuffer.get(signedContent);
                XContentBuilder contentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
                license.toXContent(contentBuilder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("license_spec_view", "true")));
                Signature rsa = Signature.getInstance("SHA512withRSA");
                rsa.initVerify(publicKey);
                BytesRefIterator iterator = BytesReference.bytes((XContentBuilder)contentBuilder).iterator();
                while ((ref = iterator.next()) != null) {
                    rsa.update(ref.bytes, ref.offset, ref.length);
                }
                bl = rsa.verify(signedContent);
                if (signedContent == null) break block6;
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                try {
                    throw new IllegalStateException(e);
                }
                catch (Throwable throwable) {
                    if (signedContent != null) {
                        Arrays.fill(signedContent, (byte)0);
                    }
                    throw throwable;
                }
            }
            Arrays.fill(signedContent, (byte)0);
        }
        return bl;
    }

    public static boolean verifyLicense(License license) {
        return LicenseVerifier.verifyLicense(license, PUBLIC_KEY);
    }

    static {
        try (InputStream is = LicenseVerifier.class.getResourceAsStream("/public.key");){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Streams.copy((InputStream)is, (OutputStream)out);
            PUBLIC_KEY = CryptUtils.readPublicKey(out.toByteArray());
        }
        catch (IOException e) {
            throw new AssertionError("key file is part of the source and must deserialize correctly", e);
        }
    }
}

