/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.Clock;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.license.PostStartBasicRequest;
import org.elasticsearch.license.PostStartBasicResponse;
import org.elasticsearch.license.SelfGeneratedLicense;
import org.elasticsearch.xpack.core.XPackPlugin;

public class StartBasicClusterTask
implements ClusterStateTaskListener {
    private static final String ACKNOWLEDGEMENT_HEADER = "This license update requires acknowledgement. To acknowledge the license, please read the following messages and call /start_basic again, this time with the \"acknowledge=true\" parameter:";
    private final Logger logger;
    private final String clusterName;
    private final PostStartBasicRequest request;
    private final String description;
    private final ActionListener<PostStartBasicResponse> listener;
    private final Clock clock;

    StartBasicClusterTask(Logger logger, String clusterName, Clock clock, PostStartBasicRequest request, String description, ActionListener<PostStartBasicResponse> listener) {
        this.logger = logger;
        this.clusterName = clusterName;
        this.request = request;
        this.description = description;
        this.listener = listener;
        this.clock = clock;
    }

    public LicensesMetadata execute(LicensesMetadata currentLicensesMetadata, DiscoveryNodes discoveryNodes, ClusterStateTaskExecutor.TaskContext<StartBasicClusterTask> taskContext) throws Exception {
        LicensesMetadata updatedLicensesMetadata;
        assert (taskContext.getTask() == this);
        ActionListener listener = ActionListener.runBefore(this.listener, () -> this.logger.debug("license prior to starting basic license: {}", (Object)currentLicensesMetadata));
        License currentLicense = LicensesMetadata.extractLicense(currentLicensesMetadata);
        if (this.shouldGenerateNewBasicLicense(currentLicense)) {
            Map<String, String[]> ackMessageMap;
            License selfGeneratedLicense = this.generateBasicLicense(discoveryNodes);
            if (!this.request.isAcknowledged() && currentLicense != null && !(ackMessageMap = LicenseService.getAckMessages(selfGeneratedLicense, currentLicense)).isEmpty()) {
                taskContext.success(() -> listener.onResponse((Object)new PostStartBasicResponse(PostStartBasicResponse.Status.NEED_ACKNOWLEDGEMENT, ackMessageMap, ACKNOWLEDGEMENT_HEADER)));
                return currentLicensesMetadata;
            }
            Version trialVersion = currentLicensesMetadata != null ? currentLicensesMetadata.getMostRecentTrialVersion() : null;
            updatedLicensesMetadata = new LicensesMetadata(selfGeneratedLicense, trialVersion);
        } else {
            updatedLicensesMetadata = currentLicensesMetadata;
        }
        boolean newLicenseGenerated = updatedLicensesMetadata != currentLicensesMetadata;
        PostStartBasicResponse.Status responseStatus = newLicenseGenerated ? PostStartBasicResponse.Status.GENERATED_BASIC : PostStartBasicResponse.Status.ALREADY_USING_BASIC;
        taskContext.success(() -> listener.onResponse((Object)new PostStartBasicResponse(responseStatus)));
        return updatedLicensesMetadata;
    }

    public void onFailure(@Nullable Exception e) {
        this.logger.error(() -> "unexpected failure during [" + this.description + "]", (Throwable)e);
        this.listener.onFailure(e);
    }

    private boolean shouldGenerateNewBasicLicense(License currentLicense) {
        return currentLicense == null || !License.LicenseType.isBasic(currentLicense.type()) || 1000 != currentLicense.maxNodes() || LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS != LicenseService.getExpiryDate(currentLicense);
    }

    private License generateBasicLicense(DiscoveryNodes discoveryNodes) {
        License.Builder specBuilder = License.builder().uid(UUID.randomUUID().toString()).issuedTo(this.clusterName).maxNodes(1000).issueDate(this.clock.millis()).type(License.LicenseType.BASIC).expiryDate(LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS);
        return SelfGeneratedLicense.create(specBuilder, discoveryNodes);
    }

    public String getDescription() {
        return this.description;
    }

    static class Executor
    implements ClusterStateTaskExecutor<StartBasicClusterTask> {
        Executor() {
        }

        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<StartBasicClusterTask> batchExecutionContext) throws Exception {
            LicensesMetadata originalLicensesMetadata;
            ClusterState initialState = batchExecutionContext.initialState();
            XPackPlugin.checkReadyForXPackCustomMetadata(initialState);
            LicensesMetadata currentLicensesMetadata = originalLicensesMetadata = (LicensesMetadata)initialState.metadata().custom("licenses");
            for (ClusterStateTaskExecutor.TaskContext taskContext : batchExecutionContext.taskContexts()) {
                Releasable ignored = taskContext.captureResponseHeaders();
                try {
                    currentLicensesMetadata = ((StartBasicClusterTask)taskContext.getTask()).execute(currentLicensesMetadata, initialState.nodes(), (ClusterStateTaskExecutor.TaskContext<StartBasicClusterTask>)taskContext);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            if (currentLicensesMetadata == originalLicensesMetadata) {
                return initialState;
            }
            return ClusterState.builder((ClusterState)initialState).metadata(Metadata.builder((Metadata)initialState.metadata()).putCustom("licenses", (Metadata.Custom)currentLicensesMetadata)).build();
        }
    }
}

