/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.cluster.routing.allocation.mapper;

import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public class DataTierFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_tier";
    public static final String CONTENT_TYPE = "_tier";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> new DataTierFieldMapper());

    public DataTierFieldMapper() {
        super((MappedFieldType)DataTierFieldType.INSTANCE);
    }

    protected String contentType() {
        return "_tier";
    }

    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    static final class DataTierFieldType
    extends ConstantFieldType {
        static final DataTierFieldType INSTANCE = new DataTierFieldType();

        private DataTierFieldType() {
            super("_tier", Collections.emptyMap());
        }

        public String typeName() {
            return "_tier";
        }

        public String familyTypeName() {
            return "keyword";
        }

        protected boolean matches(String pattern, boolean caseInsensitive, SearchExecutionContext context) {
            String tierPreference;
            if (caseInsensitive) {
                pattern = Strings.toLowercaseAscii((String)pattern);
            }
            if ((tierPreference = this.getTierPreference(context)) == null) {
                return false;
            }
            return Regex.simpleMatch((String)pattern, (String)tierPreference);
        }

        public Query existsQuery(SearchExecutionContext context) {
            String tierPreference = this.getTierPreference(context);
            if (tierPreference == null) {
                return new MatchNoDocsQuery();
            }
            return new MatchAllDocsQuery();
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            String tierPreference = this.getTierPreference(context);
            return tierPreference == null ? (lookup, doc, ignoredValues) -> List.of() : (lookup, doc, ignoredValues) -> List.of(tierPreference);
        }

        private String getTierPreference(SearchExecutionContext context) {
            Settings settings = context.getIndexSettings().getSettings();
            String value = (String)DataTier.TIER_PREFERENCE_SETTING.get(settings);
            if (!Strings.hasText((String)value)) {
                return null;
            }
            return value.split(",")[0].trim();
        }
    }
}

