/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.DataTiersFeatureSetUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;

public class DataTiersUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Client client;

    @Inject
    public DataTiersUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(XPackUsageFeatureAction.DATA_TIERS.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.client = client;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        this.client.admin().cluster().prepareNodesStats(new String[0]).all().setIndices(CommonStatsFlags.ALL).execute(ActionListener.wrap(nodesStatsResponse -> {
            RoutingNodes routingNodes = state.getRoutingNodes();
            Map indices = state.getMetadata().getIndices();
            Map<String, String> indicesToTiers = DataTiersUsageTransportAction.tierIndices(indices);
            Map<String, DataTiersFeatureSetUsage.TierSpecificStats> tierSpecificStats = DataTiersUsageTransportAction.calculateStats(nodesStatsResponse.getNodes(), indicesToTiers, routingNodes);
            listener.onResponse((Object)new XPackUsageFeatureResponse(new DataTiersFeatureSetUsage(tierSpecificStats)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static Map<String, String> tierIndices(Map<String, IndexMetadata> indices) {
        HashMap<String, String> indexByTier = new HashMap<String, String>();
        indices.entrySet().forEach(entry -> {
            String[] tiers;
            String tierPref = ((IndexMetadata)entry.getValue()).getSettings().get("index.routing.allocation.include._tier_preference");
            if (Strings.hasText((String)tierPref) && (tiers = tierPref.split(",")).length > 0) {
                indexByTier.put((String)entry.getKey(), tiers[0]);
            }
        });
        return indexByTier;
    }

    static Map<String, DataTiersFeatureSetUsage.TierSpecificStats> calculateStats(List<NodeStats> nodesStats, Map<String, String> indexByTier, RoutingNodes routingNodes) {
        HashMap<String, TierStatsAccumulator> statsAccumulators = new HashMap<String, TierStatsAccumulator>();
        for (NodeStats nodeStats : nodesStats) {
            DataTiersUsageTransportAction.aggregateDataTierNodeCounts(nodeStats, statsAccumulators);
            DataTiersUsageTransportAction.aggregateDataTierIndexStats(nodeStats, routingNodes, indexByTier, statsAccumulators);
        }
        HashMap<String, DataTiersFeatureSetUsage.TierSpecificStats> results = new HashMap<String, DataTiersFeatureSetUsage.TierSpecificStats>();
        for (Map.Entry entry : statsAccumulators.entrySet()) {
            results.put((String)entry.getKey(), DataTiersUsageTransportAction.calculateFinalTierStats((TierStatsAccumulator)entry.getValue()));
        }
        return results;
    }

    private static void aggregateDataTierNodeCounts(NodeStats nodeStats, Map<String, TierStatsAccumulator> tiersStats) {
        nodeStats.getNode().getRoles().stream().map(DiscoveryNodeRole::roleName).filter(DataTier::validTierName).forEach(tier -> ++tiersStats.computeIfAbsent(tier, (Function<String, TierStatsAccumulator>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$aggregateDataTierNodeCounts$2(java.lang.String ), (Ljava/lang/String;)Lorg/elasticsearch/xpack/core/DataTiersUsageTransportAction$TierStatsAccumulator;)()).nodeCount);
    }

    private static void aggregateDataTierIndexStats(NodeStats nodeStats, RoutingNodes routingNodes, Map<String, String> indexByTier, Map<String, TierStatsAccumulator> accumulators) {
        RoutingNode node = routingNodes.node(nodeStats.getNode().getId());
        if (node != null) {
            StreamSupport.stream(node.spliterator(), false).map(ShardRouting::index).distinct().forEach(index -> DataTiersUsageTransportAction.classifyIndexAndCollectStats(index, nodeStats, indexByTier, node, accumulators));
        }
    }

    private static void classifyIndexAndCollectStats(Index index, NodeStats nodeStats, Map<String, String> indexByTier, RoutingNode node, Map<String, TierStatsAccumulator> accumulators) {
        String indexTier = indexByTier.get(index.getName());
        if (indexTier != null) {
            TierStatsAccumulator accumulator = accumulators.computeIfAbsent(indexTier, k -> new TierStatsAccumulator());
            accumulator.indexNames.add(index.getName());
            DataTiersUsageTransportAction.aggregateDataTierShardStats(nodeStats, index, node, accumulator);
        }
    }

    private static void aggregateDataTierShardStats(NodeStats nodeStats, Index index, RoutingNode node, TierStatsAccumulator accumulator) {
        List allShardStats = nodeStats.getIndices().getShardStats(index);
        if (allShardStats != null) {
            for (IndexShardStats shardStat : allShardStats) {
                accumulator.totalByteCount += shardStat.getTotal().getStore().totalDataSetSizeInBytes();
                accumulator.docCount += shardStat.getTotal().getDocs().getCount();
                if (node.getByShardId(shardStat.getShardId()).state() != ShardRoutingState.STARTED) continue;
                ++accumulator.totalShardCount;
                StoreStats primaryStoreStats = shardStat.getPrimary().getStore();
                if (primaryStoreStats == null) continue;
                ++accumulator.primaryShardCount;
                long primarySize = primaryStoreStats.totalDataSetSizeInBytes();
                accumulator.primaryByteCount += primarySize;
                accumulator.valueSketch.add((double)primarySize);
            }
        }
    }

    private static DataTiersFeatureSetUsage.TierSpecificStats calculateFinalTierStats(TierStatsAccumulator accumulator) {
        long primaryShardSizeMedian = (long)accumulator.valueSketch.quantile(0.5);
        long primaryShardSizeMAD = DataTiersUsageTransportAction.computeMedianAbsoluteDeviation(accumulator.valueSketch);
        return new DataTiersFeatureSetUsage.TierSpecificStats(accumulator.nodeCount, accumulator.indexNames.size(), accumulator.totalShardCount, accumulator.primaryShardCount, accumulator.docCount, accumulator.totalByteCount, accumulator.primaryByteCount, primaryShardSizeMedian, primaryShardSizeMAD);
    }

    static long computeMedianAbsoluteDeviation(TDigestState valuesSketch) {
        if (valuesSketch.size() == 0L) {
            return 0L;
        }
        double approximateMedian = valuesSketch.quantile(0.5);
        TDigestState approximatedDeviationsSketch = new TDigestState(valuesSketch.compression());
        valuesSketch.centroids().forEach(centroid -> {
            double deviation = Math.abs(approximateMedian - centroid.mean());
            approximatedDeviationsSketch.add(deviation, centroid.count());
        });
        return (long)approximatedDeviationsSketch.quantile(0.5);
    }

    private static /* synthetic */ TierStatsAccumulator lambda$aggregateDataTierNodeCounts$2(String k) {
        return new TierStatsAccumulator();
    }

    private static class TierStatsAccumulator {
        int nodeCount = 0;
        Set<String> indexNames = new HashSet<String>();
        int totalShardCount = 0;
        long totalByteCount = 0L;
        long docCount = 0L;
        int primaryShardCount = 0;
        long primaryByteCount = 0L;
        final TDigestState valueSketch = new TDigestState(1000.0);

        private TierStatsAccumulator() {
        }
    }
}

