/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.downsample;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.downsample.DownsampleConfig;
import org.elasticsearch.xpack.core.downsample.DownsampleTask;

public class DownsampleAction
extends ActionType<AcknowledgedResponse> {
    public static final DownsampleAction INSTANCE = new DownsampleAction();
    public static final String NAME = "indices:admin/xpack/downsample";

    private DownsampleAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse> {
        protected RequestBuilder(ElasticsearchClient client, DownsampleAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements IndicesRequest,
    ToXContentObject {
        private String sourceIndex;
        private String targetIndex;
        private DownsampleConfig downsampleConfig;

        public Request(String sourceIndex, String targetIndex, DownsampleConfig downsampleConfig) {
            this.sourceIndex = sourceIndex;
            this.targetIndex = targetIndex;
            this.downsampleConfig = downsampleConfig;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.sourceIndex = in.readString();
            this.targetIndex = in.readString();
            this.downsampleConfig = new DownsampleConfig(in);
        }

        public String[] indices() {
            return new String[]{this.sourceIndex};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new DownsampleTask(id, type, action, parentTaskId, this.targetIndex, this.downsampleConfig, headers);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sourceIndex);
            out.writeString(this.targetIndex);
            this.downsampleConfig.writeTo(out);
        }

        public String getSourceIndex() {
            return this.sourceIndex;
        }

        public String getTargetIndex() {
            return this.targetIndex;
        }

        public DownsampleConfig getDownsampleConfig() {
            return this.downsampleConfig;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.sourceIndex == null) {
                validationException = ValidateActions.addValidationError((String)"source index is missing", validationException);
            }
            if (this.targetIndex == null) {
                validationException = ValidateActions.addValidationError((String)"target index name is missing", (ActionRequestValidationException)validationException);
            }
            if (this.downsampleConfig == null) {
                validationException = ValidateActions.addValidationError((String)"downsample configuration is missing", (ActionRequestValidationException)validationException);
            }
            return validationException;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("source_index", this.sourceIndex);
            builder.field("target_index", this.targetIndex);
            this.downsampleConfig.toXContent(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.sourceIndex, this.targetIndex, this.downsampleConfig);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.sourceIndex, other.sourceIndex) && Objects.equals(this.targetIndex, other.targetIndex) && Objects.equals(this.downsampleConfig, other.downsampleConfig);
        }
    }
}

