/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.CleanupSnapshotStep;
import org.elasticsearch.xpack.core.ilm.DeleteStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.WaitForNoFollowersStep;

public class DeleteAction
implements LifecycleAction {
    public static final String NAME = "delete";
    public static final ParseField DELETE_SEARCHABLE_SNAPSHOT_FIELD = new ParseField("delete_searchable_snapshot", new String[0]);
    public static final DeleteAction WITH_SNAPSHOT_DELETE = new DeleteAction(true);
    public static final DeleteAction NO_SNAPSHOT_DELETE = new DeleteAction(false);
    private static final ConstructingObjectParser<DeleteAction, Void> PARSER = new ConstructingObjectParser("delete", a -> a[0] == null || (Boolean)a[0] != false ? WITH_SNAPSHOT_DELETE : NO_SNAPSHOT_DELETE);
    private final boolean deleteSearchableSnapshot;

    public static DeleteAction parse(XContentParser parser) {
        return (DeleteAction)PARSER.apply(parser, null);
    }

    private DeleteAction(boolean deleteSearchableSnapshot) {
        this.deleteSearchableSnapshot = deleteSearchableSnapshot;
    }

    public static DeleteAction readFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? WITH_SNAPSHOT_DELETE : NO_SNAPSHOT_DELETE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.deleteSearchableSnapshot);
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DELETE_SEARCHABLE_SNAPSHOT_FIELD.getPreferredName(), this.deleteSearchableSnapshot);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isSafeAction() {
        return true;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey waitForNoFollowerStepKey = new Step.StepKey(phase, NAME, "wait-for-shard-history-leases");
        Step.StepKey deleteStepKey = new Step.StepKey(phase, NAME, NAME);
        Step.StepKey cleanSnapshotKey = new Step.StepKey(phase, NAME, "cleanup-snapshot");
        if (this.deleteSearchableSnapshot) {
            WaitForNoFollowersStep waitForNoFollowersStep = new WaitForNoFollowersStep(waitForNoFollowerStepKey, cleanSnapshotKey, client);
            CleanupSnapshotStep cleanupSnapshotStep = new CleanupSnapshotStep(cleanSnapshotKey, deleteStepKey, client);
            DeleteStep deleteStep = new DeleteStep(deleteStepKey, nextStepKey, client);
            return Arrays.asList(waitForNoFollowersStep, cleanupSnapshotStep, deleteStep);
        }
        WaitForNoFollowersStep waitForNoFollowersStep = new WaitForNoFollowersStep(waitForNoFollowerStepKey, deleteStepKey, client);
        DeleteStep deleteStep = new DeleteStep(deleteStepKey, nextStepKey, client);
        return Arrays.asList(waitForNoFollowersStep, deleteStep);
    }

    public int hashCode() {
        return Objects.hash(this.deleteSearchableSnapshot);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        DeleteAction that = (DeleteAction)obj;
        return this.deleteSearchableSnapshot == that.deleteSearchableSnapshot;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), DELETE_SEARCHABLE_SNAPSHOT_FIELD);
    }
}

