/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.core.downsample.DownsampleAction;
import org.elasticsearch.xpack.core.downsample.DownsampleConfig;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class DownsampleStep
extends AsyncActionStep {
    public static final String NAME = "rollup";
    private static final Logger logger = LogManager.getLogger(DownsampleStep.class);
    private final DateHistogramInterval fixedInterval;

    public DownsampleStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, DateHistogramInterval fixedInterval) {
        super(key, nextStepKey, client);
        this.fixedInterval = fixedInterval;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        if (lifecycleState.lifecycleDate() == null) {
            throw new IllegalStateException("source index [" + indexMetadata.getIndex().getName() + "] is missing lifecycle date");
        }
        String policyName = indexMetadata.getLifecyclePolicyName();
        String indexName = indexMetadata.getIndex().getName();
        String downsampleIndexName = lifecycleState.downsampleIndexName();
        if (!Strings.hasText((String)downsampleIndexName)) {
            listener.onFailure((Exception)new IllegalStateException("rollup index name was not generated for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        IndexMetadata rollupIndexMetadata = currentState.metadata().index(downsampleIndexName);
        if (rollupIndexMetadata != null) {
            IndexMetadata.DownsampleTaskStatus rollupIndexStatus = (IndexMetadata.DownsampleTaskStatus)IndexMetadata.INDEX_DOWNSAMPLE_STATUS.get(rollupIndexMetadata.getSettings());
            if (IndexMetadata.DownsampleTaskStatus.SUCCESS.equals((Object)rollupIndexStatus)) {
                logger.warn("skipping [{}] step for index [{}] as part of policy [{}] as the rollup index [{}] already exists", (Object)NAME, (Object)indexName, (Object)policyName, (Object)downsampleIndexName);
                listener.onResponse(null);
            } else {
                logger.warn("[{}] step for index [{}] as part of policy [{}] found the rollup index [{}] already exists. Deleting it.", (Object)NAME, (Object)indexName, (Object)policyName, (Object)downsampleIndexName);
                DeleteIndexRequest deleteRequest = new DeleteIndexRequest(downsampleIndexName);
                this.getClient().admin().indices().delete(deleteRequest, ActionListener.wrap(response -> {
                    if (response.isAcknowledged()) {
                        this.performDownsampleIndex(indexName, downsampleIndexName, listener);
                    } else {
                        listener.onFailure((Exception)new IllegalStateException("failing [rollup] step for index [" + indexName + "] as part of policy [" + policyName + "] because the rollup index [" + downsampleIndexName + "] already exists with rollup status [" + rollupIndexStatus + "]"));
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
            return;
        }
        this.performDownsampleIndex(indexName, downsampleIndexName, listener);
    }

    private void performDownsampleIndex(String indexName, String rollupIndexName, ActionListener<Void> listener) {
        DownsampleConfig config = new DownsampleConfig(this.fixedInterval);
        DownsampleAction.Request request = (DownsampleAction.Request)new DownsampleAction.Request(indexName, rollupIndexName, config).masterNodeTimeout(TimeValue.MAX_VALUE);
        this.getClient().execute((ActionType)DownsampleAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(response -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
    }

    public DateHistogramInterval getFixedInterval() {
        return this.fixedInterval;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fixedInterval);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownsampleStep other = (DownsampleStep)obj;
        return super.equals(obj) && Objects.equals(this.fixedInterval, other.fixedInterval);
    }
}

