/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class UpdateRollupIndexPolicyStep
extends AsyncActionStep {
    public static final String NAME = "update-rollup-policy";
    private final String rollupPolicy;

    public UpdateRollupIndexPolicyStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, String rollupPolicy) {
        super(key, nextStepKey, client);
        this.rollupPolicy = rollupPolicy;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public String getRollupPolicy() {
        return this.rollupPolicy;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        String policyName = indexMetadata.getLifecyclePolicyName();
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        String downsampleIndexName = lifecycleState.downsampleIndexName();
        if (!Strings.hasText((String)downsampleIndexName)) {
            listener.onFailure((Exception)new IllegalStateException("rollup index name was not generated for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        Settings settings = Settings.builder().put("index.lifecycle.name", this.rollupPolicy).build();
        UpdateSettingsRequest updateSettingsRequest = ((UpdateSettingsRequest)new UpdateSettingsRequest(new String[]{downsampleIndexName}).masterNodeTimeout(TimeValue.MAX_VALUE)).settings(settings);
        this.getClient().admin().indices().updateSettings(updateSettingsRequest, ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                listener.onResponse(null);
            } else {
                listener.onFailure((Exception)new ElasticsearchException("settings update not acknowledged in step [" + this.getKey().toString() + "]", new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rollupPolicy);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateRollupIndexPolicyStep other = (UpdateRollupIndexPolicyStep)obj;
        return super.equals(obj) && Objects.equals(this.rollupPolicy, other.rollupPolicy);
    }
}

