/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class UpdateTrainedModelDeploymentAction
extends ActionType<CreateTrainedModelAssignmentAction.Response> {
    public static final UpdateTrainedModelDeploymentAction INSTANCE = new UpdateTrainedModelDeploymentAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/deployment/update";

    public UpdateTrainedModelDeploymentAction() {
        super(NAME, CreateTrainedModelAssignmentAction.Response::new);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        public static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/trained_models/deployment/update", Request::new);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        private String modelId;
        private int numberOfAllocations;

        public static Request parseRequest(String modelId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (request.getModelId() == null) {
                request.setModelId(modelId);
            } else if (!Strings.isNullOrEmpty((String)modelId) && !modelId.equals(request.getModelId())) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", StartTrainedModelDeploymentAction.Request.MODEL_ID, request.getModelId(), modelId), new Object[0]);
            }
            return request;
        }

        private Request() {
        }

        public Request(String modelId) {
            this.setModelId(modelId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.numberOfAllocations = in.readVInt();
        }

        public final void setModelId(String modelId) {
            this.modelId = ExceptionsHelper.requireNonNull(modelId, StartTrainedModelDeploymentAction.Request.MODEL_ID);
        }

        public String getModelId() {
            return this.modelId;
        }

        public void setNumberOfAllocations(int numberOfAllocations) {
            this.numberOfAllocations = numberOfAllocations;
        }

        public int getNumberOfAllocations() {
            return this.numberOfAllocations;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            out.writeVInt(this.numberOfAllocations);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName(), this.modelId);
            builder.field(StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS.getPreferredName(), this.numberOfAllocations);
            builder.endObject();
            return builder;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = new ActionRequestValidationException();
            if (this.numberOfAllocations < 1) {
                validationException.addValidationError("[" + StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS + "] must be a positive integer");
            }
            return validationException.validationErrors().isEmpty() ? null : validationException;
        }

        public int hashCode() {
            return Objects.hash(this.modelId, this.numberOfAllocations);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.modelId, other.modelId) && this.numberOfAllocations == other.numberOfAllocations;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareString(Request::setModelId, StartTrainedModelDeploymentAction.Request.MODEL_ID);
            PARSER.declareInt(Request::setNumberOfAllocations, StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS);
            PARSER.declareString((r, val) -> r.timeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
        }
    }
}

