/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.xpack.core.ml.datafeed.SearchInterval;

public interface DataExtractor {
    public boolean hasNext();

    public Result next() throws IOException;

    public boolean isCancelled();

    public void cancel();

    public long getEndTime();

    default public void checkForSkippedClusters(SearchResponse searchResponse) {
        SearchResponse.Clusters clusterResponse = searchResponse.getClusters();
        if (clusterResponse != null && clusterResponse.getSkipped() > 0) {
            throw new ResourceNotFoundException("[{}] remote clusters out of [{}] were skipped when performing datafeed search", new Object[]{clusterResponse.getSkipped(), clusterResponse.getTotal()});
        }
    }

    public record Result(SearchInterval searchInterval, Optional<InputStream> data) {
    }
}

