/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.NlpClassificationInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.TopClassEntry;

public class FillMaskResults
extends NlpClassificationInferenceResults {
    public static final String NAME = "fill_mask_result";
    private final String predictedSequence;

    public FillMaskResults(String classificationLabel, String predictedSequence, List<TopClassEntry> topClasses, String resultsField, Double predictionProbability, boolean isTruncated) {
        super(classificationLabel, topClasses, resultsField, predictionProbability, isTruncated);
        this.predictedSequence = predictedSequence;
    }

    public FillMaskResults(StreamInput in) throws IOException {
        super(in);
        this.predictedSequence = in.readString();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeString(this.predictedSequence);
    }

    public String getPredictedSequence() {
        return this.predictedSequence;
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        super.addMapFields(map);
        map.put(this.resultsField + "_sequence", this.predictedSequence);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, params);
        builder.field(this.resultsField + "_sequence", this.predictedSequence);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FillMaskResults that = (FillMaskResults)o;
        return Objects.equals(this.predictedSequence, that.predictedSequence);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.predictedSequence);
    }
}

