/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.inference.results.WarningInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public interface InferenceConfigUpdate
extends VersionedNamedWriteable {
    public static final Set<String> RESERVED_ML_FIELD_NAMES = new HashSet<String>(Arrays.asList(WarningInferenceResults.WARNING.getPreferredName(), TrainedModelConfig.MODEL_ID.getPreferredName()));

    public InferenceConfig apply(InferenceConfig var1);

    public boolean isSupported(InferenceConfig var1);

    public String getResultsField();

    public Builder<? extends Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder();

    default public String getName() {
        return this.getWriteableName();
    }

    public static void checkFieldUniqueness(String ... fieldNames) {
        HashSet<String> duplicatedFieldNames = new HashSet<String>();
        HashSet<String> currentFieldNames = new HashSet<String>(RESERVED_ML_FIELD_NAMES);
        for (String fieldName : fieldNames) {
            if (fieldName == null) continue;
            if (currentFieldNames.contains(fieldName)) {
                duplicatedFieldNames.add(fieldName);
                continue;
            }
            currentFieldNames.add(fieldName);
        }
        if (!duplicatedFieldNames.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Invalid inference config. More than one field is configured as {}", duplicatedFieldNames);
        }
    }

    public static interface Builder<T extends Builder<T, U>, U extends InferenceConfigUpdate> {
        public U build();

        public T setResultsField(String var1);
    }
}

