/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.job.config.DefaultDetectorDescription;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.DetectorFunction;
import org.elasticsearch.xpack.core.ml.job.config.RuleCondition;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class Detector
implements ToXContentObject,
Writeable {
    public static final ParseField DETECTOR_DESCRIPTION_FIELD = new ParseField("detector_description", new String[0]);
    public static final ParseField FUNCTION_FIELD = new ParseField("function", new String[0]);
    public static final ParseField FIELD_NAME_FIELD = new ParseField("field_name", new String[0]);
    public static final ParseField BY_FIELD_NAME_FIELD = new ParseField("by_field_name", new String[0]);
    public static final ParseField OVER_FIELD_NAME_FIELD = new ParseField("over_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME_FIELD = new ParseField("partition_field_name", new String[0]);
    public static final ParseField USE_NULL_FIELD = new ParseField("use_null", new String[0]);
    public static final ParseField EXCLUDE_FREQUENT_FIELD = new ParseField("exclude_frequent", new String[0]);
    public static final ParseField CUSTOM_RULES_FIELD = new ParseField("custom_rules", new String[0]);
    public static final ParseField DETECTOR_INDEX = new ParseField("detector_index", new String[0]);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = Detector.createParser(true);
    public static final ObjectParser<Builder, Void> STRICT_PARSER = Detector.createParser(false);
    public static final String BY = "by";
    public static final String OVER = "over";
    public static final EnumSet<DetectorFunction> COUNT_WITHOUT_FIELD_FUNCTIONS = EnumSet.of(DetectorFunction.COUNT, new DetectorFunction[]{DetectorFunction.HIGH_COUNT, DetectorFunction.LOW_COUNT, DetectorFunction.NON_ZERO_COUNT, DetectorFunction.LOW_NON_ZERO_COUNT, DetectorFunction.HIGH_NON_ZERO_COUNT, DetectorFunction.TIME_OF_DAY, DetectorFunction.TIME_OF_WEEK});
    public static final EnumSet<DetectorFunction> FIELD_NAME_FUNCTIONS = EnumSet.of(DetectorFunction.DISTINCT_COUNT, new DetectorFunction[]{DetectorFunction.LOW_DISTINCT_COUNT, DetectorFunction.HIGH_DISTINCT_COUNT, DetectorFunction.INFO_CONTENT, DetectorFunction.LOW_INFO_CONTENT, DetectorFunction.HIGH_INFO_CONTENT, DetectorFunction.METRIC, DetectorFunction.MEAN, DetectorFunction.AVG, DetectorFunction.HIGH_MEAN, DetectorFunction.HIGH_AVG, DetectorFunction.LOW_MEAN, DetectorFunction.LOW_AVG, DetectorFunction.MEDIAN, DetectorFunction.LOW_MEDIAN, DetectorFunction.HIGH_MEDIAN, DetectorFunction.MIN, DetectorFunction.MAX, DetectorFunction.SUM, DetectorFunction.LOW_SUM, DetectorFunction.HIGH_SUM, DetectorFunction.NON_NULL_SUM, DetectorFunction.LOW_NON_NULL_SUM, DetectorFunction.HIGH_NON_NULL_SUM, DetectorFunction.VARP, DetectorFunction.LOW_VARP, DetectorFunction.HIGH_VARP, DetectorFunction.LAT_LONG});
    public static final EnumSet<DetectorFunction> BY_FIELD_NAME_FUNCTIONS = EnumSet.of(DetectorFunction.RARE, DetectorFunction.FREQ_RARE);
    public static final EnumSet<DetectorFunction> OVER_FIELD_NAME_FUNCTIONS = EnumSet.of(DetectorFunction.FREQ_RARE);
    public static final EnumSet<DetectorFunction> NO_OVER_FIELD_NAME_FUNCTIONS = EnumSet.of(DetectorFunction.NON_ZERO_COUNT, DetectorFunction.LOW_NON_ZERO_COUNT, DetectorFunction.HIGH_NON_ZERO_COUNT);
    static final EnumSet<DetectorFunction> FUNCTIONS_WITHOUT_RULE_CONDITION_SUPPORT = EnumSet.of(DetectorFunction.LAT_LONG, DetectorFunction.METRIC, DetectorFunction.RARE, DetectorFunction.FREQ_RARE);
    public static final Character[] PROHIBITED_FIELDNAME_CHARACTERS = new Character[]{Character.valueOf('\"'), Character.valueOf('\\')};
    public static final String PROHIBITED = String.join((CharSequence)",", Arrays.stream(PROHIBITED_FIELDNAME_CHARACTERS).map(c -> Character.toString(c.charValue())).collect(Collectors.toList()));
    private final String detectorDescription;
    private final DetectorFunction function;
    private final String fieldName;
    private final String byFieldName;
    private final String overFieldName;
    private final String partitionFieldName;
    private final boolean useNull;
    private final ExcludeFrequent excludeFrequent;
    private final List<DetectionRule> rules;
    private final int detectorIndex;

    private static ObjectParser<Builder, Void> createParser(boolean ignoreUnknownFields) {
        ObjectParser parser = new ObjectParser("detector", ignoreUnknownFields, Builder::new);
        parser.declareString(Builder::setDetectorDescription, DETECTOR_DESCRIPTION_FIELD);
        parser.declareString(Builder::setFunction, FUNCTION_FIELD);
        parser.declareString(Builder::setFieldName, FIELD_NAME_FIELD);
        parser.declareString(Builder::setByFieldName, BY_FIELD_NAME_FIELD);
        parser.declareString(Builder::setOverFieldName, OVER_FIELD_NAME_FIELD);
        parser.declareString(Builder::setPartitionFieldName, PARTITION_FIELD_NAME_FIELD);
        parser.declareBoolean(Builder::setUseNull, USE_NULL_FIELD);
        parser.declareString(Builder::setExcludeFrequent, ExcludeFrequent::forString, EXCLUDE_FREQUENT_FIELD);
        parser.declareObjectArray(Builder::setRules, (p, c) -> ((DetectionRule.Builder)(ignoreUnknownFields ? DetectionRule.LENIENT_PARSER : DetectionRule.STRICT_PARSER).apply(p, c)).build(), CUSTOM_RULES_FIELD);
        parser.declareInt(Builder::setDetectorIndex, DETECTOR_INDEX);
        return parser;
    }

    public Detector(StreamInput in) throws IOException {
        this.detectorDescription = in.readString();
        this.function = DetectorFunction.fromString(in.readString());
        this.fieldName = in.readOptionalString();
        this.byFieldName = in.readOptionalString();
        this.overFieldName = in.readOptionalString();
        this.partitionFieldName = in.readOptionalString();
        this.useNull = in.readBoolean();
        this.excludeFrequent = in.readBoolean() ? ExcludeFrequent.readFromStream(in) : null;
        this.rules = in.readImmutableList(DetectionRule::new);
        this.detectorIndex = in.readInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.detectorDescription);
        out.writeString(this.function.getFullName());
        out.writeOptionalString(this.fieldName);
        out.writeOptionalString(this.byFieldName);
        out.writeOptionalString(this.overFieldName);
        out.writeOptionalString(this.partitionFieldName);
        out.writeBoolean(this.useNull);
        if (this.excludeFrequent != null) {
            out.writeBoolean(true);
            this.excludeFrequent.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeList(this.rules);
        out.writeInt(this.detectorIndex);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DETECTOR_DESCRIPTION_FIELD.getPreferredName(), this.detectorDescription);
        builder.field(FUNCTION_FIELD.getPreferredName(), (Enum)this.function);
        if (this.fieldName != null) {
            builder.field(FIELD_NAME_FIELD.getPreferredName(), this.fieldName);
        }
        if (this.byFieldName != null) {
            builder.field(BY_FIELD_NAME_FIELD.getPreferredName(), this.byFieldName);
        }
        if (this.overFieldName != null) {
            builder.field(OVER_FIELD_NAME_FIELD.getPreferredName(), this.overFieldName);
        }
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME_FIELD.getPreferredName(), this.partitionFieldName);
        }
        if (this.useNull) {
            builder.field(USE_NULL_FIELD.getPreferredName(), this.useNull);
        }
        if (this.excludeFrequent != null) {
            builder.field(EXCLUDE_FREQUENT_FIELD.getPreferredName(), (Enum)this.excludeFrequent);
        }
        if (!this.rules.isEmpty()) {
            builder.field(CUSTOM_RULES_FIELD.getPreferredName(), this.rules);
        }
        if (this.detectorIndex >= 0 && !params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
        }
        builder.endObject();
        return builder;
    }

    private Detector(String detectorDescription, DetectorFunction function, String fieldName, String byFieldName, String overFieldName, String partitionFieldName, boolean useNull, ExcludeFrequent excludeFrequent, List<DetectionRule> rules, int detectorIndex) {
        this.function = function;
        this.fieldName = fieldName;
        this.byFieldName = byFieldName;
        this.overFieldName = overFieldName;
        this.partitionFieldName = partitionFieldName;
        this.useNull = useNull;
        this.excludeFrequent = excludeFrequent;
        this.rules = Collections.unmodifiableList(rules);
        this.detectorDescription = detectorDescription != null ? detectorDescription : DefaultDetectorDescription.of(this);
        this.detectorIndex = detectorIndex;
    }

    public String getDetectorDescription() {
        return this.detectorDescription;
    }

    public DetectorFunction getFunction() {
        return this.function;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getByFieldName() {
        return this.byFieldName;
    }

    public String getOverFieldName() {
        return this.overFieldName;
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public boolean isUseNull() {
        return this.useNull;
    }

    public ExcludeFrequent getExcludeFrequent() {
        return this.excludeFrequent;
    }

    public List<DetectionRule> getRules() {
        return this.rules;
    }

    public int getDetectorIndex() {
        return this.detectorIndex;
    }

    public List<String> extractAnalysisFields() {
        List<String> analysisFields = Arrays.asList(this.getByFieldName(), this.getOverFieldName(), this.getPartitionFieldName());
        return analysisFields.stream().filter(item -> item != null).collect(Collectors.toList());
    }

    public Set<String> extractReferencedFilters() {
        return this.rules == null ? Collections.emptySet() : this.rules.stream().map(DetectionRule::extractReferencedFilters).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<String> getByOverPartitionTerms() {
        HashSet<String> terms = new HashSet<String>();
        if (this.byFieldName != null) {
            terms.add(this.byFieldName);
        }
        if (this.overFieldName != null) {
            terms.add(this.overFieldName);
        }
        if (this.partitionFieldName != null) {
            terms.add(this.partitionFieldName);
        }
        return terms;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Detector)) {
            return false;
        }
        Detector that = (Detector)other;
        return Objects.equals(this.detectorDescription, that.detectorDescription) && Objects.equals((Object)this.function, (Object)that.function) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.byFieldName, that.byFieldName) && Objects.equals(this.overFieldName, that.overFieldName) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.useNull, that.useNull) && Objects.equals((Object)this.excludeFrequent, (Object)that.excludeFrequent) && Objects.equals(this.rules, that.rules) && this.detectorIndex == that.detectorIndex;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.detectorDescription, this.function, this.fieldName, this.byFieldName, this.overFieldName, this.partitionFieldName, this.useNull, this.excludeFrequent, this.rules, this.detectorIndex});
    }

    public static enum ExcludeFrequent implements Writeable
    {
        ALL,
        NONE,
        BY,
        OVER;


        public static ExcludeFrequent forString(String value) {
            return ExcludeFrequent.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static ExcludeFrequent readFromStream(StreamInput in) throws IOException {
            return (ExcludeFrequent)in.readEnum(ExcludeFrequent.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private String detectorDescription;
        private DetectorFunction function;
        private String fieldName;
        private String byFieldName;
        private String overFieldName;
        private String partitionFieldName;
        private boolean useNull = false;
        private ExcludeFrequent excludeFrequent;
        private List<DetectionRule> rules = Collections.emptyList();
        private int detectorIndex = -1;

        public Builder() {
        }

        public Builder(Detector detector) {
            this.detectorDescription = detector.detectorDescription;
            this.function = detector.function;
            this.fieldName = detector.fieldName;
            this.byFieldName = detector.byFieldName;
            this.overFieldName = detector.overFieldName;
            this.partitionFieldName = detector.partitionFieldName;
            this.useNull = detector.useNull;
            this.excludeFrequent = detector.excludeFrequent;
            this.rules = new ArrayList<DetectionRule>(detector.rules);
            this.detectorIndex = detector.detectorIndex;
        }

        public Builder(String function, String fieldName) {
            this(DetectorFunction.fromString(function), fieldName);
        }

        public Builder(DetectorFunction function, String fieldName) {
            this.function = function;
            this.fieldName = fieldName;
        }

        public Builder setDetectorDescription(String detectorDescription) {
            this.detectorDescription = detectorDescription;
            return this;
        }

        public Builder setFunction(String function) {
            this.function = DetectorFunction.fromString(function);
            return this;
        }

        public Builder setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder setByFieldName(String byFieldName) {
            this.byFieldName = byFieldName;
            return this;
        }

        public Builder setOverFieldName(String overFieldName) {
            this.overFieldName = overFieldName;
            return this;
        }

        public Builder setPartitionFieldName(String partitionFieldName) {
            this.partitionFieldName = partitionFieldName;
            return this;
        }

        public Builder setUseNull(boolean useNull) {
            this.useNull = useNull;
            return this;
        }

        public Builder setExcludeFrequent(ExcludeFrequent excludeFrequent) {
            this.excludeFrequent = excludeFrequent;
            return this;
        }

        public Builder setRules(List<DetectionRule> rules) {
            this.rules = rules;
            return this;
        }

        public Builder setDetectorIndex(int detectorIndex) {
            this.detectorIndex = detectorIndex;
            return this;
        }

        public Detector build() {
            String[] fields;
            boolean emptyField = Strings.isEmpty((CharSequence)this.fieldName);
            boolean emptyByField = Strings.isEmpty((CharSequence)this.byFieldName);
            boolean emptyOverField = Strings.isEmpty((CharSequence)this.overFieldName);
            boolean emptyPartitionField = Strings.isEmpty((CharSequence)this.partitionFieldName);
            if (emptyField && emptyByField && emptyOverField && !COUNT_WITHOUT_FIELD_FUNCTIONS.contains((Object)this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Unless a count or temporal function is used one of field_name, by_field_name or over_field_name must be set"), new Object[0]);
            }
            if (emptyField && FIELD_NAME_FUNCTIONS.contains((Object)this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("field_name must be set when the ''{0}'' function is used", new Object[]{this.function}), new Object[0]);
            }
            if (!emptyField && !FIELD_NAME_FUNCTIONS.contains((Object)this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("field_name cannot be used with function ''{0}''", new Object[]{this.function}), new Object[0]);
            }
            if (emptyByField && BY_FIELD_NAME_FUNCTIONS.contains((Object)this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("by_field_name must be set when the ''{0}'' function is used", new Object[]{this.function}), new Object[0]);
            }
            if (emptyOverField && OVER_FIELD_NAME_FUNCTIONS.contains((Object)this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("over_field_name must be set when the ''{0}'' function is used", new Object[]{this.function}), new Object[0]);
            }
            if (!emptyOverField && NO_OVER_FIELD_NAME_FUNCTIONS.contains((Object)this.function)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("over_field_name cannot be used with function ''{0}''", new Object[]{this.function}), new Object[0]);
            }
            for (String field : fields = new String[]{this.fieldName, this.byFieldName, this.overFieldName, this.partitionFieldName}) {
                Builder.verifyFieldName(field);
            }
            DetectorFunction detectorFunction = this.function == null ? DetectorFunction.METRIC : this.function;
            for (DetectionRule rule : this.rules) {
                this.validateRule(rule, detectorFunction);
            }
            if (!emptyPartitionField) {
                if (this.partitionFieldName.equals(this.byFieldName)) {
                    throw ExceptionsHelper.badRequestException(Messages.getMessage("{0} and {1} cannot be the same: ''{2}''", PARTITION_FIELD_NAME_FIELD.getPreferredName(), BY_FIELD_NAME_FIELD.getPreferredName(), this.partitionFieldName), new Object[0]);
                }
                if (this.partitionFieldName.equals(this.overFieldName)) {
                    throw ExceptionsHelper.badRequestException(Messages.getMessage("{0} and {1} cannot be the same: ''{2}''", PARTITION_FIELD_NAME_FIELD.getPreferredName(), OVER_FIELD_NAME_FIELD.getPreferredName(), this.partitionFieldName), new Object[0]);
                }
            }
            if (!emptyByField && this.byFieldName.equals(this.overFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("{0} and {1} cannot be the same: ''{2}''", BY_FIELD_NAME_FIELD.getPreferredName(), OVER_FIELD_NAME_FIELD.getPreferredName(), this.byFieldName), new Object[0]);
            }
            if (DetectorFunction.COUNT.getFullName().equals(this.byFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''count'' is not a permitted value for {0}", BY_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            if (DetectorFunction.COUNT.getFullName().equals(this.overFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''count'' is not a permitted value for {0}", OVER_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            if (Detector.BY.equals(this.byFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''by'' is not a permitted value for {0}", BY_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            if (Detector.BY.equals(this.overFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''by'' is not a permitted value for {0}", OVER_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            if (Detector.OVER.equals(this.byFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''over'' is not a permitted value for {0}", BY_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            if (Detector.OVER.equals(this.overFieldName)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("''over'' is not a permitted value for {0}", OVER_FIELD_NAME_FIELD.getPreferredName()), new Object[0]);
            }
            return new Detector(this.detectorDescription, detectorFunction, this.fieldName, this.byFieldName, this.overFieldName, this.partitionFieldName, this.useNull, this.excludeFrequent, this.rules, this.detectorIndex);
        }

        public List<String> extractAnalysisFields() {
            List<String> analysisFields = Arrays.asList(this.byFieldName, this.overFieldName, this.partitionFieldName);
            return analysisFields.stream().filter(item -> item != null).collect(Collectors.toList());
        }

        public static void verifyFieldName(String field) throws ElasticsearchParseException {
            if (field != null && Builder.containsInvalidChar(field)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid field name ''{0}''. Field names including over, by and partition fields cannot contain any of these characters: {1}", field, PROHIBITED), new Object[0]);
            }
            if (".".equals(field)) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Invalid field name ''{0}''. Field names including over, by and partition fields cannot be ''{1}''", field, "."), new Object[0]);
            }
        }

        private static boolean containsInvalidChar(String field) {
            for (Character ch : PROHIBITED_FIELDNAME_CHARACTERS) {
                if (field.indexOf(ch.charValue()) < 0) continue;
                return true;
            }
            return field.chars().anyMatch(Character::isISOControl);
        }

        private void validateRule(DetectionRule rule, DetectorFunction detectorFunction) {
            this.checkFunctionHasRuleSupport(rule, detectorFunction);
            this.checkScoping(rule);
        }

        private void checkFunctionHasRuleSupport(DetectionRule rule, DetectorFunction detectorFunction) {
            if (Builder.ruleHasConditionOnResultValue(rule) && FUNCTIONS_WITHOUT_RULE_CONDITION_SUPPORT.contains((Object)detectorFunction)) {
                String msg = Messages.getMessage("Invalid detector rule: function {0} only supports conditions that apply to time", new Object[]{detectorFunction});
                throw ExceptionsHelper.badRequestException(msg, new Object[0]);
            }
        }

        private static boolean ruleHasConditionOnResultValue(DetectionRule rule) {
            Iterator<RuleCondition> iterator = rule.getConditions().iterator();
            if (iterator.hasNext()) {
                RuleCondition condition = iterator.next();
                return switch (condition.getAppliesTo()) {
                    default -> throw new IncompatibleClassChangeError();
                    case RuleCondition.AppliesTo.ACTUAL, RuleCondition.AppliesTo.TYPICAL, RuleCondition.AppliesTo.DIFF_FROM_TYPICAL -> true;
                    case RuleCondition.AppliesTo.TIME -> false;
                };
            }
            return false;
        }

        private void checkScoping(DetectionRule rule) {
            TreeSet<String> analysisFields = new TreeSet<String>(this.extractAnalysisFields());
            rule.getScope().validate(analysisFields);
        }
    }
}

