/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;

public class ElasticsearchMappings {
    public static final String ENABLED = "enabled";
    public static final String ANALYZER = "analyzer";
    public static final String WHITESPACE = "whitespace";
    public static final String NESTED = "nested";
    public static final String COPY_TO = "copy_to";
    public static final String PATH = "path";
    public static final String PROPERTIES = "properties";
    public static final String TYPE = "type";
    public static final String DYNAMIC = "dynamic";
    public static final String ALL_FIELD_VALUES = "all_field_values";
    public static final String ES_DOC = "_doc";
    public static final String CONFIG_TYPE = "config_type";
    public static final String BOOLEAN = "boolean";
    public static final String DATE = "date";
    public static final String DOUBLE = "double";
    public static final String INTEGER = "integer";
    public static final String KEYWORD = "keyword";
    public static final String LONG = "long";
    public static final String TEXT = "text";
    private static final Logger logger = LogManager.getLogger(ElasticsearchMappings.class);

    private ElasticsearchMappings() {
    }

    static String[] mappingRequiresUpdate(ClusterState state, String[] concreteIndices, Version minVersion) {
        ArrayList<String> indicesToUpdate = new ArrayList<String>();
        Map currentMapping = state.metadata().findMappings(concreteIndices, MapperPlugin.NOOP_FIELD_FILTER, Metadata.ON_NEXT_INDEX_FIND_MAPPINGS_NOOP);
        for (String index : concreteIndices) {
            MappingMetadata metadata = (MappingMetadata)currentMapping.get(index);
            if (metadata != null) {
                try {
                    Map meta = (Map)metadata.sourceAsMap().get("_meta");
                    if (meta != null) {
                        String versionString = (String)meta.get("version");
                        if (versionString == null) {
                            logger.info("Version of mappings for [{}] not found, recreating", (Object)index);
                            indicesToUpdate.add(index);
                            continue;
                        }
                        Version mappingVersion = Version.fromString((String)versionString);
                        if (mappingVersion.onOrAfter(minVersion)) continue;
                        logger.info("Mappings for [{}] are outdated [{}], updating it[{}].", (Object)index, (Object)mappingVersion, (Object)Version.CURRENT);
                        indicesToUpdate.add(index);
                        continue;
                    }
                    logger.info("Version of mappings for [{}] not found, recreating", (Object)index);
                    indicesToUpdate.add(index);
                }
                catch (Exception e) {
                    logger.error(() -> "Failed to retrieve mapping version for [" + index + "], recreating", (Throwable)e);
                    indicesToUpdate.add(index);
                }
                continue;
            }
            logger.info("No mappings found for [{}], recreating", (Object)index);
            indicesToUpdate.add(index);
        }
        return indicesToUpdate.toArray(new String[indicesToUpdate.size()]);
    }

    public static void addDocMappingIfMissing(String alias, final CheckedSupplier<String, IOException> mappingSupplier, final Client client, final ClusterState state, final TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        final IndexAbstraction indexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(alias);
        if (indexAbstraction == null) {
            listener.onResponse((Object)true);
            return;
        }
        ActionRunnable<Boolean> mappingCheck = new ActionRunnable<Boolean>(listener){

            protected void doRun() throws Exception {
                String[] concreteIndices = (String[])indexAbstraction.getIndices().stream().map(Index::getName).toArray(String[]::new);
                String[] indicesThatRequireAnUpdate = ElasticsearchMappings.mappingRequiresUpdate(state, concreteIndices, Version.CURRENT);
                if (indicesThatRequireAnUpdate.length > 0) {
                    String mapping = (String)mappingSupplier.get();
                    PutMappingRequest putMappingRequest = new PutMappingRequest(indicesThatRequireAnUpdate);
                    putMappingRequest.source(mapping, XContentType.JSON);
                    putMappingRequest.origin("ml");
                    putMappingRequest.masterNodeTimeout(masterNodeTimeout);
                    ClientHelper.executeAsyncWithOrigin(client, "ml", PutMappingAction.INSTANCE, putMappingRequest, ActionListener.wrap(response -> {
                        if (response.isAcknowledged()) {
                            this.listener.onResponse((Object)true);
                        } else {
                            this.listener.onFailure((Exception)new ElasticsearchException("Attempt to put missing mapping in indices " + Arrays.toString(indicesThatRequireAnUpdate) + " was not acknowledged", new Object[0]));
                        }
                    }, arg_0 -> ((ActionListener)this.listener).onFailure(arg_0)));
                } else {
                    logger.trace("Mappings are up to date.");
                    this.listener.onResponse((Object)true);
                }
            }
        };
        if (Transports.isTransportThread((Thread)Thread.currentThread())) {
            client.threadPool().executor("management").execute((Runnable)mappingCheck);
        } else {
            mappingCheck.run();
        }
    }
}

