/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;

public abstract class NameResolver {
    private final Function<String, ResourceNotFoundException> notFoundExceptionSupplier;

    protected NameResolver(Function<String, ResourceNotFoundException> notFoundExceptionSupplier) {
        this.notFoundExceptionSupplier = Objects.requireNonNull(notFoundExceptionSupplier);
    }

    public SortedSet<String> expand(String expression, boolean allowNoMatch) {
        return this.expand(expression, allowNoMatch, Optional.empty());
    }

    public SortedSet<String> expand(String expression, boolean allowNoMatch, Optional<String> tokenizationDelimiter) {
        TreeSet<String> result = new TreeSet<String>();
        if (Strings.isAllOrWildcard((String)expression)) {
            result.addAll(this.nameSet());
        } else {
            String[] tokens;
            String[] stringArray;
            if (tokenizationDelimiter.isPresent()) {
                stringArray = Strings.tokenizeToStringArray((String)expression, (String)tokenizationDelimiter.get());
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = expression;
            }
            for (String token : tokens = stringArray) {
                if (Regex.isSimpleMatchPattern((String)token)) {
                    List expanded = this.keys().stream().filter(key -> Regex.simpleMatch((String)token, (String)key)).map(this::lookup).flatMap(Collection::stream).collect(Collectors.toList());
                    if (expanded.isEmpty() && !allowNoMatch) {
                        throw this.notFoundExceptionSupplier.apply(token);
                    }
                    result.addAll(expanded);
                    continue;
                }
                List<String> matchingNames = this.lookup(token);
                if (matchingNames.isEmpty()) {
                    throw this.notFoundExceptionSupplier.apply(token);
                }
                result.addAll(matchingNames);
            }
        }
        if (result.isEmpty() && !allowNoMatch) {
            throw this.notFoundExceptionSupplier.apply(expression);
        }
        return result;
    }

    protected abstract Set<String> keys();

    protected abstract Set<String> nameSet();

    protected abstract List<String> lookup(String var1);

    public static NameResolver newUnaliased(final Set<String> nameSet, Function<String, ResourceNotFoundException> notFoundExceptionSupplier) {
        return new NameResolver(notFoundExceptionSupplier){

            @Override
            protected Set<String> keys() {
                return nameSet;
            }

            @Override
            protected Set<String> nameSet() {
                return nameSet;
            }

            @Override
            protected List<String> lookup(String key) {
                return nameSet.contains(key) ? Collections.singletonList(key) : Collections.emptyList();
            }
        };
    }
}

