/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RollupShardStatus
implements Task.Status {
    public static final String NAME = "rollup-index-shard";
    private static final ParseField SHARD_FIELD = new ParseField("shard", new String[0]);
    private static final ParseField START_TIME_FIELD = new ParseField("start_time", new String[0]);
    private static final ParseField IN_NUM_DOCS_RECEIVED_FIELD = new ParseField("in_num_docs_received", new String[0]);
    private static final ParseField OUT_NUM_DOCS_SENT_FIELD = new ParseField("out_num_docs_sent", new String[0]);
    private static final ParseField OUT_NUM_DOCS_INDEXED_FIELD = new ParseField("out_num_docs_indexed", new String[0]);
    private static final ParseField OUT_NUM_DOCS_FAILED_FIELD = new ParseField("out_num_docs_failed", new String[0]);
    private final ShardId shardId;
    private final long rollupStart;
    private final long numReceived;
    private final long numSent;
    private final long numIndexed;
    private final long numFailed;
    private static final ConstructingObjectParser<RollupShardStatus, Void> PARSER = new ConstructingObjectParser("rollup-index-shard", args -> new RollupShardStatus(ShardId.fromString((String)((String)args[0])), Instant.parse((String)args[1]).toEpochMilli(), (Long)args[2], (Long)args[3], (Long)args[4], (Long)args[5]));

    public RollupShardStatus(StreamInput in) throws IOException {
        this.shardId = new ShardId(in);
        this.rollupStart = in.readLong();
        this.numReceived = in.readLong();
        this.numSent = in.readLong();
        this.numIndexed = in.readLong();
        this.numFailed = in.readLong();
    }

    public RollupShardStatus(ShardId shardId, long rollupStart, long numReceived, long numSent, long numIndexed, long numFailed) {
        this.shardId = shardId;
        this.rollupStart = rollupStart;
        this.numReceived = numReceived;
        this.numSent = numSent;
        this.numIndexed = numIndexed;
        this.numFailed = numFailed;
    }

    public static RollupShardStatus fromXContent(XContentParser parser) throws IOException {
        return (RollupShardStatus)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SHARD_FIELD.getPreferredName(), (ToXContent)this.shardId);
        builder.field(START_TIME_FIELD.getPreferredName(), Instant.ofEpochMilli(this.rollupStart).toString());
        builder.field(IN_NUM_DOCS_RECEIVED_FIELD.getPreferredName(), this.numReceived);
        builder.field(OUT_NUM_DOCS_SENT_FIELD.getPreferredName(), this.numSent);
        builder.field(OUT_NUM_DOCS_INDEXED_FIELD.getPreferredName(), this.numIndexed);
        builder.field(OUT_NUM_DOCS_FAILED_FIELD.getPreferredName(), this.numFailed);
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeLong(this.rollupStart);
        out.writeLong(this.numReceived);
        out.writeLong(this.numSent);
        out.writeLong(this.numIndexed);
        out.writeLong(this.numFailed);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollupShardStatus that = (RollupShardStatus)o;
        return this.rollupStart == that.rollupStart && Objects.equals(this.shardId.getIndexName(), that.shardId.getIndexName()) && Objects.equals(this.shardId.id(), that.shardId.id()) && Objects.equals(this.numReceived, that.numReceived) && Objects.equals(this.numSent, that.numSent) && Objects.equals(this.numIndexed, that.numIndexed) && Objects.equals(this.numFailed, that.numFailed);
    }

    public int hashCode() {
        return Objects.hash(this.shardId.getIndexName(), this.shardId.id(), this.rollupStart, this.numReceived, this.numSent, this.numIndexed, this.numFailed);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SHARD_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), START_TIME_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), IN_NUM_DOCS_RECEIVED_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), OUT_NUM_DOCS_SENT_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), OUT_NUM_DOCS_INDEXED_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), OUT_NUM_DOCS_FAILED_FIELD);
    }
}

