/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.downsample.DownsampleConfig;
import org.elasticsearch.xpack.core.rollup.action.RollupShardStatus;

public class RollupShardTask
extends CancellableTask {
    private final String rollupIndex;
    private final DownsampleConfig config;
    private final ShardId shardId;
    private final long rollupStartTime;
    private final AtomicLong numReceived = new AtomicLong(0L);
    private final AtomicLong numSent = new AtomicLong(0L);
    private final AtomicLong numIndexed = new AtomicLong(0L);
    private final AtomicLong numFailed = new AtomicLong(0L);

    public RollupShardTask(long id, String type, String action, TaskId parentTask, String rollupIndex, DownsampleConfig config, Map<String, String> headers, ShardId shardId) {
        super(id, type, action, "rollup_" + rollupIndex + "[" + shardId.id() + "]", parentTask, headers);
        this.rollupIndex = rollupIndex;
        this.config = config;
        this.shardId = shardId;
        this.rollupStartTime = System.currentTimeMillis();
    }

    public String getRollupIndex() {
        return this.rollupIndex;
    }

    public DownsampleConfig config() {
        return this.config;
    }

    public Task.Status getStatus() {
        return new RollupShardStatus(this.shardId, this.rollupStartTime, this.numReceived.get(), this.numSent.get(), this.numIndexed.get(), this.numFailed.get());
    }

    public long getNumReceived() {
        return this.numReceived.get();
    }

    public long getNumSent() {
        return this.numSent.get();
    }

    public long getNumIndexed() {
        return this.numIndexed.get();
    }

    public long getNumFailed() {
        return this.numFailed.get();
    }

    public void addNumReceived(long count) {
        this.numReceived.addAndGet(count);
    }

    public void addNumSent(long count) {
        this.numSent.addAndGet(count);
    }

    public void addNumIndexed(long count) {
        this.numIndexed.addAndGet(count);
    }

    public void addNumFailed(long count) {
        this.numFailed.addAndGet(count);
    }
}

