/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.searchablesnapshots;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class MountSearchableSnapshotRequest
extends MasterNodeRequest<MountSearchableSnapshotRequest> {
    public static final ConstructingObjectParser<MountSearchableSnapshotRequest, RestRequest> PARSER = new ConstructingObjectParser("mount_searchable_snapshot", false, (a, request) -> new MountSearchableSnapshotRequest(Objects.requireNonNullElse((String)a[1], (String)a[0]), Objects.requireNonNull(request.param("repository")), Objects.requireNonNull(request.param("snapshot")), (String)a[0], Objects.requireNonNullElse((Settings)a[2], Settings.EMPTY), Objects.requireNonNullElse((String[])a[3], Strings.EMPTY_ARRAY), request.paramAsBoolean("wait_for_completion", false), Storage.valueOf(request.param("storage", Storage.FULL_COPY.toString()).toUpperCase(Locale.ROOT))));
    private static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
    private static final ParseField RENAMED_INDEX_FIELD = new ParseField("renamed_index", new String[0]);
    private static final ParseField INDEX_SETTINGS_FIELD = new ParseField("index_settings", new String[0]);
    private static final ParseField IGNORE_INDEX_SETTINGS_FIELD = new ParseField("ignore_index_settings", new String[0]);
    @Deprecated
    private static final ParseField IGNORED_INDEX_SETTINGS_FIELD = new ParseField("ignored_index_settings", new String[0]);
    private static final TransportVersion SHARED_CACHE_VERSION;
    private final String mountedIndexName;
    private final String repositoryName;
    private final String snapshotName;
    private final String snapshotIndexName;
    private final Settings indexSettings;
    private final String[] ignoreIndexSettings;
    private final boolean waitForCompletion;
    private final Storage storage;

    public MountSearchableSnapshotRequest(String mountedIndexName, String repositoryName, String snapshotName, String snapshotIndexName, Settings indexSettings, String[] ignoreIndexSettings, boolean waitForCompletion, Storage storage) {
        this.mountedIndexName = Objects.requireNonNull(mountedIndexName);
        this.repositoryName = Objects.requireNonNull(repositoryName);
        this.snapshotName = Objects.requireNonNull(snapshotName);
        this.snapshotIndexName = Objects.requireNonNull(snapshotIndexName);
        this.indexSettings = Objects.requireNonNull(indexSettings);
        this.ignoreIndexSettings = Objects.requireNonNull(ignoreIndexSettings);
        this.waitForCompletion = waitForCompletion;
        this.storage = storage;
    }

    public MountSearchableSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.mountedIndexName = in.readString();
        this.repositoryName = in.readString();
        this.snapshotName = in.readString();
        this.snapshotIndexName = in.readString();
        this.indexSettings = Settings.readSettingsFromStream((StreamInput)in);
        this.ignoreIndexSettings = in.readStringArray();
        this.waitForCompletion = in.readBoolean();
        this.storage = in.getTransportVersion().onOrAfter(SHARED_CACHE_VERSION) ? Storage.readFromStream(in) : Storage.FULL_COPY;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.mountedIndexName);
        out.writeString(this.repositoryName);
        out.writeString(this.snapshotName);
        out.writeString(this.snapshotIndexName);
        this.indexSettings.writeTo(out);
        out.writeStringArray(this.ignoreIndexSettings);
        out.writeBoolean(this.waitForCompletion);
        if (out.getTransportVersion().onOrAfter(SHARED_CACHE_VERSION)) {
            this.storage.writeTo(out);
        } else if (this.storage != Storage.FULL_COPY) {
            throw new UnsupportedOperationException("storage type [" + this.storage + "] is not supported on version [" + out.getTransportVersion() + "]");
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (IndexMetadata.INDEX_DATA_PATH_SETTING.exists(this.indexSettings)) {
            validationException = ValidateActions.addValidationError((String)"setting [index.data_path] is not permitted on searchable snapshots", validationException);
        }
        return validationException;
    }

    public String mountedIndexName() {
        return this.mountedIndexName;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String snapshotIndexName() {
        return this.snapshotIndexName;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public Settings indexSettings() {
        return this.indexSettings;
    }

    public String[] ignoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    public Storage storage() {
        return this.storage;
    }

    public String getDescription() {
        return "mount snapshot [" + this.repositoryName + ":" + this.snapshotName + ":" + this.snapshotIndexName + "] as [" + this.mountedIndexName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MountSearchableSnapshotRequest that = (MountSearchableSnapshotRequest)((Object)o);
        return this.waitForCompletion == that.waitForCompletion && this.storage == that.storage && Objects.equals(this.mountedIndexName, that.mountedIndexName) && Objects.equals(this.repositoryName, that.repositoryName) && Objects.equals(this.snapshotName, that.snapshotName) && Objects.equals(this.snapshotIndexName, that.snapshotIndexName) && Objects.equals(this.indexSettings, that.indexSettings) && Arrays.equals(this.ignoreIndexSettings, that.ignoreIndexSettings) && Objects.equals(this.masterNodeTimeout, that.masterNodeTimeout);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.mountedIndexName, this.repositoryName, this.snapshotName, this.snapshotIndexName, this.indexSettings, this.waitForCompletion, this.masterNodeTimeout, this.storage});
        result = 31 * result + Arrays.hashCode(this.ignoreIndexSettings);
        return result;
    }

    public String toString() {
        return this.getDescription();
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), XContentParser::text, INDEX_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), XContentParser::text, RENAMED_INDEX_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), Settings::fromXContent, INDEX_SETTINGS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.list().stream().map(s -> (String)s).collect(Collectors.toList()).toArray(Strings.EMPTY_ARRAY), IGNORE_INDEX_SETTINGS_FIELD, ObjectParser.ValueType.STRING_ARRAY);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            p.skipChildren();
            return Strings.EMPTY_ARRAY;
        }, IGNORED_INDEX_SETTINGS_FIELD, ObjectParser.ValueType.STRING_ARRAY);
        SHARED_CACHE_VERSION = TransportVersion.V_7_12_0;
    }

    public static enum Storage implements Writeable
    {
        FULL_COPY(String.join((CharSequence)",", "data_cold", "data_warm", "data_hot")),
        SHARED_CACHE("data_frozen");

        private final String defaultDataTiersPreference;

        private Storage(String defaultDataTiersPreference) {
            this.defaultDataTiersPreference = defaultDataTiersPreference;
        }

        public String defaultDataTiersPreference() {
            return this.defaultDataTiersPreference;
        }

        public static Storage fromString(String type) {
            if ("full_copy".equals(type)) {
                return FULL_COPY;
            }
            if ("shared_cache".equals(type)) {
                return SHARED_CACHE;
            }
            throw new IllegalArgumentException("unknown searchable snapshot storage type [" + type + "], valid types are: " + Strings.arrayToCommaDelimitedString((Object[])Storage.values()));
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static Storage readFromStream(StreamInput in) throws IOException {
            return (Storage)in.readEnum(Storage.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }
    }
}

