/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.action.role.RoleDescriptorRequestValidator;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public final class CreateApiKeyRequest
extends ActionRequest {
    public static final WriteRequest.RefreshPolicy DEFAULT_REFRESH_POLICY = WriteRequest.RefreshPolicy.WAIT_UNTIL;
    private final String id;
    private String name;
    private TimeValue expiration;
    private Map<String, Object> metadata;
    private List<RoleDescriptor> roleDescriptors = Collections.emptyList();
    private WriteRequest.RefreshPolicy refreshPolicy = DEFAULT_REFRESH_POLICY;

    public CreateApiKeyRequest() {
        this.id = UUIDs.base64UUID();
    }

    public CreateApiKeyRequest(String name, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable TimeValue expiration) {
        this(name, roleDescriptors, expiration, null);
    }

    public CreateApiKeyRequest(String name, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable TimeValue expiration, @Nullable Map<String, Object> metadata) {
        this();
        this.name = name;
        this.roleDescriptors = roleDescriptors == null ? List.of() : List.copyOf(roleDescriptors);
        this.expiration = expiration;
        this.metadata = metadata;
    }

    public CreateApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.getTransportVersion().onOrAfter(TransportVersion.V_7_10_0) ? in.readString() : UUIDs.base64UUID();
        this.name = in.getTransportVersion().onOrAfter(TransportVersion.V_7_5_0) ? in.readOptionalString() : in.readString();
        this.expiration = in.readOptionalTimeValue();
        this.roleDescriptors = in.readImmutableList(RoleDescriptor::new);
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
        this.metadata = in.getTransportVersion().onOrAfter(TransportVersion.V_8_0_0) ? in.readMap() : null;
    }

    public String getId() {
        return this.id;
    }

    public void setId() {
        throw new UnsupportedOperationException("The API Key Id cannot be set, it must be generated randomly");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TimeValue getExpiration() {
        return this.expiration;
    }

    public void setExpiration(@Nullable TimeValue expiration) {
        this.expiration = expiration;
    }

    public List<RoleDescriptor> getRoleDescriptors() {
        return this.roleDescriptors;
    }

    public void setRoleDescriptors(@Nullable List<RoleDescriptor> roleDescriptors) {
        this.roleDescriptors = roleDescriptors == null ? List.of() : List.copyOf(roleDescriptors);
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = Objects.requireNonNull(refreshPolicy, "refresh policy may not be null");
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.name)) {
            validationException = ValidateActions.addValidationError((String)"api key name is required", validationException);
        } else {
            if (this.name.length() > 256) {
                validationException = ValidateActions.addValidationError((String)"api key name may not be more than 256 characters long", (ActionRequestValidationException)validationException);
            }
            if (!this.name.equals(this.name.trim())) {
                validationException = ValidateActions.addValidationError((String)"api key name may not begin or end with whitespace", (ActionRequestValidationException)validationException);
            }
            if (this.name.startsWith("_")) {
                validationException = ValidateActions.addValidationError((String)"api key name may not begin with an underscore", (ActionRequestValidationException)validationException);
            }
        }
        if (this.metadata != null && MetadataUtils.containsReservedMetadata(this.metadata)) {
            validationException = ValidateActions.addValidationError((String)"API key metadata keys may not start with [_]", (ActionRequestValidationException)validationException);
        }
        for (RoleDescriptor roleDescriptor : this.roleDescriptors) {
            validationException = RoleDescriptorRequestValidator.validate(roleDescriptor, validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_10_0)) {
            out.writeString(this.id);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_5_0)) {
            out.writeOptionalString(this.name);
        } else {
            out.writeString(this.name);
        }
        out.writeOptionalTimeValue(this.expiration);
        out.writeList(this.roleDescriptors);
        this.refreshPolicy.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_13_0)) {
            out.writeGenericMap(this.metadata);
        }
    }
}

