/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Assertions;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.RealmDomain;
import org.elasticsearch.xpack.core.security.authc.RemoteAccessAuthentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.AsyncSearchUser;
import org.elasticsearch.xpack.core.security.user.SecurityProfileUser;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackSecurityUser;
import org.elasticsearch.xpack.core.security.user.XPackUser;

public final class Authentication
implements ToXContentObject {
    private static final Logger logger = LogManager.getLogger(Authentication.class);
    private static final TransportVersion VERSION_AUTHENTICATION_TYPE = TransportVersion.fromId((int)6070099);
    public static final TransportVersion VERSION_REMOTE_ACCESS_REALM = TransportVersion.V_8_7_0;
    public static final TransportVersion VERSION_API_KEY_ROLES_AS_BYTES = TransportVersion.V_7_9_0;
    public static final TransportVersion VERSION_REALM_DOMAINS = TransportVersion.V_8_2_0;
    private final AuthenticationType type;
    private final Subject authenticatingSubject;
    private final Subject effectiveSubject;
    public static ConstructingObjectParser<RealmRef, Void> REALM_REF_PARSER = new ConstructingObjectParser("realm_ref", false, (args, v) -> new RealmRef((String)args[0], (String)args[1], (String)args[2], (RealmDomain)args[3]));

    private Authentication(Subject subject, AuthenticationType type) {
        this(subject, subject, type);
    }

    private Authentication(Subject effectiveSubject, Subject authenticatingSubject, AuthenticationType type) {
        this.effectiveSubject = effectiveSubject;
        this.authenticatingSubject = authenticatingSubject;
        this.type = type;
        this.assertInternalConsistency();
    }

    public Authentication(StreamInput in) throws IOException {
        Map metadata;
        User innerUser;
        User outerUser = AuthenticationSerializationHelper.readUserWithoutTrailingBoolean(in);
        boolean hasInnerUser = User.isInternal(outerUser) ? false : in.readBoolean();
        if (hasInnerUser) {
            innerUser = AuthenticationSerializationHelper.readUserFrom(in);
            assert (!User.isInternal(innerUser)) : "internal users cannot participate in run-as";
        } else {
            innerUser = null;
        }
        RealmRef authenticatedBy = new RealmRef(in);
        RealmRef lookedUpBy = in.readBoolean() ? new RealmRef(in) : null;
        assert (innerUser != null || lookedUpBy == null) : "Authentication has no inner-user, but looked-up-by is [" + lookedUpBy + "]";
        TransportVersion version = in.getTransportVersion();
        if (version.onOrAfter(VERSION_AUTHENTICATION_TYPE)) {
            this.type = AuthenticationType.values()[in.readVInt()];
            metadata = in.readMap();
        } else {
            this.type = AuthenticationType.REALM;
            metadata = Map.of();
        }
        if (innerUser != null) {
            this.authenticatingSubject = new Subject(innerUser, authenticatedBy, version, metadata);
            this.effectiveSubject = new Subject(outerUser, lookedUpBy, version, Map.of());
        } else {
            this.authenticatingSubject = this.effectiveSubject = new Subject(outerUser, authenticatedBy, version, metadata);
        }
        this.assertInternalConsistency();
    }

    public Subject getAuthenticatingSubject() {
        return this.authenticatingSubject;
    }

    public Subject getEffectiveSubject() {
        return this.effectiveSubject;
    }

    public AuthenticationType getAuthenticationType() {
        return this.type;
    }

    public boolean isRunAs() {
        return this.authenticatingSubject != this.effectiveSubject;
    }

    public boolean isFailedRunAs() {
        return this.isRunAs() && this.effectiveSubject.getRealm() == null;
    }

    public Authentication maybeRewriteForOlderVersion(TransportVersion olderVersion) {
        return this.maybeRewriteForOlderVersion(olderVersion, VERSION_REMOTE_ACCESS_REALM);
    }

    Authentication maybeRewriteForOlderVersion(TransportVersion olderVersion, TransportVersion remoteAccessRealmVersion) {
        if (this.isRemoteAccess() && olderVersion.before(remoteAccessRealmVersion)) {
            throw new IllegalArgumentException("versions of Elasticsearch before [" + remoteAccessRealmVersion + "] can't handle remote access authentication and attempted to rewrite for [" + olderVersion + "]");
        }
        Map<String, Object> newMetadata = Authentication.maybeRewriteMetadata(olderVersion, this);
        Authentication newAuthentication = this.isRunAs() ? new Authentication(new Subject(this.effectiveSubject.getUser(), Authentication.maybeRewriteRealmRef(olderVersion, this.effectiveSubject.getRealm()), olderVersion, this.effectiveSubject.getMetadata()), new Subject(this.authenticatingSubject.getUser(), Authentication.maybeRewriteRealmRef(olderVersion, this.authenticatingSubject.getRealm()), olderVersion, newMetadata), this.type) : new Authentication(new Subject(this.authenticatingSubject.getUser(), Authentication.maybeRewriteRealmRef(olderVersion, this.authenticatingSubject.getRealm()), olderVersion, newMetadata), this.type);
        return newAuthentication;
    }

    private static Map<String, Object> maybeRewriteMetadata(TransportVersion olderVersion, Authentication authentication) {
        if (authentication.isAuthenticatedAsApiKey()) {
            return Authentication.maybeRewriteMetadataForApiKeyRoleDescriptors(olderVersion, authentication);
        }
        if (authentication.isRemoteAccess()) {
            return Authentication.maybeRewriteMetadataForRemoteAccessAuthentication(olderVersion, authentication);
        }
        return authentication.getAuthenticatingSubject().getMetadata();
    }

    public Authentication runAs(User runAs, @Nullable RealmRef lookupRealmRef) {
        assert (this.supportsRunAs(null));
        assert (!(runAs instanceof AnonymousUser));
        assert (!this.hasSyntheticRealmNameOrType(lookupRealmRef)) : "should not use synthetic realm name/type for lookup realms";
        Objects.requireNonNull(runAs);
        return new Authentication(new Subject(runAs, lookupRealmRef, this.getEffectiveSubject().getTransportVersion(), Map.of()), this.authenticatingSubject, this.type);
    }

    public Authentication token() {
        assert (!this.isServiceAccount());
        assert (!this.isRemoteAccess());
        Authentication newTokenAuthentication = new Authentication(this.effectiveSubject, this.authenticatingSubject, AuthenticationType.TOKEN);
        return newTokenAuthentication;
    }

    public Authentication maybeAddAnonymousRoles(@Nullable AnonymousUser anonymousUser) {
        boolean shouldAddAnonymousRoleNames;
        boolean bl = shouldAddAnonymousRoleNames = anonymousUser != null && anonymousUser.enabled() && false == anonymousUser.equals(this.getEffectiveSubject().getUser()) && false == User.isInternal(this.getEffectiveSubject().getUser()) && false == this.isApiKey() && false == this.isRemoteAccess() && false == this.isServiceAccount();
        if (!shouldAddAnonymousRoleNames) {
            return this;
        }
        if (anonymousUser.roles().length == 0) {
            throw new IllegalStateException("anonymous is only enabled when the anonymous user has roles");
        }
        String[] allRoleNames = ArrayUtils.concat((String[])this.getEffectiveSubject().getUser().roles(), (String[])anonymousUser.roles());
        if (this.isRunAs()) {
            User user = this.effectiveSubject.getUser();
            return new Authentication(new Subject(new User(user.principal(), allRoleNames, user.fullName(), user.email(), user.metadata(), user.enabled()), this.effectiveSubject.getRealm(), this.effectiveSubject.getTransportVersion(), this.effectiveSubject.getMetadata()), this.authenticatingSubject, this.type);
        }
        User user = this.authenticatingSubject.getUser();
        return new Authentication(new Subject(new User(user.principal(), allRoleNames, user.fullName(), user.email(), user.metadata(), user.enabled()), this.authenticatingSubject.getRealm(), this.authenticatingSubject.getTransportVersion(), this.authenticatingSubject.getMetadata()), this.type);
    }

    boolean isAssignedToDomain() {
        return this.getDomain() != null;
    }

    @Nullable
    RealmDomain getDomain() {
        if (this.isFailedRunAs()) {
            return null;
        }
        return this.getEffectiveSubject().getRealm().getDomain();
    }

    public boolean isAuthenticatedWithServiceAccount() {
        return "_service_account".equals(this.getAuthenticatingSubject().getRealm().getType());
    }

    public boolean isAuthenticatedAsApiKey() {
        return this.authenticatingSubject.getType() == Subject.Type.API_KEY;
    }

    private boolean isAuthenticatedAnonymously() {
        return AuthenticationType.ANONYMOUS.equals((Object)this.getAuthenticationType());
    }

    private boolean isAuthenticatedInternally() {
        return AuthenticationType.INTERNAL.equals((Object)this.getAuthenticationType());
    }

    public boolean isServiceAccount() {
        return this.effectiveSubject.getType() == Subject.Type.SERVICE_ACCOUNT;
    }

    public boolean isApiKey() {
        return this.effectiveSubject.getType() == Subject.Type.API_KEY;
    }

    public boolean isRemoteAccess() {
        return this.effectiveSubject.getType() == Subject.Type.REMOTE_ACCESS;
    }

    public boolean supportsRunAs(@Nullable AnonymousUser anonymousUser) {
        if (this.isRunAs()) {
            return false;
        }
        if (this.isServiceAccount()) {
            return false;
        }
        if (this.isRemoteAccess()) {
            return false;
        }
        if (User.isInternal(this.getEffectiveSubject().getUser())) {
            return false;
        }
        if (this.getEffectiveSubject().getUser().equals(anonymousUser)) {
            assert ("__anonymous".equals(this.getAuthenticatingSubject().getRealm().getType()) && "__anonymous".equals(this.getAuthenticatingSubject().getRealm().getName()));
            return false;
        }
        return AuthenticationType.REALM == this.getAuthenticationType() || AuthenticationType.API_KEY == this.getAuthenticationType() || AuthenticationType.TOKEN == this.getAuthenticationType();
    }

    public void writeToContext(ThreadContext ctx) throws IOException, IllegalArgumentException {
        new AuthenticationContextSerializer().writeToContext(this, ctx);
    }

    public String encode() throws IOException {
        BytesStreamOutput output = new BytesStreamOutput();
        output.setTransportVersion(this.getEffectiveSubject().getTransportVersion());
        TransportVersion.writeVersion((TransportVersion)this.getEffectiveSubject().getTransportVersion(), (StreamOutput)output);
        this.writeTo((StreamOutput)output);
        return Base64.getEncoder().encodeToString(BytesReference.toBytes((BytesReference)output.bytes()));
    }

    public void writeTo(StreamOutput out) throws IOException {
        RealmRef lookedUpBy;
        if (this.isRemoteAccess() && out.getTransportVersion().before(VERSION_REMOTE_ACCESS_REALM)) {
            throw new IllegalArgumentException("versions of Elasticsearch before [" + VERSION_REMOTE_ACCESS_REALM + "] can't handle remote access authentication and attempted to send to [" + out.getTransportVersion() + "]");
        }
        if (this.isRunAs()) {
            User outerUser = this.effectiveSubject.getUser();
            User innerUser = this.authenticatingSubject.getUser();
            assert (!User.isInternal(outerUser) && !User.isInternal(innerUser)) : "internal users cannot participate in run-as";
            User.writeUser(outerUser, out);
            out.writeBoolean(true);
            User.writeUser(innerUser, out);
            out.writeBoolean(false);
        } else {
            User user = this.effectiveSubject.getUser();
            AuthenticationSerializationHelper.writeUserTo(user, out);
        }
        this.authenticatingSubject.getRealm().writeTo(out);
        RealmRef realmRef = lookedUpBy = this.isRunAs() ? this.effectiveSubject.getRealm() : null;
        if (lookedUpBy != null) {
            out.writeBoolean(true);
            lookedUpBy.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        Map<String, Object> metadata = this.getAuthenticatingSubject().getMetadata();
        if (out.getTransportVersion().onOrAfter(VERSION_AUTHENTICATION_TYPE)) {
            out.writeVInt(this.type.ordinal());
            out.writeGenericMap(metadata);
        } else assert (this.type == AuthenticationType.REALM && metadata.isEmpty()) : Strings.format((String)"authentication with version [%s] must have authentication type %s and empty metadata, but got [%s] and [%s]", (Object[])new Object[]{out.getTransportVersion(), AuthenticationType.REALM, this.type, metadata});
    }

    public boolean canAccessResourcesOf(Authentication resourceCreatorAuthentication) {
        assert (EnumSet.of(AuthenticationType.REALM, AuthenticationType.API_KEY, AuthenticationType.TOKEN, AuthenticationType.ANONYMOUS, AuthenticationType.INTERNAL).containsAll(EnumSet.of(this.getAuthenticationType(), resourceCreatorAuthentication.getAuthenticationType()))) : "cross AuthenticationType comparison for canAccessResourcesOf is not applicable for: " + EnumSet.of(this.getAuthenticationType(), resourceCreatorAuthentication.getAuthenticationType());
        Subject mySubject = this.getEffectiveSubject();
        Subject creatorSubject = resourceCreatorAuthentication.getEffectiveSubject();
        return mySubject.canAccessResourcesOf(creatorSubject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authentication that = (Authentication)o;
        return this.type == that.type && this.authenticatingSubject.equals(that.authenticatingSubject) && this.effectiveSubject.equals(that.effectiveSubject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.authenticatingSubject, this.effectiveSubject});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder);
        return builder.endObject();
    }

    public void toXContentFragment(XContentBuilder builder) throws IOException {
        RealmRef lookedUpBy;
        User user = this.effectiveSubject.getUser();
        builder.field(User.Fields.USERNAME.getPreferredName(), user.principal());
        builder.array(User.Fields.ROLES.getPreferredName(), user.roles());
        builder.field(User.Fields.FULL_NAME.getPreferredName(), user.fullName());
        builder.field(User.Fields.EMAIL.getPreferredName(), user.email());
        if (this.isServiceAccount()) {
            String tokenName = (String)this.getAuthenticatingSubject().getMetadata().get("_token_name");
            assert (tokenName != null) : "token name cannot be null";
            String tokenSource = (String)this.getAuthenticatingSubject().getMetadata().get("_token_source");
            assert (tokenSource != null) : "token source cannot be null";
            builder.field(User.Fields.TOKEN.getPreferredName(), Map.of("name", tokenName, "type", "_service_account_" + tokenSource));
        }
        builder.field(User.Fields.METADATA.getPreferredName(), user.metadata());
        builder.field(User.Fields.ENABLED.getPreferredName(), user.enabled());
        builder.startObject(User.Fields.AUTHENTICATION_REALM.getPreferredName());
        builder.field(User.Fields.REALM_NAME.getPreferredName(), this.getAuthenticatingSubject().getRealm().getName());
        builder.field(User.Fields.REALM_TYPE.getPreferredName(), this.getAuthenticatingSubject().getRealm().getType());
        if (this.getAuthenticatingSubject().getRealm().getDomain() != null) {
            builder.field(User.Fields.REALM_DOMAIN.getPreferredName(), this.getAuthenticatingSubject().getRealm().getDomain().name());
        }
        builder.endObject();
        builder.startObject(User.Fields.LOOKUP_REALM.getPreferredName());
        RealmRef realmRef = lookedUpBy = this.isRunAs() ? this.getEffectiveSubject().getRealm() : null;
        if (lookedUpBy != null) {
            builder.field(User.Fields.REALM_NAME.getPreferredName(), lookedUpBy.getName());
            builder.field(User.Fields.REALM_TYPE.getPreferredName(), lookedUpBy.getType());
            if (lookedUpBy.getDomain() != null) {
                builder.field(User.Fields.REALM_DOMAIN.getPreferredName(), lookedUpBy.getDomain().name());
            }
        } else {
            builder.field(User.Fields.REALM_NAME.getPreferredName(), this.getAuthenticatingSubject().getRealm().getName());
            builder.field(User.Fields.REALM_TYPE.getPreferredName(), this.getAuthenticatingSubject().getRealm().getType());
            if (this.getAuthenticatingSubject().getRealm().getDomain() != null) {
                builder.field(User.Fields.REALM_DOMAIN.getPreferredName(), this.getAuthenticatingSubject().getRealm().getDomain().name());
            }
        }
        builder.endObject();
        builder.field(User.Fields.AUTHENTICATION_TYPE.getPreferredName(), this.getAuthenticationType().name().toLowerCase(Locale.ROOT));
        if (this.isApiKey() || this.isRemoteAccess()) {
            String apiKeyId = (String)this.getAuthenticatingSubject().getMetadata().get("_security_api_key_id");
            String apiKeyName = (String)this.getAuthenticatingSubject().getMetadata().get("_security_api_key_name");
            if (apiKeyName == null) {
                builder.field("api_key", Map.of("id", apiKeyId));
            } else {
                builder.field("api_key", Map.of("id", apiKeyId, "name", apiKeyName));
            }
        }
    }

    private void assertInternalConsistency() {
        if (!Assertions.ENABLED) {
            return;
        }
        assert (this.effectiveSubject != null);
        assert (this.authenticatingSubject != null);
        assert (this.type != null);
        assert (this.effectiveSubject.getTransportVersion().equals((Object)this.authenticatingSubject.getTransportVersion()));
        if (this.isRunAs()) {
            assert (this.authenticatingSubject != this.effectiveSubject) : "isRunAs logic does not hold";
            assert (!User.isInternal(this.effectiveSubject.getUser()) && !User.isInternal(this.authenticatingSubject.getUser())) : "internal users cannot participate in run-as";
        } else assert (this.authenticatingSubject == this.effectiveSubject) : "isRunAs logic does not hold";
        assert (!(this.isAuthenticatedAsApiKey() || this.isRemoteAccess()) || this.getAuthenticatingSubject().getMetadata().get("_security_api_key_id") != null) : "API KEY authentication requires metadata to contain API KEY id, and the value must be non-null.";
        if (this.isRemoteAccess()) {
            assert (this.getAuthenticatingSubject().getMetadata().get("_security_remote_access_authentication") != null) : "Remote access authentication requires metadata to contain a serialized remote access authentication, and the value must be non-null.";
            assert (this.getAuthenticatingSubject().getMetadata().get("_security_remote_access_role_descriptors") != null) : "Remote access authentication requires metadata to contain a serialized remote access role descriptors, and the value must be non-null.";
        }
        if (this.isAssignedToDomain()) {
            assert (!this.isApiKey());
            assert (!this.isRemoteAccess());
            assert (!this.isServiceAccount());
            assert (!this.isAuthenticatedAnonymously());
            assert (!this.isAuthenticatedInternally());
        }
    }

    private boolean hasSyntheticRealmNameOrType(@Nullable RealmRef realmRef) {
        if (realmRef == null) {
            return false;
        }
        if (List.of("_es_api_key", "_service_account", "__anonymous", "__fallback", "__attach", "_es_remote_access").contains(realmRef.getName())) {
            return true;
        }
        return List.of("_es_api_key", "_service_account", "__anonymous", "__fallback", "__attach", "_es_remote_access").contains(realmRef.getType());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Authentication[effectiveSubject=").append(this.effectiveSubject);
        if (this.isRunAs()) {
            builder.append(",authenticatingSubject=").append(this.authenticatingSubject);
        }
        builder.append(",type=").append((Object)this.type);
        builder.append("]");
        return builder.toString();
    }

    public static boolean isFileOrNativeRealm(String realmType) {
        return "file".equals(realmType) || "native".equals(realmType);
    }

    public static Authentication newInternalAuthentication(User internalUser, TransportVersion version, String nodeName) {
        assert (User.isInternal(internalUser));
        RealmRef authenticatedBy = RealmRef.newInternalAttachRealmRef(nodeName);
        Authentication authentication = new Authentication(new Subject(internalUser, authenticatedBy, version, Map.of()), AuthenticationType.INTERNAL);
        assert (!authentication.isAssignedToDomain());
        return authentication;
    }

    public static Authentication newInternalFallbackAuthentication(User fallbackUser, String nodeName) {
        RealmRef authenticatedBy = RealmRef.newInternalFallbackRealmRef(nodeName);
        Authentication authentication = new Authentication(new Subject(fallbackUser, authenticatedBy, TransportVersion.CURRENT, Map.of()), AuthenticationType.INTERNAL);
        assert (!authentication.isAssignedToDomain());
        return authentication;
    }

    public static Authentication newAnonymousAuthentication(AnonymousUser anonymousUser, String nodeName) {
        RealmRef authenticatedBy = RealmRef.newAnonymousRealmRef(nodeName);
        Authentication authentication = new Authentication(new Subject(anonymousUser, authenticatedBy, TransportVersion.CURRENT, Map.of()), AuthenticationType.ANONYMOUS);
        assert (!authentication.isAssignedToDomain());
        return authentication;
    }

    public static Authentication newServiceAccountAuthentication(User serviceAccountUser, String nodeName, Map<String, Object> metadata) {
        RealmRef authenticatedBy = RealmRef.newServiceAccountRealmRef(nodeName);
        Authentication authentication = new Authentication(new Subject(serviceAccountUser, authenticatedBy, TransportVersion.CURRENT, metadata), AuthenticationType.TOKEN);
        assert (!authentication.isAssignedToDomain());
        return authentication;
    }

    public static Authentication newRealmAuthentication(User user, RealmRef realmRef) {
        Authentication authentication = new Authentication(new Subject(user, realmRef, TransportVersion.CURRENT, Map.of()), AuthenticationType.REALM);
        assert (!authentication.isServiceAccount());
        assert (!authentication.isApiKey());
        assert (!authentication.isRemoteAccess());
        assert (!authentication.isAuthenticatedInternally());
        assert (!authentication.isAuthenticatedAnonymously());
        return authentication;
    }

    public static Authentication newApiKeyAuthentication(AuthenticationResult<User> authResult, String nodeName) {
        assert (authResult.isAuthenticated()) : "API Key authn result must be successful";
        User apiKeyUser = authResult.getValue();
        assert (apiKeyUser.roles().length == 0) : "The user associated to an API key authentication must have no role";
        RealmRef authenticatedBy = RealmRef.newApiKeyRealmRef(nodeName);
        Authentication authentication = new Authentication(new Subject(apiKeyUser, authenticatedBy, TransportVersion.CURRENT, authResult.getMetadata()), AuthenticationType.API_KEY);
        assert (!authentication.isAssignedToDomain());
        return authentication;
    }

    public Authentication toRemoteAccess(RemoteAccessAuthentication remoteAccessAuthentication) {
        assert (this.isApiKey()) : "can only convert API key authentication to remote access";
        assert (!this.isRunAs()) : "remote access does not support authentication with run-as";
        HashMap<String, Object> metadata = new HashMap<String, Object>(this.getAuthenticatingSubject().getMetadata());
        RealmRef authenticatedBy = RealmRef.newRemoteAccessRealmRef(this.getAuthenticatingSubject().getRealm().getNodeName());
        User userFromRemoteCluster = remoteAccessAuthentication.getAuthentication().getEffectiveSubject().getUser();
        assert (userFromRemoteCluster.enabled()) : "the user received from a remote cluster must be enabled";
        User userWithoutRoles = new User(userFromRemoteCluster.principal(), org.elasticsearch.common.Strings.EMPTY_ARRAY, userFromRemoteCluster.fullName(), userFromRemoteCluster.email(), userFromRemoteCluster.metadata(), userFromRemoteCluster.enabled());
        Authentication authentication = new Authentication(new Subject(userWithoutRoles, authenticatedBy, TransportVersion.CURRENT, remoteAccessAuthentication.copyWithRemoteAccessEntries(metadata)), this.getAuthenticationType());
        assert (!authentication.isAssignedToDomain());
        return authentication;
    }

    static RealmRef maybeRewriteRealmRef(TransportVersion streamVersion, RealmRef realmRef) {
        if (realmRef != null && realmRef.getDomain() != null && streamVersion.before(VERSION_REALM_DOMAINS)) {
            logger.info("Rewriting realm [" + realmRef + "] without domain");
            return new RealmRef(realmRef.getName(), realmRef.getType(), realmRef.getNodeName(), null);
        }
        return realmRef;
    }

    private static Map<String, Object> maybeRewriteMetadataForApiKeyRoleDescriptors(TransportVersion streamVersion, Authentication authentication) {
        Map<String, Object> metadata = authentication.getAuthenticatingSubject().getMetadata();
        if (authentication.isAuthenticatedAsApiKey()) {
            assert (metadata.containsKey("_security_api_key_role_descriptors")) : "metadata must contain role descriptor for API key authentication";
            assert (metadata.containsKey("_security_api_key_limited_by_role_descriptors")) : "metadata must contain limited role descriptor for API key authentication";
            if (authentication.getEffectiveSubject().getTransportVersion().onOrAfter(VERSION_API_KEY_ROLES_AS_BYTES) && streamVersion.before(VERSION_API_KEY_ROLES_AS_BYTES)) {
                metadata = new HashMap<String, Object>(metadata);
                metadata.put("_security_api_key_role_descriptors", Authentication.convertRoleDescriptorsBytesToMap((BytesReference)metadata.get("_security_api_key_role_descriptors")));
                metadata.put("_security_api_key_limited_by_role_descriptors", Authentication.convertRoleDescriptorsBytesToMap((BytesReference)metadata.get("_security_api_key_limited_by_role_descriptors")));
            } else if (authentication.getEffectiveSubject().getTransportVersion().before(VERSION_API_KEY_ROLES_AS_BYTES) && streamVersion.onOrAfter(VERSION_API_KEY_ROLES_AS_BYTES)) {
                metadata = new HashMap<String, Object>(metadata);
                metadata.put("_security_api_key_role_descriptors", Authentication.convertRoleDescriptorsMapToBytes((Map)metadata.get("_security_api_key_role_descriptors")));
                metadata.put("_security_api_key_limited_by_role_descriptors", Authentication.convertRoleDescriptorsMapToBytes((Map)metadata.get("_security_api_key_limited_by_role_descriptors")));
            }
        }
        return metadata;
    }

    static Map<String, Object> maybeRewriteMetadataForRemoteAccessAuthentication(TransportVersion olderVersion, Authentication authentication) {
        assert (authentication.isRemoteAccess()) : "authentication must be remote access";
        Map<String, Object> metadata = authentication.getAuthenticatingSubject().getMetadata();
        assert (metadata.containsKey("_security_remote_access_authentication")) : "metadata must contain authentication object for remote access authentication";
        try {
            Authentication authenticationFromMetadata = AuthenticationContextSerializer.decode((String)metadata.get("_security_remote_access_authentication"));
            if (authenticationFromMetadata.getEffectiveSubject().getTransportVersion().after(olderVersion)) {
                HashMap<String, Object> rewrittenMetadata = new HashMap<String, Object>(metadata);
                rewrittenMetadata.put("_security_remote_access_authentication", authenticationFromMetadata.maybeRewriteForOlderVersion(olderVersion).encode());
                return rewrittenMetadata;
            }
            return metadata;
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed serialization while rewriting [_security_remote_access_authentication] metadata field", e);
        }
    }

    private static Map<String, Object> convertRoleDescriptorsBytesToMap(BytesReference roleDescriptorsBytes) {
        return (Map)XContentHelper.convertToMap((BytesReference)roleDescriptorsBytes, (boolean)false, (XContentType)XContentType.JSON).v2();
    }

    private static BytesReference convertRoleDescriptorsMapToBytes(Map<String, Object> roleDescriptorsMap) {
        BytesReference bytesReference;
        block8: {
            XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());
            try {
                builder.map(roleDescriptorsMap);
                bytesReference = BytesReference.bytes((XContentBuilder)builder);
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            builder.close();
        }
        return bytesReference;
    }

    static boolean equivalentRealms(String name1, String type1, String name2, String type2) {
        if (!type1.equals(type2)) {
            return false;
        }
        if (Authentication.isFileOrNativeRealm(type1)) {
            return true;
        }
        return name1.equals(name2);
    }

    static {
        REALM_REF_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        REALM_REF_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        REALM_REF_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("node_name", new String[0]));
        REALM_REF_PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> (RealmDomain)RealmDomain.REALM_DOMAIN_PARSER.parse(p, c), new ParseField("domain", new String[0]));
    }

    public static enum AuthenticationType {
        REALM,
        API_KEY,
        TOKEN,
        ANONYMOUS,
        INTERNAL;

    }

    public static class AuthenticationSerializationHelper {
        private AuthenticationSerializationHelper() {
        }

        public static User readUserFrom(StreamInput input) throws IOException {
            User user = AuthenticationSerializationHelper.readUserWithoutTrailingBoolean(input);
            if (!User.isInternal(user)) {
                boolean hasInnerUser = input.readBoolean();
                assert (!hasInnerUser) : "no inner user is possible, otherwise use UserTuple.readFrom";
            }
            return user;
        }

        public static void writeUserTo(User user, StreamOutput output) throws IOException {
            if (User.isInternal(user)) {
                AuthenticationSerializationHelper.writeInternalUser(user, output);
            } else {
                User.writeUser(user, output);
                output.writeBoolean(false);
            }
        }

        private static User readUserWithoutTrailingBoolean(StreamInput input) throws IOException {
            boolean isInternalUser = input.readBoolean();
            String username = input.readString();
            if (isInternalUser) {
                if ("_system".equals(username)) {
                    return SystemUser.INSTANCE;
                }
                if ("_xpack".equals(username)) {
                    return XPackUser.INSTANCE;
                }
                if ("_xpack_security".equals(username)) {
                    return XPackSecurityUser.INSTANCE;
                }
                if ("_security_profile".equals(username)) {
                    return SecurityProfileUser.INSTANCE;
                }
                if ("_async_search".equals(username)) {
                    return AsyncSearchUser.INSTANCE;
                }
                throw new IllegalStateException("username [" + username + "] does not match any internal user");
            }
            String[] roles = input.readStringArray();
            Map metadata = input.readMap();
            String fullName = input.readOptionalString();
            String email = input.readOptionalString();
            boolean enabled = input.readBoolean();
            return new User(username, roles, fullName, email, metadata, enabled);
        }

        private static void writeInternalUser(User user, StreamOutput output) throws IOException {
            assert (User.isInternal(user));
            output.writeBoolean(true);
            if (SystemUser.is(user)) {
                output.writeString("_system");
            } else if (XPackUser.is(user)) {
                output.writeString("_xpack");
            } else if (XPackSecurityUser.is(user)) {
                output.writeString("_xpack_security");
            } else if (SecurityProfileUser.is(user)) {
                output.writeString("_security_profile");
            } else if (AsyncSearchUser.is(user)) {
                output.writeString("_async_search");
            } else {
                assert (false);
                throw new IllegalStateException("user [" + user + "] is not internal");
            }
        }
    }

    public static class RealmRef
    implements Writeable,
    ToXContentObject {
        private final String nodeName;
        private final String name;
        private final String type;
        @Nullable
        private final RealmDomain domain;

        public RealmRef(String name, String type, String nodeName) {
            this(name, type, nodeName, null);
        }

        public RealmRef(String name, String type, String nodeName, @Nullable RealmDomain domain) {
            this.nodeName = Objects.requireNonNull(nodeName, "node name cannot be null");
            this.name = Objects.requireNonNull(name, "realm name cannot be null");
            this.type = Objects.requireNonNull(type, "realm type cannot be null");
            this.domain = domain;
        }

        public RealmRef(StreamInput in) throws IOException {
            this.nodeName = in.readString();
            this.name = in.readString();
            this.type = in.readString();
            this.domain = in.getTransportVersion().onOrAfter(VERSION_REALM_DOMAINS) ? (RealmDomain)in.readOptionalWriteable(RealmDomain::readFrom) : null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeName);
            out.writeString(this.name);
            out.writeString(this.type);
            if (out.getTransportVersion().onOrAfter(VERSION_REALM_DOMAINS)) {
                out.writeOptionalWriteable((Writeable)this.domain);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.name);
            builder.field("type", this.type);
            builder.field("node_name", this.nodeName);
            if (this.domain != null) {
                builder.field("domain", (ToXContent)this.domain);
            }
            builder.endObject();
            return builder;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public RealmDomain getDomain() {
            return this.domain;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RealmRef realmRef = (RealmRef)o;
            if (!this.nodeName.equals(realmRef.nodeName)) {
                return false;
            }
            if (!this.type.equals(realmRef.type)) {
                return false;
            }
            return Objects.equals(this.domain, realmRef.domain);
        }

        public int hashCode() {
            int result = this.nodeName.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            if (this.domain != null) {
                result = 31 * result + this.domain.hashCode();
            }
            return result;
        }

        public String toString() {
            if (this.domain != null) {
                return "{Realm[" + this.type + "." + this.name + "] under Domain[" + this.domain.name() + "] on Node[" + this.nodeName + "]}";
            }
            return "{Realm[" + this.type + "." + this.name + "] on Node[" + this.nodeName + "]}";
        }

        static RealmRef newInternalAttachRealmRef(String nodeName) {
            return new RealmRef("__attach", "__attach", nodeName, null);
        }

        static RealmRef newInternalFallbackRealmRef(String nodeName) {
            RealmRef realmRef = new RealmRef("__fallback", "__fallback", nodeName, null);
            return realmRef;
        }

        public static RealmRef newAnonymousRealmRef(String nodeName) {
            return new RealmRef("__anonymous", "__anonymous", nodeName, null);
        }

        static RealmRef newServiceAccountRealmRef(String nodeName) {
            return new RealmRef("_service_account", "_service_account", nodeName, null);
        }

        static RealmRef newApiKeyRealmRef(String nodeName) {
            return new RealmRef("_es_api_key", "_es_api_key", nodeName, null);
        }

        static RealmRef newRemoteAccessRealmRef(String nodeName) {
            return new RealmRef("_es_remote_access", "_es_remote_access", nodeName, null);
        }
    }
}

