/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.AbstractBytesReference;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;

public final class RemoteAccessAuthentication {
    public static final String REMOTE_ACCESS_AUTHENTICATION_HEADER_KEY = "_remote_access_authentication";
    private final Authentication authentication;
    private final List<RoleDescriptorsBytes> roleDescriptorsBytesList;

    public RemoteAccessAuthentication(Authentication authentication, RoleDescriptorsIntersection roleDescriptorsIntersection) throws IOException {
        this(authentication, RemoteAccessAuthentication.toRoleDescriptorsBytesList(roleDescriptorsIntersection));
    }

    private RemoteAccessAuthentication(Authentication authentication, List<RoleDescriptorsBytes> roleDescriptorsBytesList) {
        this.authentication = authentication;
        this.roleDescriptorsBytesList = roleDescriptorsBytesList;
    }

    public void writeToContext(ThreadContext ctx) throws IOException {
        ctx.putHeader(REMOTE_ACCESS_AUTHENTICATION_HEADER_KEY, this.encode());
    }

    public static RemoteAccessAuthentication readFromContext(ThreadContext ctx) throws IOException {
        return RemoteAccessAuthentication.decode(ctx.getHeader(REMOTE_ACCESS_AUTHENTICATION_HEADER_KEY));
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public List<RoleDescriptorsBytes> getRoleDescriptorsBytesList() {
        return this.roleDescriptorsBytesList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteAccessAuthentication that = (RemoteAccessAuthentication)o;
        if (!this.authentication.equals(that.authentication)) {
            return false;
        }
        return this.roleDescriptorsBytesList.equals(that.roleDescriptorsBytesList);
    }

    public int hashCode() {
        int result = this.authentication.hashCode();
        result = 31 * result + this.roleDescriptorsBytesList.hashCode();
        return result;
    }

    public String toString() {
        return "RemoteAccessAuthentication{authentication=" + this.authentication + ", roleDescriptorsBytesList=" + this.roleDescriptorsBytesList + "}";
    }

    private static List<RoleDescriptorsBytes> toRoleDescriptorsBytesList(RoleDescriptorsIntersection roleDescriptorsIntersection) throws IOException {
        assert (roleDescriptorsIntersection.roleDescriptorsList().stream().noneMatch(rds -> rds.size() > 1)) : "sets with more than one role descriptor are not supported for remote access authentication";
        ArrayList<RoleDescriptorsBytes> roleDescriptorsBytesList = new ArrayList<RoleDescriptorsBytes>();
        for (Set<RoleDescriptor> roleDescriptors : roleDescriptorsIntersection.roleDescriptorsList()) {
            roleDescriptorsBytesList.add(RoleDescriptorsBytes.fromRoleDescriptors(roleDescriptors));
        }
        return roleDescriptorsBytesList;
    }

    public String encode() throws IOException {
        BytesStreamOutput out = new BytesStreamOutput();
        out.setTransportVersion(this.authentication.getEffectiveSubject().getTransportVersion());
        TransportVersion.writeVersion((TransportVersion)this.authentication.getEffectiveSubject().getTransportVersion(), (StreamOutput)out);
        this.authentication.writeTo((StreamOutput)out);
        out.writeCollection(this.roleDescriptorsBytesList, StreamOutput::writeBytesReference);
        return Base64.getEncoder().encodeToString(BytesReference.toBytes((BytesReference)out.bytes()));
    }

    public static RemoteAccessAuthentication decode(String header) throws IOException {
        Objects.requireNonNull(header);
        byte[] bytes = Base64.getDecoder().decode(header);
        StreamInput in = StreamInput.wrap((byte[])bytes);
        TransportVersion version = TransportVersion.readVersion((StreamInput)in);
        in.setTransportVersion(version);
        Authentication authentication = new Authentication(in);
        List roleDescriptorsBytesList = in.readImmutableList(RoleDescriptorsBytes::new);
        return new RemoteAccessAuthentication(authentication, roleDescriptorsBytesList);
    }

    public Map<String, Object> copyWithRemoteAccessEntries(Map<String, Object> authenticationMetadata) {
        assert (!authenticationMetadata.containsKey("_security_remote_access_authentication")) : "metadata already contains [_security_remote_access_authentication] entry";
        assert (!authenticationMetadata.containsKey("_security_remote_access_role_descriptors")) : "metadata already contains [_security_remote_access_role_descriptors] entry";
        assert (!this.getAuthentication().isRemoteAccess()) : "authentication included in remote access header cannot itself be remote access";
        HashMap<String, Object> copy = new HashMap<String, Object>(authenticationMetadata);
        try {
            copy.put("_security_remote_access_authentication", this.getAuthentication().encode());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        copy.put("_security_remote_access_role_descriptors", this.getRoleDescriptorsBytesList());
        return Collections.unmodifiableMap(copy);
    }

    public static final class RoleDescriptorsBytes
    extends AbstractBytesReference {
        public static final RoleDescriptorsBytes EMPTY = new RoleDescriptorsBytes((BytesReference)new BytesArray("{}"));
        private final BytesReference rawBytes;

        public RoleDescriptorsBytes(BytesReference rawBytes) {
            this.rawBytes = rawBytes;
        }

        public RoleDescriptorsBytes(StreamInput streamInput) throws IOException {
            this(streamInput.readBytesReference());
        }

        public static RoleDescriptorsBytes fromRoleDescriptors(Set<RoleDescriptor> roleDescriptors) throws IOException {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            for (RoleDescriptor roleDescriptor : roleDescriptors) {
                builder.field(roleDescriptor.getName(), (ToXContent)roleDescriptor);
            }
            builder.endObject();
            return new RoleDescriptorsBytes(BytesReference.bytes((XContentBuilder)builder));
        }

        public Set<RoleDescriptor> toRoleDescriptors() {
            Set<RoleDescriptor> set;
            block9: {
                XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)this.rawBytes, (XContentType)XContentType.JSON);
                try {
                    ArrayList<RoleDescriptor> roleDescriptors = new ArrayList<RoleDescriptor>();
                    parser.nextToken();
                    while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                        parser.nextToken();
                        String roleName = parser.currentName();
                        roleDescriptors.add(RoleDescriptor.parse(roleName, parser, false));
                    }
                    set = Set.copyOf(roleDescriptors);
                    if (parser == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                parser.close();
            }
            return set;
        }

        public byte get(int index) {
            return this.rawBytes.get(index);
        }

        public int length() {
            return this.rawBytes.length();
        }

        public BytesReference slice(int from, int length) {
            return this.rawBytes.slice(from, length);
        }

        public long ramBytesUsed() {
            return this.rawBytes.ramBytesUsed();
        }

        public BytesRef toBytesRef() {
            return this.rawBytes.toBytesRef();
        }
    }
}

