/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.authc.support.mapper.TemplateRoleName;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionParser;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;

public class ExpressionRoleMapping
implements ToXContentObject,
Writeable {
    private static final ObjectParser<Builder, String> PARSER = new ObjectParser("role-mapping", Builder::new);
    private static final String UPGRADE_API_TYPE_FIELD = "type";
    private final String name;
    private final RoleMapperExpression expression;
    private final List<String> roles;
    private final List<TemplateRoleName> roleTemplates;
    private final Map<String, Object> metadata;
    private final boolean enabled;

    public ExpressionRoleMapping(String name, RoleMapperExpression expr, List<String> roles, List<TemplateRoleName> templates, Map<String, Object> metadata, boolean enabled) {
        this.name = name;
        this.expression = expr;
        this.roles = roles == null ? Collections.emptyList() : roles;
        this.roleTemplates = templates == null ? Collections.emptyList() : templates;
        this.metadata = metadata;
        this.enabled = enabled;
    }

    public ExpressionRoleMapping(StreamInput in) throws IOException {
        this.name = in.readString();
        this.enabled = in.readBoolean();
        this.roles = in.readStringList();
        this.roleTemplates = in.getTransportVersion().onOrAfter(TransportVersion.V_7_2_0) ? in.readList(TemplateRoleName::new) : Collections.emptyList();
        this.expression = ExpressionParser.readExpression(in);
        this.metadata = in.readMap();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.enabled);
        out.writeStringCollection(this.roles);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_2_0)) {
            out.writeList(this.roleTemplates);
        }
        ExpressionParser.writeExpression(this.expression, out);
        out.writeGenericMap(this.metadata);
    }

    public String getName() {
        return this.name;
    }

    public RoleMapperExpression getExpression() {
        return this.expression;
    }

    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public List<TemplateRoleName> getRoleTemplates() {
        return Collections.unmodifiableList(this.roleTemplates);
    }

    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.name + " ; " + this.roles + "/" + this.roleTemplates + " = " + Strings.toString((ToXContent)this.expression) + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionRoleMapping that = (ExpressionRoleMapping)o;
        return this.enabled == that.enabled && Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression) && Objects.equals(this.roles, that.roles) && Objects.equals(this.roleTemplates, that.roleTemplates) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression, this.roles, this.roleTemplates, this.metadata, this.enabled);
    }

    public static ExpressionRoleMapping parse(String name, BytesReference source, XContentType xContentType) throws IOException {
        NamedXContentRegistry registry = NamedXContentRegistry.EMPTY;
        try (StreamInput stream = source.streamInput();){
            ExpressionRoleMapping expressionRoleMapping;
            block12: {
                XContentParser parser = xContentType.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    expressionRoleMapping = ExpressionRoleMapping.parse(name, parser);
                    if (parser == null) break block12;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return expressionRoleMapping;
        }
    }

    public static ExpressionRoleMapping parse(String name, XContentParser parser) throws IOException {
        try {
            Builder builder = (Builder)PARSER.parse(parser, (Object)name);
            return builder.build(name);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, false);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, boolean indexFormat) throws IOException {
        builder.startObject();
        builder.field(Fields.ENABLED.getPreferredName(), this.enabled);
        if (!this.roles.isEmpty()) {
            builder.startArray(Fields.ROLES.getPreferredName());
            for (String string : this.roles) {
                builder.value(string);
            }
            builder.endArray();
        }
        if (!this.roleTemplates.isEmpty()) {
            builder.startArray(Fields.ROLE_TEMPLATES.getPreferredName());
            for (TemplateRoleName templateRoleName : this.roleTemplates) {
                builder.value((Object)templateRoleName);
            }
            builder.endArray();
        }
        builder.field(Fields.RULES.getPreferredName());
        this.expression.toXContent(builder, params);
        builder.field(Fields.METADATA.getPreferredName(), this.metadata);
        if (indexFormat) {
            builder.field("doc_type", "role-mapping");
        }
        return builder.endObject();
    }

    public Set<String> getRoleNames(ScriptService scriptService, ExpressionModel model) {
        return Stream.concat(this.roles.stream(), this.roleTemplates.stream().flatMap(r -> r.getRoleNames(scriptService, model).stream())).collect(Collectors.toSet());
    }

    static {
        PARSER.declareStringArray(Builder::roles, Fields.ROLES);
        PARSER.declareObjectArray(Builder::roleTemplates, (parser, ctx) -> TemplateRoleName.parse(parser), Fields.ROLE_TEMPLATES);
        PARSER.declareField(Builder::rules, ExpressionParser::parseObject, Fields.RULES, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(Builder::metadata, XContentParser::map, Fields.METADATA, ObjectParser.ValueType.OBJECT);
        PARSER.declareBoolean(Builder::enabled, Fields.ENABLED);
        BiConsumer<Builder, String> ignored = (b, v) -> {};
        PARSER.declareString(ignored, new ParseField("doc_type", new String[0]));
        PARSER.declareString(ignored, new ParseField(UPGRADE_API_TYPE_FIELD, new String[0]));
    }

    private static class Builder {
        private RoleMapperExpression rules;
        private List<String> roles;
        private List<TemplateRoleName> roleTemplates;
        private Map<String, Object> metadata = Collections.emptyMap();
        private Boolean enabled;

        private Builder() {
        }

        Builder rules(RoleMapperExpression expression) {
            this.rules = expression;
            return this;
        }

        Builder roles(List<String> roles) {
            this.roles = new ArrayList<String>(roles);
            return this;
        }

        Builder roleTemplates(List<TemplateRoleName> templates) {
            this.roleTemplates = new ArrayList<TemplateRoleName>(templates);
            return this;
        }

        Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        private ExpressionRoleMapping build(String name) {
            if (this.roles == null && this.roleTemplates == null) {
                throw Builder.missingField(name, Fields.ROLES);
            }
            if (this.rules == null) {
                throw Builder.missingField(name, Fields.RULES);
            }
            if (this.enabled == null) {
                throw Builder.missingField(name, Fields.ENABLED);
            }
            return new ExpressionRoleMapping(name, this.rules, this.roles, this.roleTemplates, this.metadata, this.enabled);
        }

        private static IllegalStateException missingField(String id, ParseField field) {
            return new IllegalStateException("failed to parse role-mapping [" + id + "]. missing field [" + field + "]");
        }
    }

    public static interface Fields {
        public static final ParseField ROLES = new ParseField("roles", new String[0]);
        public static final ParseField ROLE_TEMPLATES = new ParseField("role_templates", new String[0]);
        public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
        public static final ParseField RULES = new ParseField("rules", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
    }
}

