/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.core.security.authz.support.SecurityQueryTemplateEvaluator;
import org.elasticsearch.xpack.core.security.support.CacheKey;
import org.elasticsearch.xpack.core.security.user.User;

public final class DocumentPermissions
implements CacheKey {
    @Nullable
    private final List<Set<BytesReference>> listOfQueries;
    @Nullable
    private List<List<String>> listOfEvaluatedQueries;
    private static final DocumentPermissions ALLOW_ALL = new DocumentPermissions();

    private DocumentPermissions() {
        this.listOfQueries = null;
    }

    private DocumentPermissions(Set<BytesReference> queries) {
        assert (queries != null && !queries.isEmpty()) : "null or empty queries not permitted";
        this.listOfQueries = List.of(new TreeSet<BytesReference>(queries));
    }

    private DocumentPermissions(List<Set<BytesReference>> listOfQueries) {
        assert (listOfQueries != null && !listOfQueries.isEmpty()) : "null or empty list of queries not permitted";
        assert (listOfQueries.stream().allMatch(queries -> queries != null && false == queries.isEmpty())) : "null or empty queries not permitted";
        this.listOfQueries = listOfQueries.stream().map(queries -> queries instanceof SortedSet ? queries : new TreeSet(queries)).toList();
    }

    public List<Set<BytesReference>> getListOfQueries() {
        return this.listOfQueries;
    }

    public Set<BytesReference> getSingleSetOfQueries() {
        assert (this.listOfQueries != null && this.listOfQueries.size() == 1) : "the list of queries does not have a single member";
        return this.listOfQueries.get(0);
    }

    public boolean hasDocumentLevelPermissions() {
        return this.listOfQueries != null;
    }

    public boolean hasStoredScript() throws IOException {
        if (this.listOfQueries != null) {
            for (Set<BytesReference> queries : this.listOfQueries) {
                for (BytesReference q : queries) {
                    if (!DLSRoleQueryValidator.hasStoredScript(q, NamedXContentRegistry.EMPTY)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public BooleanQuery filter(User user, ScriptService scriptService, ShardId shardId, Function<ShardId, SearchExecutionContext> searchExecutionContextProvider) throws IOException {
        if (this.hasDocumentLevelPermissions()) {
            this.evaluateQueries(SecurityQueryTemplateEvaluator.wrap(user, scriptService));
            assert (this.listOfEvaluatedQueries != null) : "evaluated queries must not be null";
            assert (!this.listOfEvaluatedQueries.isEmpty()) : "evaluated queries must not be empty";
            BooleanQuery.Builder filter = new BooleanQuery.Builder();
            for (int i = this.listOfEvaluatedQueries.size() - 1; i > 0; --i) {
                BooleanQuery.Builder scopedFilter = new BooleanQuery.Builder();
                DocumentPermissions.buildRoleQuery(shardId, searchExecutionContextProvider, this.listOfEvaluatedQueries.get(i), scopedFilter);
                filter.add((Query)scopedFilter.build(), BooleanClause.Occur.FILTER);
            }
            DocumentPermissions.buildRoleQuery(shardId, searchExecutionContextProvider, this.listOfEvaluatedQueries.get(0), filter);
            return filter.build();
        }
        return null;
    }

    private void evaluateQueries(SecurityQueryTemplateEvaluator.DlsQueryEvaluationContext context) {
        if (this.listOfQueries != null && this.listOfEvaluatedQueries == null) {
            this.listOfEvaluatedQueries = this.listOfQueries.stream().map(queries -> queries.stream().map(context::evaluate).toList()).toList();
        }
    }

    private static void buildRoleQuery(ShardId shardId, Function<ShardId, SearchExecutionContext> searchExecutionContextProvider, List<String> queries, BooleanQuery.Builder filter) throws IOException {
        for (String query : queries) {
            SearchExecutionContext context;
            QueryBuilder queryBuilder = DLSRoleQueryValidator.evaluateAndVerifyRoleQuery(query, (context = searchExecutionContextProvider.apply(shardId)).getParserConfig().registry());
            if (queryBuilder == null) continue;
            DocumentPermissions.failIfQueryUsesClient(queryBuilder, (QueryRewriteContext)context);
            Query roleQuery = context.toQuery(queryBuilder).query();
            filter.add(roleQuery, BooleanClause.Occur.SHOULD);
            NestedLookup nestedLookup = context.nestedLookup();
            if (nestedLookup == NestedLookup.EMPTY) continue;
            NestedHelper nestedHelper = new NestedHelper(nestedLookup, arg_0 -> ((SearchExecutionContext)context).isFieldMapped(arg_0));
            if (nestedHelper.mightMatchNestedDocs(roleQuery)) {
                roleQuery = new BooleanQuery.Builder().add(roleQuery, BooleanClause.Occur.FILTER).add(Queries.newNonNestedFilter((Version)context.indexVersionCreated()), BooleanClause.Occur.FILTER).build();
            }
            BitSetProducer rootDocs = context.bitsetFilter(Queries.newNonNestedFilter((Version)context.indexVersionCreated()));
            ToChildBlockJoinQuery includeNestedDocs = new ToChildBlockJoinQuery(roleQuery, rootDocs);
            filter.add((Query)includeNestedDocs, BooleanClause.Occur.SHOULD);
        }
        filter.setMinimumNumberShouldMatch(1);
    }

    static void failIfQueryUsesClient(QueryBuilder queryBuilder, QueryRewriteContext original) throws IOException {
        QueryRewriteContext copy = new QueryRewriteContext(original.getParserConfig(), original.getWriteableRegistry(), null, () -> ((QueryRewriteContext)original).nowInMillis());
        Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)copy);
        if (copy.hasAsyncActions()) {
            throw new IllegalStateException("role queries are not allowed to execute additional requests");
        }
    }

    public static DocumentPermissions filteredBy(Set<BytesReference> queries) {
        return new DocumentPermissions(queries);
    }

    public static DocumentPermissions allowAll() {
        return ALLOW_ALL;
    }

    public DocumentPermissions limitDocumentPermissions(DocumentPermissions limitedByDocumentPermissions) {
        if (this.hasDocumentLevelPermissions() && limitedByDocumentPermissions.hasDocumentLevelPermissions()) {
            return new DocumentPermissions(Stream.concat(this.getListOfQueries().stream(), limitedByDocumentPermissions.getListOfQueries().stream()).toList());
        }
        if (this.hasDocumentLevelPermissions()) {
            return new DocumentPermissions(this.getListOfQueries());
        }
        if (limitedByDocumentPermissions.hasDocumentLevelPermissions()) {
            return new DocumentPermissions(limitedByDocumentPermissions.getListOfQueries());
        }
        return DocumentPermissions.allowAll();
    }

    public String toString() {
        return "DocumentPermissions [listOfQueries=" + this.listOfQueries + "]";
    }

    @Override
    public void buildCacheKey(StreamOutput out, SecurityQueryTemplateEvaluator.DlsQueryEvaluationContext context) throws IOException {
        assert (this.hasDocumentLevelPermissions()) : "document permissions should not contribute to cache key when there is no DLS query";
        this.evaluateQueries(context);
        out.writeCollection(this.listOfEvaluatedQueries, StreamOutput::writeStringCollection);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentPermissions that = (DocumentPermissions)o;
        return Objects.equals(this.listOfQueries, that.listOfQueries);
    }

    public int hashCode() {
        return Objects.hash(this.listOfQueries);
    }
}

