/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.support;

import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.util.concurrent.ReleasableLock;

public class CacheIteratorHelper<K, V> {
    private final Cache<K, V> cache;
    private final ReleasableLock updateLock;
    private final ReleasableLock iteratorLock;

    public CacheIteratorHelper(Cache<K, V> cache) {
        this.cache = cache;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.updateLock = new ReleasableLock(lock.readLock());
        this.iteratorLock = new ReleasableLock(lock.writeLock());
    }

    public ReleasableLock acquireUpdateLock() {
        return this.updateLock.acquire();
    }

    private ReleasableLock acquireForIterator() {
        return this.iteratorLock.acquire();
    }

    public void removeKeysIf(Predicate<K> removeIf) {
        try (ReleasableLock ignored = this.acquireForIterator();){
            Iterator iterator = this.cache.keys().iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                if (!removeIf.test(key)) continue;
                iterator.remove();
            }
        }
    }

    public void removeValuesIf(Predicate<V> removeIf) {
        try (ReleasableLock ignored = this.acquireForIterator();){
            Iterator iterator = this.cache.values().iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (!removeIf.test(value)) continue;
                iterator.remove();
            }
        }
    }
}

