/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.user.User;

public class XContentUtils {
    private XContentUtils() {
    }

    public static void verifyObject(XContentParser parser) throws IOException, ElasticsearchParseException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            return;
        }
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("expected an object, but found token [{}]", new Object[]{parser.currentToken()});
        }
    }

    public static String[] readStringArray(XContentParser parser, boolean allowNull) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            if (allowNull) {
                return null;
            }
            throw new ElasticsearchParseException("could not parse [{}] field. expected a string array but found null value instead", new Object[]{parser.currentName()});
        }
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("could not parse [{}] field. expected a string array but found [{}] value instead", new Object[]{parser.currentName(), parser.currentToken()});
        }
        ArrayList<String> list = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.VALUE_STRING) {
                list.add(parser.text());
                continue;
            }
            throw new ElasticsearchParseException("could not parse [{}] field. expected a string array but one of the value in the array is [{}]", new Object[]{parser.currentName(), token});
        }
        return list.toArray(new String[list.size()]);
    }

    public static void addAuthorizationInfo(XContentBuilder builder, Map<String, String> headers) throws IOException {
        Subject authenticationSubject;
        if (headers == null) {
            return;
        }
        String authKey = headers.get("_xpack_security_authentication");
        if (authKey == null) {
            return;
        }
        try {
            authenticationSubject = AuthenticationContextSerializer.decode(authKey).getEffectiveSubject();
        }
        catch (Exception e) {
            return;
        }
        builder.startObject("authorization");
        switch (authenticationSubject.getType()) {
            case USER: {
                builder.array(User.Fields.ROLES.getPreferredName(), authenticationSubject.getUser().roles());
                break;
            }
            case API_KEY: {
                builder.startObject("api_key");
                Map<String, Object> metadata = authenticationSubject.getMetadata();
                builder.field("id", metadata.get("_security_api_key_id"));
                Object name = metadata.get("_security_api_key_name");
                if (name instanceof String) {
                    builder.field("name", name);
                }
                builder.endObject();
                break;
            }
            case SERVICE_ACCOUNT: {
                builder.field("service_account", authenticationSubject.getUser().principal());
                break;
            }
            case REMOTE_ACCESS: {
                String message = "remote access authentication is not yet supported";
                assert (false) : "remote access authentication is not yet supported";
                throw new UnsupportedOperationException("remote access authentication is not yet supported");
            }
        }
        builder.endObject();
    }

    public static void maybeAddErrorDetails(XContentBuilder builder, Map<String, Exception> errors) throws IOException {
        if (!errors.isEmpty()) {
            builder.startObject("errors");
            builder.field("count", errors.size());
            builder.startObject("details");
            for (Map.Entry<String, Exception> idWithException : errors.entrySet()) {
                builder.startObject(idWithException.getKey());
                ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (Throwable)idWithException.getValue());
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
    }
}

